@php
$ad_conf = [
    ['code' => 0, 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];
@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5 mb-3">
    @include('admin.objects.components.vendor-tab', ['title' => '業者管理'])
    @include('admin.objects.components.regist-band', ['title' => '業者検索'])
    <div class="regist_vendor">
        <form method="POST" action="/admin/editVendor/{{$vendor_info['id']}}">
        {{ csrf_field() }}
            <div class="mb10">
                <table border="1" class="">
                    <tr>
                        <th class="w100">業者番号</th>
                        <td colspan="3">{{$vendor_info['id']}}</td>
                    </tr>
                    <tr>
                        <th>業者名</th>
                        <td colspan="3">
                            @include('admin.objects.components.input', ['name' => 'name', 'class' => 'w500', 'placeholder' => '業者名を入力', 'value' => $vendor_info['name']])
                        </td>
                    </tr>
                    <tr>
                        <th>業者名（カタカナ）</th>
                        <td colspan="3">
                            @include('admin.objects.components.input', ['name' => 'name_kana', 'class' => 'w500', 'placeholder' => '業者名（カタカナ）を入力', 'value' => $vendor_info['name_kana']])
                        </td>
                    </tr>
                    <tr>
                        <th>電話番号</th>
                        <td colspan="3">
                            @include('admin.objects.components.input', ['name' => 'vendor_tel1', 'class' => 'w250', 'placeholder' => '000-000-0000', 'value' => $vendor_info['vendor_tel1']])
                            @include('admin.objects.components.input', ['name' => 'vendor_tel2', 'class' => 'w250', 'placeholder' => '000-000-0000', 'value' => $vendor_info['vendor_tel2']])
                        </td>
                    </tr>
                    <tr>
                        <th>FAX番号</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'vendor_fax', 'class' => 'w250', 'placeholder' => '000-000-0000', 'value' => $vendor_info['vendor_fax']])
                        </td>
                        <th>メールアドレス</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'vendor_mail', 'class' => 'w250', 'placeholder' => '000@0000', 'value' => $vendor_info['vendor_mail']])
                        </td>
                    </tr>
                    <tr>
                        <th>住所</th>
                        <td colspan="3">
                            <div>
                                &#12306;@include('admin.objects.components.input', ['name' => 'zip', 'class' => 'mb-2', 'placeholder' => '000-0000', 'value' => $vendor_info['zip']])
                                @include('admin.objects.components.btn', ['title' => '郵便番号から住所決定', 'class' => 'btn_decision', 'id'=>'zipToAddress'])
                                @include('admin.objects.components.btn', ['title' => '住所から郵便番号決定', 'class' => 'btn_decision', 'id' => 'addressToZip'])
                            </div>
                            <div>
                                @include('admin.objects.components.selectbox', ['name' => 'address1', 'class' => 'mb-2', 'options' => $pref, 'title' => '都道府県', 'selected' => Config::get('const.DEFAULT_PREF'), 'selected' => $vendor_info['address1']])
                                @include('admin.objects.components.selectbox', ['name' => 'address2', 'class' => 'mb-2', 'options' => $city, 'title' => '市区郡', 'selected' => $vendor_info['address2']])
                                @include('admin.objects.components.selectbox', ['name' => 'address3', 'class' => 'mb-2', 'options' => $town, 'title' => '町村', 'selected' => $vendor_info['address3']])
                            </div>
                            <div>
                                @include('admin.objects.components.input', ['name' => 'address4', 'class' => 'w-50', 'placeholder' => '町村以降を入力', 'value' => $vendor_info['address4']])
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>ホームページ</th>
                        <td colspan="3">
                            @include('admin.objects.components.input', ['name' => 'vendor_url', 'class' => 'w500', 'placeholder' => 'https://', 'value' => $vendor_info['vendor_url']])
                        </td>
                    </tr>
                    <tr>
                        <th>営業時間</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'vendor_time', 'class' => 'w250', 'placeholder' => '00:00〜00:00', 'value' => $vendor_info['vendor_time']])
                        </td>
                        <th>定休日</th>
                        <td>
                            @include('admin.objects.components.input', ['name' => 'vendor_holiday', 'class' => 'w250', 'placeholder' => '曜日', 'value' => $vendor_info['vendor_holiday']])
                        </td>
                    </tr>
                </table>
            </div>
            <div class="search_vendor__btn">
                @include('admin.objects.components.regist-btn', ['class' => '', 'title' => '登録・保存'])
            </div>
        </form>
        
       
    </div>
</div>
@endsection