@php
$ad_conf = [
    ['code' => '', 'name' => ''],
    ['code' => 1, 'name' => '未'],
    ['code' => 2, 'name' => '可'],
    ['code' => 3, 'name' => '不可'],
];

$print = [
    ['code' => 1, 'name' => ''],
];

$all_check = [
    ['code' => 1, 'name' => '全件チェック'],
];

$change_price = [
    ['code' => 1, 'name' => '価格変更'],
];

@endphp
@extends('admin.layouts.base')

@section('contents')

<div class="mt5">
    @include('admin.objects.components.vendor-tab', ['title' => '業者管理'])
    @include('admin.objects.components.regist-band', ['title' => '業者検索'])
    <div class="result_vendor">
        <div class="d-flex justify-content-between pager mt10">
            <div class="m-2"><span class="pager-total">検索結果&nbsp;{{$list->total()}}</span><span>件中&nbsp; {{$first}}〜{{$last}}件表示</span></div>
            <div class="mt-2">{{ $list->appends($params)->links() }}</div>
        </div>
        <div class="d-flex mb10">
            <div class="pt-3 pl-2">
            @include('admin.objects.components.checkbox', ['name' => 'all_check_vendor', 'checkbox' => $all_check])
            </div>
            <form method="POST" action="{{ route('vendor-print') }}" target="_blank">
            {{ csrf_field() }}
                @include('admin.objects.components.btn', ['name' => 'print_fax', 'type' => 'button', 'class' => 'w300i btn_allcheck', 'title' => 'チェックした業者へ一括FAX'])
                @include('admin.objects.components.hidden', ['name' => 'print_id_list'])
                @include('admin.objects.components.hidden', ['name' => 'target_shop', 'value' => $search_shop])
            </form>
        </div>
        @foreach($list as $row)
        @if($disp_flag)
        <table class="p-vendor-list">
            <tr>
                <td rowspan="{{count($row->article)+1}}" class="parent_td p-vendor-list__checkarea">
                    @include('admin.objects.components.checkbox', ['name' => 'print', 'checkbox' => $print])
                    @include('admin.objects.components.hidden', ['name' => 'print_id', 'value' => $row->id])
                </td>
                <td class="w80">
                    <p>登録数</p>
                    <span><a href="#searchPanel" name="" class="target_link_id p-vendor-list__displink" >{{$row->count}}件</a></span>
                </td>
                <td class="w80">
                    <p>業者番号</p>
                    <span><a href="/admin/editVendor/{{$row->id}}" class="target_link_id">{{$row->id}}</a></span>
                </td>
                <td class="td_title">業者名</td>
                <td>{{$row->name}}</td>
                <td class="td_title">電話</td>
                <td class="w200">{{$row->vendor_tel1}}</td>
                <td class="td_title">FAX</td>
                <td class="w200">{{$row->vendor_fax}}</td>
            </tr>
            @foreach($row->article as $article)
            <tr class="child">
                <td colspan="8" class="article_list p-0" style="display: none;">
                    <form>
                    @include('admin.objects.components.hidden', ['name' => 'article_id', 'value' => $article->building_id])
                    @include('admin.objects.components.hidden', ['name' => 'vendor_id', 'value' => $row->id])
                        <table  class="p-vendor-list__subtbl">
                            <tr>
                                <td rowspan="4">
                                    <span class="row_iteration">{{$loop->iteration}}</span><br>
                                </td>
                                <td rowspan="4" class="w85">
                                    物件番号<br>
                                    <a href="
                                    @if($article->property == null)
                                    {{ route('showEditRoom', ['mid' => $article->mansion_id, 'id' => $article->building_id]) }}
                                    @elseif($article->property == 1)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 2)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 3)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 4)
                                    {{ route('showEditHouse', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 5)
                                    {{ route('showEditHouse', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 6)
                                    {{ route('showEditMansion', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 7)
                                    {{ route('showEditMansion', ['id' => $article->building_id]) }}
                                    @endif	
                                    " class="target_link_id">{{$article->building_id}}</a><br>
                                    物件登録日<br>
                                    <span class="p-vendor-list__subtbl__createdtext">{{$article->created_at}}</span>
                                    <span>{{$article->shop_name}}</span>
                                    <input type="button" value="保存" class="p-vendor-list__subtbl__btn">
                                </td>

                                <th>物件名</th>
                                <td colspan="3">{{$article->name}}</td>
                                <th>所在地</th>
                                <td colspan="3">{{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}</td>

                                <th>価格</th>
                                <td>{{$article->price}}万円</td>
                                <th>土地</th>
                                <td>{{$article->land_area_val}}m&sup2;</td>
                                <th>校区</th>
                                <td>
                                    {{$article->primary}} /{{$article->secondary}}
                                </td>
                            </tr>
                            <tr>
                                <th>種別</th>
                                <td>
                                @if($article->property == 1)
                                    土地	
                                @elseif($article->property == 2)
                                    土地（借地権）
                                @elseif($article->property == 3)
                                    土地（底地権）
                                @elseif($article->property == 4)
                                    戸建
                                @elseif($article->property == 5)
                                    テラスハウス
                                @elseif($article->property == 6)
                                    マンション
                                @elseif($article->property == 7)
                                    タウンハウス
                                @elseif($article->property == null)
                                    マンションー部屋
                                @endif
                                </td>
                                <th>間取り</th>
                                <td>
                                    @if(isset($article->floor_plan))
                                    {{$article->floor_plan}}{{$floor_type[$article->floor_plan_type]??'-'}}
                                    @else
                                    -
                                    @endif
                                </td>
                                <th>交通</th>
                                <td colspan="3">
                                {{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅　徒歩{{$article->main_traffic_time}}分
                                </td>
                                <th>築年月</th>
                                <td>
                                @if(isset($article->age_year)) {{$article->age_year}}/{{$article->age_month}} @else - @endif
                                </td>
                                <th>延床</th>
                                <td>
                                    {{$article->total_area_val?? '-'}}m&sup2;
                                </td>
                                <th>階数</th>
                                <td>

                                </td>
                            </tr>
                            <tr class="p-vendor-list__subtbl__savearea">
                                <td colspan="5" rowspan="2">
                                    
                                    <div class="d-flex">
                                        <div class="p-vendor-list__subtbl__savearea_ad">
                                            物件確認日<br>
                                            @include('admin.objects.components.input', ['name' => 'ad_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00', 'value' => $article->ad_conf_day])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">チラシ</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'flyer', 'options' => $ad_conf, 'selected' => $article->flyer])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">情報誌</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'freepaper', 'options' => $ad_conf, 'selected' => $article->freepaper])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">自社HP</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'house_hp', 'options' => $ad_conf, 'selected' => $article->house_hp])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">ポータル</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'portal', 'options' => $ad_conf, 'selected' => $article->portal])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">現地看板</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'signboard', 'options' => $ad_conf, 'selected' => $article->signboard])
                                        </div>
                                        <div class="">
                                            <span class="p-vendor-list__subtbl__select">確認手法</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'ad_conf', 'options' => $method_conf, 'selected' => $article->ad_conf])
                                        </div>
                                        <div>
                                            <span class="p-vendor-list__subtbl__select">広告確認日</span><br>
                                            @include('admin.objects.components.input', ['name' => 'article_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00', 'value' => $article->article_conf_day])
                                        </div>
                                    </div>
                                </td>
                                <td class="w125">
                                @include('admin.objects.components.input', ['name' => 'charge', 'value' => $article->charge, 'placeholder' => '', 'class' => 'w125'])
                                </td>
                                <td colspan="8">
                                @include('admin.objects.components.checkbox', ['name' => 'change_flag', 'checkbox' => $change_price])
                                @include('admin.objects.components.input', ['name' => 'change_price', 'value' => $article->price, 'placeholder' => '', 'class' => 'w65' ])万円
                                @include('admin.objects.components.input', ['name' => 'change_price_date', 'value' => $article->price_closing, 'class' => 'cal_picker w115'])
                                </td>
                            </tr>
                            <tr>
                                <td>
                                @include('admin.objects.components.selectbox', ['name' => 'manner', 'options' => $manner, 'selected' => $article->manner])
                                </td>
                                <td colspan="8">
                                @include('admin.objects.components.selectbox', ['name' => 'status', 'options' => $statuses, 'selected' => $article->status])
                                @include('admin.objects.components.input', ['name' => 'price_closing', 'value' => $article->price_closing, 'placeholder' => '成約価格', 'class' => 'w65', 'value' => $article->price_closing])万円
                                @include('admin.objects.components.input', ['name' => 'close_date', 'value' => $article->price_closing, 'class' => 'cal_picker w115', 'value' => $article->close_date])
                                </td>
                            </tr>
                        </table>
                    </form>
                </td>
            </tr>
            @endforeach
            
        </table>
        @else
        @if($row->count > 0)
        <table class="p-vendor-list">
            <tr>
                <td rowspan="{{count($row->article)+1}}" class="parent_td p-vendor-list__checkarea">
                    @include('admin.objects.components.checkbox', ['name' => 'print', 'checkbox' => $print])
                    @include('admin.objects.components.hidden', ['name' => 'print_id', 'value' => $row->id])
                </td>
                <td class="w80">
                    <p>登録数</p>
                    <span><a href="#searchPanel" name="" class="target_link_id p-vendor-list__displink" >{{$row->count}}件</a></span>
                </td>
                <td class="w80">
                    <p>業者番号</p>
                    <span><a href="/admin/editVendor/{{$row->id}}" class="target_link_id">{{$row->id}}</a></span>
                </td>
                <td class="td_title">業者名</td>
                <td>{{$row->name}}</td>
                <td class="td_title">電話</td>
                <td class="w200">{{$row->vendor_tel1}}</td>
                <td class="td_title">FAX</td>
                <td class="w200">{{$row->vendor_fax}}</td>
            </tr>
            @foreach($row->article as $article)
            <tr class="child">
                <td colspan="8" class="article_list p-0" style="display: none;">
                    <form>
                    @include('admin.objects.components.hidden', ['name' => 'article_id', 'value' => $article->building_id])
                    @include('admin.objects.components.hidden', ['name' => 'vendor_id', 'value' => $row->id])
                        <table  class="p-vendor-list__subtbl">
                            <tr>
                                <td rowspan="4">
                                    <span class="row_iteration">{{$loop->iteration}}</span><br>
                                </td>
                                <td rowspan="4" class="w85">
                                    物件番号<br>
                                    <a href="
                                    @if($article->property == null)
                                    {{ route('showEditRoom', ['mid' => $article->mansion_id, 'id' => $article->building_id]) }}
                                    @elseif($article->property == 1)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 2)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 3)
                                    {{ route('showEditLand', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 4)
                                    {{ route('showEditHouse', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 5)
                                    {{ route('showEditHouse', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 6)
                                    {{ route('showEditMansion', ['id' => $article->building_id]) }}
                                    @elseif($article->property == 7)
                                    {{ route('showEditMansion', ['id' => $article->building_id]) }}
                                    @endif	
                                    " class="target_link_id">{{$article->building_id}}</a><br>
                                    物件登録日<br>
                                    <span class="p-vendor-list__subtbl__createdtext">{{$article->created_at}}</span>
                                    <span>{{$article->shop_name}}</span>
                                    <input type="button" value="保存" class="p-vendor-list__subtbl__btn">
                                </td>

                                <th>物件名</th>
                                <td colspan="3">{{$article->name}}</td>
                                <th>所在地</th>
                                <td colspan="3">{{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}</td>

                                <th>価格</th>
                                <td>{{$article->price}}万円</td>
                                <th>土地</th>
                                <td>{{$article->land_area_val}}m&sup2;</td>
                                <th>校区</th>
                                <td>
                                    {{$article->primary}} /{{$article->secondary}}
                                </td>
                            </tr>
                            <tr>
                                <th>種別</th>
                                <td>
                                @if($article->property == 1)
                                    土地	
                                @elseif($article->property == 2)
                                    土地（借地権）
                                @elseif($article->property == 3)
                                    土地（底地権）
                                @elseif($article->property == 4)
                                    戸建
                                @elseif($article->property == 5)
                                    テラスハウス
                                @elseif($article->property == 6)
                                    マンション
                                @elseif($article->property == 7)
                                    タウンハウス
                                @elseif($article->property == null)
                                    マンションー部屋
                                @endif
                                </td>
                                <th>間取り</th>
                                <td>
                                    @if(isset($article->floor_plan))
                                    {{$article->floor_plan}}{{$floor_type[$article->floor_plan_type]}}
                                    @else
                                    -
                                    @endif
                                </td>
                                <th>交通</th>
                                <td colspan="3">
                                {{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅　徒歩{{$article->main_traffic_time}}分
                                </td>
                                <th>築年月</th>
                                <td>
                                @if(isset($article->age_year)) {{$article->age_year}}/{{$article->age_month}} @else - @endif
                                </td>
                                <th>延床</th>
                                <td>
                                    {{$article->total_area_val?? '-'}}m&sup2;
                                </td>
                                <th>階数</th>
                                <td>

                                </td>
                            </tr>
                            <tr class="p-vendor-list__subtbl__savearea">
                                <td colspan="5" rowspan="2">
                                    
                                    <div class="d-flex">
                                        <div class="p-vendor-list__subtbl__savearea_ad">
                                            物件確認日<br>
                                            @include('admin.objects.components.input', ['name' => 'ad_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00', 'value' => $article->ad_conf_day])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">チラシ</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'flyer', 'options' => $ad_conf, 'selected' => $article->flyer])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">情報誌</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'freepaper', 'options' => $ad_conf, 'selected' => $article->freepaper])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">自社HP</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'house_hp', 'options' => $ad_conf, 'selected' => $article->house_hp])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">ポータル</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'portal', 'options' => $ad_conf, 'selected' => $article->portal])
                                        </div>
                                        <div class="p-vendor-list__subtbl__savearea__ad">
                                            <span class="p-vendor-list__subtbl__select">現地看板</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'signboard', 'options' => $ad_conf, 'selected' => $article->signboard])
                                        </div>
                                        <div class="">
                                            <span class="p-vendor-list__subtbl__select">確認手法</span><br>
                                            @include('admin.objects.components.selectbox', ['name' => 'ad_conf', 'options' => $method_conf, 'selected' => $article->ad_conf])
                                        </div>
                                        <div>
                                            <span class="p-vendor-list__subtbl__select">広告確認日</span><br>
                                            @include('admin.objects.components.input', ['name' => 'article_conf_day', 'class' => 'cal_picker w115', 'placeholder' => '0000/00/00', 'value' => $article->article_conf_day])
                                        </div>
                                    </div>
                                </td>
                                <td class="w125">
                                @include('admin.objects.components.input', ['name' => 'charge', 'value' => $article->charge, 'placeholder' => '', 'class' => 'w125'])
                                </td>
                                <td colspan="8">
                                @include('admin.objects.components.checkbox', ['name' => 'change_flag', 'checkbox' => $change_price])
                                @include('admin.objects.components.input', ['name' => 'change_price', 'value' => $article->price, 'placeholder' => '', 'class' => 'w65' ])万円
                                @include('admin.objects.components.input', ['name' => 'change_price_date', 'value' => $article->price_closing, 'class' => 'cal_picker w115'])
                                </td>
                            </tr>
                            <tr>
                                <td>
                                @include('admin.objects.components.selectbox', ['name' => 'manner', 'options' => $manner, 'selected' => $article->manner])
                                </td>
                                <td colspan="8">
                                @include('admin.objects.components.selectbox', ['name' => 'status', 'options' => $statuses, 'selected' => $article->status])
                                @include('admin.objects.components.input', ['name' => 'price_closing', 'value' => $article->price_closing, 'placeholder' => '成約価格', 'class' => 'w65', 'value' => $article->price_closing])万円
                                @include('admin.objects.components.input', ['name' => 'close_date', 'value' => $article->price_closing, 'class' => 'cal_picker w115', 'value' => $article->close_date])
                                </td>
                            </tr>
                        </table>
                    </form>
                </td>
            </tr>
            @endforeach
            
        </table>
            @endif
        @endif
        @endforeach
    </div>
</div>
@include('admin.objects.projects.modal-message')
@endsection



