{{-- 「画像有」または「リスト」の切り替えタブ
    検索結果一覧の上部に配置 --}}
{{-- 
    $active: 'img' or 'list'を指定。指定されたほうが選択状態表示となる。
--}}
@php
    $active = $active ?? 'img';
    $imgActive = '';
    $listActive = '';
    if ($active=='img') {
        $imgActive = 'active';
        $listActive = '';
    } else {
        $imgActive = '';
        $listActive = 'active';
    }
@endphp

<ul class="c-tab-img-or-list nav" role="tablist">
    <li><a class="nav-item nav-link {{ $imgActive }}" id="nav-image-tab" data-toggle="tab" href="#nav-image" role="tab" aria-controls="nav-image">画像有</a></li>
    <li><a class="nav-item nav-link {{ $listActive }}" id="nav-list-tab" data-toggle="tab" href="#nav-list" role="tab" aria-controls="nav-list">リスト</a></li>
</ul>

{{-- ！！注意！！: 中身を別のbladeで作成しセットで使う。 --}}
{{-- 例）for-sale-list.blade
<div class="tab-content mt-3" id="">
  <div class="tab-pane {{ $imgActive }}" id="nav-image" role="tabpanel" aria-labelledby="nav-image-tab">画像ありでの表示です</div>
  <div class="tab-pane {{ $listActive }}" id="nav-list" role="tabpanel" aria-labelledby="nav-list-tab">リスト表示です</div>
</div>
--}}