{{-- 自社物件シート
    $type : 'for-sale', 'close', 'houses', 'mansion'のいずれかを設定。表示制御に利用。
--}}

@php
    $type = $type ?? 'for-sale';
@endphp


<div class="p-detail-main-sheet">
  <div class="d-flex justify-content-between">
    <div class="p-detail-main-sheet__left">
      <div class="p-detail-main-sheet__left-name d-flex justify-content-between">
        <h3>{{$item->article_name}}</h3>
      </div>
      @if($item->status == 4)
      <p class="p-detail-main-sheet__left-closed-price">契約済 / {{$item->price_closing}}万円（{{$item->close_date}}）</p>
      @endif
      @if($item->sheet_file_type == 2)
      <div>
        <p class="p-detail-main-sheet__left-catch">{{$item->catchcopy}}</p>
        <ul class="p-detail-main-sheet__left-points">
            <li class="p-detail-main-sheet__left-point">{!! nl2br(e($item->point)) !!}</li>
        </ul>
        <ul class="w-100 list-unstyled">
          <li class="p-detail-main-sheet__left-image">
            @if(!empty($item->disp_file))
            <img src="{{$item->disp_file}}"/>
            @else
            <img src="{{root('img/noimage2.jpg')}}"/>
            @endif
          </li>
        </ul>
        <table class="p-detail-main-sheet__left-etc">
          <tr>
            <th>周辺<br>施設</th>
            <td class="p-detail-main-sheet__left-etc-facility">
              <p></p>
            </td>
            <th>備考</th>
            <td>{{$item->memo1}}</td>
          </tr>
        </table>
      </div>
      @else
      <div>
        <ul class="w-100 list-unstyled">
          <li class="p-detail-main-sheet__left-image">
          @if(!empty($item->disp_file))
            <img src="{{$item->disp_file}}"/>
            @else
            <img src="{{root('img/noimage2.jpg')}}"/>
            @endif
          </li>
        </ul>
      </div>
      @endif
    </div>
    <div class="p-detail-main-sheet__right">
      <table class="p-detail-main-sheet__right-tbl">
        <tr>
          <th>所在地</th>
          <td colspan="3" class="clearfix">{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}
            <a class="ml-2 float-right p-detail-main-sheet__right-tbl-link" target="_blank" href="https://maps.google.co.jp/maps/search/{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}">&gt;Googleマップ</a>
          </td>
        </tr>
        <tr>
          <th>交通</th>
          <td colspan="3">{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
        </tr>
        <tr>
          <th>総区画数</th>
          <td colspan="3">{{$item->section}}区画（戸）</td>
        </tr>
        <tr>
          <th>敷地面積</th>
          <td colspan="3"></td>
        </tr>
        <tr>
          <th>地目</th>
          <td colspan="3">{{$item->ground_name}}</td>
        </tr>
        <tr>
          <th>建ぺい率</th>
          <td colspan="3">{{$item->building_rate}}%</td>
        </tr>
        <tr>
          <th>容積率</th>
          <td colspan="3">{{$item->volume_rate}}%</td>
        </tr>
        <tr>
          <th>地役権</th>
          <td colspan="3">{{$item->easement_name}}</td>
        </tr>
        <tr>
          <th>土地権利</th>
          <td colspan="3">{{$item->land_right_name}}</td>
        </tr>
        <tr>
          <th>用途地域</th>
          <td colspan="3">
          {{$item->use_area_name}}
            @if($item->use_area_name_sub != "")
            一部{{$item->use_area_name_sub}}を含む
            @endif
          </td>
        </tr>
        <tr>
          <th>都市計画</th>
          <td colspan="3">{{$item->city_plan_name}}</td>
        </tr>
        <tr>
          <th>分譲会社</th><td colspan="3">{{$item->sales_company?? '-'}}</td>
        </tr>
        <tr>
          <th>施工会社</th><td colspan="3">{{$item->construction_company?? '-'}}</td>
        </tr>
        <tr>
          <th>備考</th>
          <td colspan="3">{{$item->memo1}} {{$item->memo2}}</td>
        </tr>
        <tr>
          <th>周辺施設</th>
          <td colspan="3">            
            @foreach($item->facilirty_few as $facility)
                {{ $facility->name }}&nbsp;徒歩{{$facility->time}}分({{$facility->distance}}m)
            @endforeach
        </td>
        </tr>

      </table>
    </div>
  </div>
  <div class="p-detail-main-sheet__shop">
    <ul class="d-flex justify-content-between list-unstyled">
    <li>
        <p class="p-detail-main-sheet__shop-name">株式会社三春情報センター　{{$shop->name??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-tel">TEL.{{$shop->freedial??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-tel">〒{{$shop->zip??''}}{{$shop->pref_name??''}}{{$shop->city_name??''}}{{$shop->town_name??''}}</p>
      </li>
      <li>
        <p class="mb-1">分譲地番号：{{$item->building_id}}</p>
      </li>
    </ul>
  </div>
</div>
