{{-- 自社物件シート
    $type : 'for-sale', 'close', 'houses', 'mansion'のいずれかを設定。表示制御に利用。
--}}

@php
    $type = $type ?? 'for-sale';
@endphp


<div class="p-detail-main-sheet">
  <div class="d-flex justify-content-between">
    <div class="p-detail-main-sheet__left">
      <div class="p-detail-main-sheet__left-name d-flex justify-content-between">
        <h3>{{$item->article_name}}</h3>
      </div>
      @if($item->status == 4)
      <p class="p-detail-main-sheet__left-closed-price">契約済 / {{$item->price_closing}}万円（{{$item->close_date}}）</p>
      @endif
      <div>
        <p class="p-detail-main-sheet__left-catch">{{$item->catchcopy}}</p>
        <ul class="p-detail-main-sheet__left-points">
            <li class="p-detail-main-sheet__left-point">{!! nl2br(e($item->point)) !!}</li>
        </ul>
        <ul class="w-100 list-unstyled d-flex">
@foreach($photos as $photo)
          <li class="p-detail-main-sheet__left-image">
            <img src="{{$photo->disp_file_path}}" style="width:171px !important;">
          </li>
    @if($loop->iteration == 3)
        @php break; @endphp
    @endif
@endforeach
        </ul>
        <table class="p-detail-main-sheet__left-etc">
          <tr>
            <th>マンションコメント</th>
            <td class="p-detail-main-sheet__left-etc-facility">
              <p>{{$item->comment}}</p>
            </td>
          </tr>
        </table>
      </div>
    </div>
    <div class="p-detail-main-sheet__right">
      <table class="p-detail-main-sheet__right-tbl">
        <tr>
          <th>物件種別</th>
          <td colspan="3">{{$item->property_name}}</td>
        </tr>
        <tr>
          <th>所在地</th>
          <td colspan="3" class="clearfix">{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}{{$item->address}}
            <a class="ml-2 float-right p-detail-main-sheet__right-tbl-link" target="_blank" href="https://maps.google.co.jp/maps/search/{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}">&gt;Googleマップ</a>
          </td>
        </tr>
        <tr>
          <th>交通</th>
          <td colspan="3">{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
        </tr>
        <tr>
          <th>建物構造</th>
          <td colspan="3">{{$item->construction_name}}
            @if($item->construction_sub_name != "")・一部{{$item->construction_sub_name}}@endif</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>建ぺい率</th><td>{{$item->building_rate}}&nbsp;m&sup2;</td>
          <th>容積率</th><td>{{$item->volume_rate}}</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>築年月</th><td>{{$item->age_year}}年{{$item->age_month}}月</td>
          <th>総戸数</th><td>{{$item->total_unit}}戸</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>土地権利</th><td>{{$item->land_right_name}}</td>
          <th>敷地面積</th><td>{{$item->land_area_val}}m&sup2;</td>
        </tr>

        <tr>
          <th>用途地域</th><td colspan="3">
            {{$item->use_area_name}}
            @if($item->use_area_name_sub != "")
            一部{{$item->use_area_name_sub}}を含む
            @endif
          </td>
        </tr>
        <tr>
          <th>共用部</th><td colspan="3">-</td>
        </tr>
        <tr>
          <th>分譲会社</th><td colspan="3">{{$item->sales_company?? '-'}}</td>
        </tr>
        <tr>
          <th>施工会社</th><td colspan="3">{{$item->construction_company?? '-'}}</td>
        </tr>
        <tr>
          <th>管理会社</th><td colspan="3">{{$item->management_company}}</td>
        </tr>
        <tr>
          <th>管理形態</th><td colspan="3">{{$item->management_form_name}}</td>
        </tr>
        <tr>
          <th>ペット飼育</th>
          <td colspan="3"></td>
        </tr>
        <tr>
          <th>学校区</th>
          <td colspan="3">
            {{$item->primary_school_name}} / {{$item->secondary_school_name}}
          </td>
        </tr>
        <tr>
          <th>備考</th>
          <td colspan="3">{{$item->memo1}} {{$item->memo2}}</td>
        </tr>
        <tr>
          <th>周辺施設</th>
          <td colspan="3">
            @foreach($item->facilirty_few as $facility)
            {{ $facility->name }}&nbsp;徒歩{{$facility->time}}分({{$facility->distance}}m)
            @endforeach
          </td>
        </tr>
      </table>
    </div>
  </div>
  <div class="p-detail-main-sheet__shop">
    <ul class="d-flex justify-content-between list-unstyled">
      <li>
        <p class="p-detail-main-sheet__shop-name">株式会社三春情報センター　{{$shop->name??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-tel">TEL.{{$shop->freedial??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-tel">〒{{$shop->zip??''}}{{$shop->pref_name??''}}{{$shop->city_name??''}}{{$shop->town_name??''}}</p>
      </li>
      <li>
        <p class="mb-1">マンションID：{{$item->building_id}}</p>
      </li>
    </ul>
  </div>

</div>
