{{-- 自社物件シート
    $type : 'for-sale', 'close', 'houses', 'mansion'のいずれかを設定。表示制御に利用。
--}}

@php
    $type = $type ?? 'for-sale';
@endphp


<div class="p-detail-main-sheet">
  <div class="d-flex justify-content-between">
    <div class="p-detail-main-sheet__left">
      <div class="p-detail-main-sheet__left-name d-flex justify-content-between">
        <h3>{{$item->name}}&nbsp;{{$item->room_num}}</h3>
        <p class="p-detail-main-sheet__left-price"><span>{{$item->price}}</span>万円</p>
      </div>
      @if($item->status == 4)
      <p class="p-detail-main-sheet__left-closed-price">契約済 / {{$item->price_closing}}万円（{{$item->close_date}}）</p>
      @endif
      <div>
        <p class="p-detail-main-sheet__left-catch">{{$item->catchcopy}}</p>
        <ul class="p-detail-main-sheet__left-points">
            <li class="p-detail-main-sheet__left-point">{!! nl2br(e($item->point)) !!}</li>
        </ul>
        <ul class="w-100 list-unstyled d-flex">
@foreach($photos as $photo)
          <li class="p-detail-main-sheet__left-image">
            <img src="{{$photo->disp_file_path}}" style="width:171px !important;">
          </li>
    @if($loop->iteration == 3)
        @php break; @endphp
    @endif
@endforeach
        </ul>
        <table class="p-detail-main-sheet__left-etc">
          <tr>
            <th>マンションコメント</th>
            <td class="p-detail-main-sheet__left-etc-facility">
              <p>{{$item->comment}}</p>
            </td>
          </tr>
        </table>
      </div>
    </div>
    <div class="p-detail-main-sheet__right">
      <table class="p-detail-main-sheet__right-tbl">
        <tr>
          <th>物件種別</th>
          <td colspan="3">{{$item->property_name}}</td>
        </tr>
        <tr>
          <th>所在地</th>
          <td colspan="3" class="clearfix">{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}{{$item->address}}
            <a class="ml-2 float-right p-detail-main-sheet__right-tbl-link" target="_blank" href="https://maps.google.co.jp/maps/search/{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}">&gt;Googleマップ</a>
          </td>
        </tr>
        <tr>
          <th>交通</th>
          <td colspan="3">{{$mansion->main_traffic_line}}「{{$mansion->main_traffic_station}}」徒歩{{$mansion->main_traffic_time??'-'}}分</td>
        </tr>
        <tr>
          <th>建物構造</th>
          <td colspan="3">{{$item->construction_name}}
            @if($item->construction_sub_name != "")・一部{{$item->construction_sub_name}}@endif</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>建ぺい率</th><td>{{$mansion->building_rate}}&nbsp;m&sup2;</td>
          <th>容積率</th><td>{{$mansion->volume_rate}}</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>築年月</th><td>{{$mansion->age_year}}年{{$mansion->age_month}}月</td>
          <th>総戸数</th><td>{{$mansion->total_unit}}戸</td>
        </tr>
        <tr class="p-detail-main-sheet__right-tbl-row4">
          <th>土地権利</th><td>所有権</td>
          <th>敷地面積</th><td>{{$item->land_area_val}}m&sup2;</td>
        </tr>

        <tr>
          <th>用途地域</th><td colspan="3">-</td>
        </tr>
        <tr>
          <th>共用部</th><td colspan="3">-</td>
        </tr>
        <tr>
          <th>分譲会社</th><td colspan="3">{{$mansion->sales_company?? '-'}}</td>
        </tr>
        <tr>
          <th>施工会社</th><td colspan="3">{{$mansion->construction_company?? '-'}}</td>
        </tr>
        <tr>
          <th>管理会社</th><td colspan="3">{{$mansion->management_company}}</td>
        </tr>
        <tr>
          <th>管理形態</th><td colspan="3"></td>
        </tr>
        <tr>
          <th>ペット飼育</th>
          <td colspan="3"></td>
        </tr>
        <tr>
          <th>学校区</th>
          <td colspan="3"></td>
        </tr>
        <tr>
          <th>備考</th>
          <td colspan="3">{{$item['primary_school_name']?? "-"}}<br>{{$item['secondary_school_name']?? "-"}}</td>
        </tr>
        <tr>
          <th>周辺施設</th>
          <td colspan="3"></td>
        </tr>
      </table>
    </div>
  </div>
  <div class="p-detail-main-sheet__shop">
    <ul class="d-flex justify-content-between list-unstyled">
      <li>
        <p class="p-detail-main-sheet__shop-name">株式会社三春情報センター　{{$shop->name??''}}</p>
        <p class="p-detail-main-sheet__shop-address">〒{{$shop->zip??''}} {{$shop->pref_name??''}}{{$shop->city_name??''}}{{$shop->town_name??''}}{{$shop->address??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-tel">TEL.{{$shop->freedial??''}}</p>
        <p class="p-detail-main-sheet__shop-subtel">Tel.{{$shop->tel??'-'}} Fax.{{$shop->fax??''}}</p>
      </li>
      <li>
        <p class="p-detail-main-sheet__shop-etc">宅地建物取引業神奈川県知事免許(9)第13749号</p>
        <p class="p-detail-main-sheet__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
        <p class="p-detail-main-sheet__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
        <p class="p-detail-main-sheet__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
      </li>
      <li class="p-detail-main-sheet__shop-number-type pr-4">
        <p class="mb-1">物件番号：{{$item->building_id}}</p>
        <p class="">取引業態：{{$manner}}</p>
      </li>
    </ul>
  </div>
</div>
