<style type="text/css">
    @font-face {
        font-family: ipag;
        font-style: normal;
        font-weight: normal;
        src: url('{{ storage_path('fonts/ipag.ttf') }}') format('truetype');
    }

    @font-face {
        font-family: ipag;
        font-style: bold;
        font-weight: bold;
        src: url('{{ storage_path('fonts/ipag.ttf') }}') format('truetype');
    }

    body {
        font-family: ipag !important;
    }
.p-print {
    width: 1200px;
    /* border: 1px solid #7A7A7A; */
    padding: 3px 0;
    margin: 0px auto;
}
.sheet {
    color: #7A7A7A;
    width: 1123px;
    height: 794px;
    margin: 10px auto;
    border: 1px solid #7A7A7A;
    page-break-after: always;
}

.p-print-single {
  padding: 10px 20px;
}
.p-print-single ul {
  padding: 0;
}
.p-print-single__left {
  width: 50%;
}
.p-print-single__left-name {
  border-bottom: 2px solid #797979;
}
.p-print-single__left-name h3 {
  margin-bottom: 0;
  line-height: 40px;
  font-weight: bold;
  font-size: 26px;
}
.p-print-single__left-closed-price {
  text-align: right;
  font-size: 16px;
  font-weight: bold;
  margin-top: 5px;
}
.p-print-single__left-price {
  margin-bottom: 0;
  font-size: 20px;
  font-weight: bold;
}
.p-print-single__left-price span {
  font-size: 26px;
  margin-right: 5px;
}
.p-print-single__left-catch {
  font-size: 20px;
  font-weight: bold;
  margin: 10px 0;
}
.p-print-single__left-points {
  list-style: none;
  padding: 0;
}
.p-print-single__left-point {
  position: relative;
  margin-left: 15px;
  display: inline;
}
.p-print-single__left-point::before {
  content: "\25A0";
  position: absolute;
  top: 0;
  left: -15px;
}
.p-print-single__left-image {
  text-align: center;
  border: 1px solid #e3e3e3;
  padding: 10px;
}
.p-print-single__left-image img {
  max-height: 390px;
}
.p-print-single__left-etc {
  border-collapse: collapse;
  width: 100%;
  max-height: 100px;
}
.p-print-single__left-etc th, .p-print-single__left-etc td {
  border: 1px solid #e3e3e3;
}
.p-print-single__left-etc th {
  font-weight: normal;
  text-align: center;
  background: #f8f9fa;
  width: 55px;
  vertical-align: top;
  padding-top: 10px;
}
.p-print-single__left-etc td {
  font-weight: bold;
  padding: 0 5px;
  background: #ffffff;
}
.p-print-single__left-etc-facility {
  width: 300px;
}
.p-print-single__left-etc-facility p {
  margin: 0;
}
.p-print-single__right {
  width: 47%;
}
.p-print-single__right-tbl {
  border-collapse: collapse;
  width: 100%;
}
.p-print-single__right-tbl th, .p-print-single__right-tbl td {
  border: 1px solid #e3e3e3;
}
.p-print-single__right-tbl th {
  font-weight: normal;
  text-align: center;
  background: #f8f9fa;
  width: 100px;
  vertical-align: top;
  padding-top: 3px;
}
.p-print-single__right-tbl td {
  font-weight: bold;
  padding: 0 5px;
  background: #ffffff;
}
.p-print-single__right-tbl-link {
  color: #539ff7;
}
.p-print-single__right-tbl-link:hover {
  text-decoration: underline;
}
.p-print-single__right-tbl-row4 td {
  width: 192px;
}
.p-print-single__shop {
  margin: 15px 0 5px 0;
  padding: 10px 0;
  border-top: 2px solid #797979;
  border-bottom: 2px solid #797979;
}
.p-print-single__shop ul, .p-print-single__shop p {
  margin: 0;
}
.p-print-single__shop-name, .p-print-single__shop-tel {
  font-size: 20px;
  font-weight: bold;
}
.p-print-single__shop-address, .p-print-single__shop-subtel {
  font-size: 16px;
}
.p-print-single__shop-etc {
  font-size: 12px;
}
.p-print-single__shop-number-type {
  display: flex;
  flex-direction: column;
  justify-content: center;
}

.justify-content-between {
    justify-content: space-between!important;
}
.d-flex {
    display: flex!important;
}

</style>
@foreach($items as $item)
<section class="p-print">
    <div class="sheet p-pdf">
        <div class="p-print-single">
        <div class="d-flex justify-content-between p-pdf__clear">
            <div class="p-print-single__left p-pdf__l p-pdf__fl p-pdf__mr30">
            <div class="p-pdf__clear p-print-single__left-name d-flex justify-content-between">
                <h3 class="p-pdf__fl">{{$item->article_name}}</h3>
                <p class="p-pdf__fl p-print-single__left-price"><span>{{$item->price}}</span>万円</p>
            </div>
            @if($item->sheet_file_type == 2)
            <div>
                <p class="p-print-single__left-catch">{{$item->catchcopy}}</p>
                <ul class="p-print-single__left-points">
                    <li class="p-print-single__left-point">{{$item->point}}</li>
                </ul>
                <ul class="w-100 list-unstyled">
                <li class="p-print-single__left-image">
                    @if(!empty($item->disp_file))
                    <img src="{{$url}}{{$item->disp_file}}"/>
                    @else
                    <img src="{{$url}}{{root('img/noimage2.jpg')}}"/>
                    @endif
                </li>
                </ul>
                <table class="p-print-single__left-etc">
                <tr>
                    <th>周辺<br>施設</th>
                    <td class="p-print-single__left-etc-facility">
                    <p>TODO</p>
                    </td>
                    <th>備考</th>
                    <td>{{$item->memo1}}</td>
                </tr>
                </table>
            </div>
            @else
            <div>
                <ul class="w-100 list-unstyled">
                <li class="p-print-single__left-image">
                    @if(!empty($item->disp_file))
                    <img src="{{$url}}{{$item->disp_file}}"/>
                    @else
                    <img src="{{$url}}/img/noimage2.jpg"/>
                    @endif
                </li>
                </ul>
            </div>
            @endif
            </div>
            <div class="p-print-single__right p-pdf__r p-pdf__fl">
            <table class="p-print-single__right-tbl">
                <tr>
                <th class="p-pdf__w200">物件種別</th>
                <td colspan="3">{{$item->property_name}}</td>
                </tr>
                <tr>
                <th class="p-pdf__w200">所在地</th>
                <td colspan="3" class="clearfix">{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}
                    <a class="ml-2 float-right p-print-single__right-tbl-link" target="_blank" href="https://maps.google.co.jp/maps/search/{{$item->pref_name}}{{$item->city_name}}{{$item->town_name}}{{$item->address}}">&gt;Googleマップ</a>
                </td>
                </tr>
                <tr>
                <th class="p-pdf__w200">交通</th>
                <td colspan="3">{{$item['main_traffic_line']}}「{{$item['main_traffic_station']}}」徒歩{{$item['main_traffic_time']??'-'}}分</td>
                </tr>
                @if($item->property == 1 || $item->property == 2 || $item->property == 3)
        <tr>
          <th>土地面積</th>
          <td colspan="3">{{$item->land_area_val?? '-'}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>その他費用</th>
          <td colspan="3">
            <div>
              町会費など:
              @if($item->council == 1)
              町会費：
              @elseif($item->council == 2)
              町内会費：
              @elseif($item->council == 3)
              自治会費：
              @endif
              @if($item->council_presence == 0)
                  無し
              @elseif($item->council_presence == 1)
                  {{$item->council_cost}}円/@if($item->council_cost_unit == 1)月@elseif($item->council_cost_unit == 2)年@elseif($item->council_cost_unit == 3)一括@endif
              @elseif($item->council_presence == 2)
                  金額未定
              @endif
            </div>
            <div>
              温泉:
              @if($item->spring == 1)
                  温泉使用料：
              @elseif($item->spring == 2)
                  温泉権利金：
              @endif
              @if($item->spring_presence == 0)
                  無し
              @elseif($item->spring_presence == 1)
                  {{$item->spring_cost}}円/@if($item->spring_cost_unit == 1)月@elseif($item->spring_cost_unit == 2)年@elseif($item->spring_cost_unit == 3)一括@endif
              @elseif($item->spring_presence == 2)
                  金額未定
              @endif
            </div>
            <div>
              その他費用１:
              @if($item->another_cost_name1)
                  {{$item->another_cost_name1}}：{{$item->another_cost1}}万円/@if($item->another_cost_unit1 == 1)月@elseif($item->another_cost_unit1 == 2)年@elseif($item->another_cost_unit1 == 3)一括@endif
              @else
                  無し
              @endif
            </div>
            <div>
              その他費用２:
              @if($item->another_cost_name2)
                  {{$item->another_cost_name2}}：{{$item->another_cost2}}万円/@if($item->another_cost_unit2 == 1)月@elseif($item->another_cost_unit2 == 2)年@elseif($item->another_cost_unit2 == 3)一括@endif
              @else
                  無し
              @endif
            </div>
          </td>
        </tr>
        <tr>
          <th>接道</th>
          <td colspan="3">
            @if($item->land_kind1 == 1)
                公道
                @if($item->land_direction1 == 1)北@elseif($item->land_direction1 == 2)北東@elseif($item->land_direction1 == 3)東@elseif($item->land_direction1 == 4)南東@elseif($item->land_direction1 == 5)南@elseif($item->land_direction1 == 6)南西@elseif($item->land_direction1 == 7)西@elseif($item->land_direction1 == 8)北西@endif
                道路幅約{{$item->road_width1}}m&nbsp;間口約{{$item->frontage1}}m
            @elseif($item->land_kind1 == 2)
                私道
                @if($item->land_direction1 == 1)北@elseif($item->land_direction1 == 2)北東@elseif($item->land_direction1 == 3)東@elseif($item->land_direction1 == 4)南東@elseif($item->land_direction1 == 5)南@elseif($item->land_direction1 == 6)南西@elseif($item->land_direction1 == 7)西@elseif($item->land_direction1 == 8)北西@endif
                道路幅約{{$item->road_width1}}m&nbsp;間口約{{$item->frontage1}}m
            @endif
            
            @if($item->land_kind2 == 1)
                公道
                @if($item->land_direction2 == 1)北@elseif($item->land_direction2 == 2)北東@elseif($item->land_direction2 == 3)東@elseif($item->land_direction2 == 4)南東@elseif($item->land_direction2 == 5)南@elseif($item->land_direction2 == 6)南西@elseif($item->land_direction2 == 7)西@elseif($item->land_direction2 == 8)北西@endif
                道路幅約{{$item->road_width2}}m&nbsp;間口約{{$item->frontage2}}m
            @elseif($item->land_kind2 == 2)
                私道
                @if($item->land_direction2 == 1)北@elseif($item->land_direction2 == 2)北東@elseif($item->land_direction2 == 3)東@elseif($item->land_direction2 == 4)南東@elseif($item->land_direction2 == 5)南@elseif($item->land_direction2 == 6)南西@elseif($item->land_direction2 == 7)西@elseif($item->land_direction2 == 8)北西@endif
                道路幅約{{$item->road_width2}}m&nbsp;間口約{{$item->frontage2}}m
            @endif

            @if($item->land_kind3 == 1)
                公道
                @if($item->land_direction3 == 1)北@elseif($item->land_direction3 == 2)北東@elseif($item->land_direction3 == 3)東@elseif($item->land_direction3 == 4)南東@elseif($item->land_direction3 == 5)南@elseif($item->land_direction3 == 6)南西@elseif($item->land_direction3 == 7)西@elseif($item->land_direction3 == 8)北西@endif
                道路幅約{{$item->road_width3}}m&nbsp;間口約{{$item->frontage3}}m
            @elseif($item->land_kind3 == 2)
                私道
                @if($item->land_direction3 == 1)北@elseif($item->land_direction3 == 2)北東@elseif($item->land_direction3 == 3)東@elseif($item->land_direction3 == 4)南東@elseif($item->land_direction3 == 5)南@elseif($item->land_direction3 == 6)南西@elseif($item->land_direction3 == 7)西@elseif($item->land_direction3 == 8)北西@endif
                道路幅約{{$item->road_width3}}m&nbsp;間口約{{$item->frontage3}}m
            @endif
          </td>
        </tr>
        <tr>
          <th>セットパック</th><td colspan="3">{{$item->set_area}}m&sup2;</td>
        </tr>
        <tr>
          <th>私道負担</th><td colspan="3">@if($item->road_burden == 1)
                私道面積：{{$item->road_burden_area}}m&sup2;
            @elseif($item->road_burden == 2)
                私道面積：{{$item->road_burden_area}}m&sup2;
                私道持分比率 {{$item->road_numerator}}/{{$item->road_denominator}}
            @else
                無し
            @endif</td>
        </tr>
        <tr>
          <th>用途地域</th>
          <td colspan="3">
            {{$item->use_area_name??'-'}}@if($item->use_area_name != "" || $item->use_area_name != null) <br> @endif
            @if($item->use_area_name_sub != "")
                一部 {{$item->use_area_name_sub}}を含む<br>
            @endif
            @if($item->use_area_name_sub2 != "")
                一部 {{$item->use_area_name_sub2}}を含む<br>
            @endif
          </td>
        </tr>
        <tr>
          <th>建ぺい率</th><td colspan="3">{{$item->building_rate?? '-'}}%</td>
        </tr>
        <tr>
          <th>容積率</th><td colspan="3">{{$item->volume_rate?? '-'}}%</td>
        </tr>
        <tr>
          <th>地目</th><td colspan="3">{{$item->ground_name}}</td>
        </tr>
        <tr>
          <th>坂道レベル</th><td colspan="3">{{$item->original3?? '-'}}</td>
        </tr>
        <tr>
          <th>建築条件</th><td colspan="3">{{$item->land_condition_name}}</td>
        </tr>
        <tr>
          <th>総区画数</th><td colspan="3">{{$item->section?? '-'}}</td>
        </tr>
        <tr>
          <th>現況</th>
          <td colspan="3">
            @if($item->land_status_name != "")
            {{$item->land_status_name}}
            @else
            不明
            @endif
          </td>
        </tr>
        <tr>
          <th>引渡し</th>
          <td colspan="3">
            @if($item->land_delivery == 1)
                即日
            @elseif($item->land_delivery == 3)
                {{$item->delivery_year}}年{{$item->delivery_month}}月
                @if($item->land_delivery_time == 1)初旬@elseif($item->land_delivery_time == 2)上旬@elseif($item->land_delivery_time == 3)中旬@elseif($item->land_delivery_time == 4)下旬@elseif($item->land_delivery_time == 5)末@endif
            @endif
          </td>
        </tr>
        <tr>
          <th>設備</th>
          <td colspan="3">
            水道：{{$item->sewerage_name}}
            ガス：{{$item->gas_name}}
          </td>
        </tr>
        <tr>
          <th>取引態様</th><td colspan="3">{{$item->manner_name?? "-"}}</td>
        </tr>
        <tr>
          <th>学校区</th><td colspan="3">{{$item['primary_school_name']?? "-"}}<br>{{$item['secondary_school_name']?? "-"}}</td>
        </tr>

@elseif($item->property == 4 || $item->property == 5)
        <tr>
          <th>間取り</th>
          <td colspan="3">{{$item->floor_plan}}{{$item->floor_plan_name}}</td>
        </tr>
        <tr>
          <th>階数</th>
          <td colspan="3">{{$item->floor}}階建て</td>
        </tr>
        <tr>
          <th>建物構造</th>
          <td colspan="3">{{$item->construction_name}}
            @if($item->construction_sub_name != "")・一部{{$item->construction_sub_name}}@endif</td>
        </tr>
        <tr>
          <th>完成時期</th>
          <td colspan="3">            {{$item->completed_year}}年{{$item->completed_month}}月{{$item->completed_text??''}}</td>
        </tr>
        <tr>
          <th>土地面積</th>
          <td colspan="3">{{$item->land_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>建物面積</th>
          <td colspan="3">{{$item->total_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>その他費用</th>
          <td colspan="3">
            <dl class="overview__list">
                <div>
                  有線放送に係る費用:
                  @if($item->broadcasting == 1)
                      @if($item->broadcasting_presence == 1)
                          初期費用：{{$item->broadcasting_cost}}円
                      @elseif($item->broadcasting_presence == 2)
                          共有
                      @endif
                      @if($item->broadcasting_fixed_presence == 1)
                          定額費用：{{$item->broadcasting_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                      @elseif($item->broadcasting_fixed_presence == 2)
                          共有
                      @endif
                  @else
                      無し
                  @endif
                </div>
                <div>
                  インターネットに係る費用:
                  @if($item->internet == 1)
                      @if($item->internet_presence == 1)
                          初期費用：{{$item->internet_cost}}円
                      @elseif($item->internet_presence == 2)
                          共有
                      @endif
                      @if($item->internet_fixed_presence == 1)
                          定額費用：{{$item->internet_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                      @elseif($item->internet_fixed_presence == 2)
                          共有
                      @endif
                  @else
                      無し
                  @endif
                </div>
                <div>
                  CATVに係る費用:
                    @if($item->catv == 1)
                        @if($item->catv_presence == 1)
                            初期費用：{{$item->catv_cost}}円
                        @elseif($item->catv_presence == 2)
                            共有
                        @endif
                        @if($item->catv_fixed_presence == 1)
                            定額費用：{{$item->catv_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                        @elseif($item->catv_fixed_presence == 2)
                            共有
                        @endif
                    @else
                        無し
                    @endif
                  </div>
          </td>
        </tr>
        <tr>
          <th>接道</th>
          <td colspan="3">
            @if($item->land_kind1 == 1)
                公道
                @if($item->land_direction1 == 1)北@elseif($item->land_direction1 == 2)北東@elseif($item->land_direction1 == 3)東@elseif($item->land_direction1 == 4)南東@elseif($item->land_direction1 == 5)南@elseif($item->land_direction1 == 6)南西@elseif($item->land_direction1 == 7)西@elseif($item->land_direction1 == 8)北西@endif
                道路幅約{{$item->road_width1}}m&nbsp;間口約{{$item->frontage1}}m
            @elseif($item->land_kind1 == 2)
                私道
                @if($item->land_direction1 == 1)北@elseif($item->land_direction1 == 2)北東@elseif($item->land_direction1 == 3)東@elseif($item->land_direction1 == 4)南東@elseif($item->land_direction1 == 5)南@elseif($item->land_direction1 == 6)南西@elseif($item->land_direction1 == 7)西@elseif($item->land_direction1 == 8)北西@endif
                道路幅約{{$item->road_width1}}m&nbsp;間口約{{$item->frontage1}}m
            @endif
            
            @if($item->land_kind2 == 1)
                公道
                @if($item->land_direction2 == 1)北@elseif($item->land_direction2 == 2)北東@elseif($item->land_direction2 == 3)東@elseif($item->land_direction2 == 4)南東@elseif($item->land_direction2 == 5)南@elseif($item->land_direction2 == 6)南西@elseif($item->land_direction2 == 7)西@elseif($item->land_direction2 == 8)北西@endif
                道路幅約{{$item->road_width2}}m&nbsp;間口約{{$item->frontage2}}m
            @elseif($item->land_kind2 == 2)
                私道
                @if($item->land_direction2 == 1)北@elseif($item->land_direction2 == 2)北東@elseif($item->land_direction2 == 3)東@elseif($item->land_direction2 == 4)南東@elseif($item->land_direction2 == 5)南@elseif($item->land_direction2 == 6)南西@elseif($item->land_direction2 == 7)西@elseif($item->land_direction2 == 8)北西@endif
                道路幅約{{$item->road_width2}}m&nbsp;間口約{{$item->frontage2}}m
            @endif

            @if($item->land_kind3 == 1)
                公道
                @if($item->land_direction3 == 1)北@elseif($item->land_direction3 == 2)北東@elseif($item->land_direction3 == 3)東@elseif($item->land_direction3 == 4)南東@elseif($item->land_direction3 == 5)南@elseif($item->land_direction3 == 6)南西@elseif($item->land_direction3 == 7)西@elseif($item->land_direction3 == 8)北西@endif
                道路幅約{{$item->road_width3}}m&nbsp;間口約{{$item->frontage3}}m
            @elseif($item->land_kind3 == 2)
                私道
                @if($item->land_direction3 == 1)北@elseif($item->land_direction3 == 2)北東@elseif($item->land_direction3 == 3)東@elseif($item->land_direction3 == 4)南東@elseif($item->land_direction3 == 5)南@elseif($item->land_direction3 == 6)南西@elseif($item->land_direction3 == 7)西@elseif($item->land_direction3 == 8)北西@endif
                道路幅約{{$item->road_width3}}m&nbsp;間口約{{$item->frontage3}}m
            @endif
          </td>
        </tr>
        <tr>
          <th>セットパック</th><td colspan="3">{{$item->set_area}}m&sup2;</td>
        </tr>
        <tr>
          <th>私道負担</th><td colspan="3">@if($item->road_burden == 1)
                私道面積：{{$item->road_burden_area}}m&sup2;
            @elseif($item->road_burden == 2)
                私道面積：{{$item->road_burden_area}}m&sup2;
                私道持分比率 {{$item->road_numerator}}/{{$item->road_denominator}}
            @else
                無し
            @endif</td>
        </tr>
        <tr>
          <th>用途地域</th>
          <td colspan="3">
            {{$item->use_area_name??'-'}}@if($item->use_area_name != "" || $item->use_area_name != null) <br> @endif
            @if($item->use_area_name_sub != "")
                一部 {{$item->use_area_name_sub}}を含む<br>
            @endif
            @if($item->use_area_name_sub2 != "")
                一部 {{$item->use_area_name_sub2}}を含む<br>
            @endif
          </td>
        </tr>
        <tr>
          <th>建ぺい率</th><td colspan="3">{{$item->building_rate?? '-'}}%</td>
        </tr>
        <tr>
          <th>容積率</th><td colspan="3">{{$item->volume_rate?? '-'}}%</td>
        </tr>
        <tr>
          <th>地目</th><td colspan="3">{{$item->ground_name}}</td>
        </tr>
        <tr>
          <th>坂道レベル</th><td colspan="3">{{$item->original3?? '-'}}</td>
        </tr>
        <tr>
          <th>駐車場</th>
          <td colspan="3">
            @if($item->parking == 1)
                無
            @elseif($item->parking == 2)
                空無
            @elseif($item->parking == 3)
                空有
            @elseif($item->parking == 4)
                分譲（必購入）
            @elseif($item->parking == 5)
                分譲（任意購入）
            @elseif($item->parking == 6)
                専用使用権付
            @elseif($item->parking == 7)
                敷地外有
            @elseif($item->parking == 11)
                カースペース
            @elseif($item->parking == 12)
                カーポート
            @elseif($item->parking == 13)
                ２台以上
            @else
            -
            @endif
            @if($item->parking != 1 && $item->parking != null)
            @if($item->parking_yes == 1)
                {{$item->parking_yes_cost_from}}〜{{$item->parking_yes_cost_to}}円/@if($item->parking_yes_cost_unit == 1) 月 @else 年 @endif
            @endif
            @endif
          </td>
        </tr>
        <tr>
          <th>現況</th>
          <td colspan="3">
            @if($item->land_status_name != "")
            {{$item->land_status_name}}
            @else
            不明
            @endif
          </td>
        </tr>

        <tr>
          <th>入居予定</th>
          <td colspan="3">
            @if($item->move_in == 1)
                即引き渡し可
            @elseif($item->move_in == 2)
                相談
            @elseif($item->move_in == 3)
                {{$item->move_in_year}}年{{$item->move_in_month}}月
            @elseif($item->move_in == 4)
                契約後{{$item->move_in_contract_month}}ヶ月
            @elseif($item->move_in == 5)
                不明
            @endif
          </td>
        </tr>
        <tr>
          <th>設備</th>
          <td colspan="3">
            水道：{{$item->sewerage_name}}
            ガス：{{$item->gas_name}}
          </td>
        </tr>
        <tr>
          <th>建築確認番号</th><td colspan="3">{{$item->architecture_no}}</td>
        </tr>
        <tr>
          <th>開発許可番号</th><td colspan="3">{{$item->develop_num}}</td>
        </tr>
        <tr>
          <th>取引態様</th><td colspan="3">{{$item->manner_name?? "-"}}</td>
        </tr>
        <tr>
          <th>学校区</th><td colspan="3">-</td>
        </tr>
@elseif($item->property == 6 || $item->property == 7 || $item->property == null)
        <tr>
          <th>間取り</th><td colspan="3">{{$item->floor_plan}}{{$item->floor_plan_name}}</td>
        </tr>
        <tr>
          <th>所在階・階数</th><td colspan="3">{{$item->whereabouts}}/{{$item->floor}}階</td>
        </tr>
        <tr>
          <th>構造</th>
          <td colspan="3">{{$item->construction_name}}
            @if($item->construction_sub_name != "")・一部{{$item->construction_sub_name}}@endif</td>
        </tr>
        <tr>
          <th>築年月</th><td colspan="3">{{$item->age_year}}年{{$item->age_month}}月</td>
        </tr>
        <tr>
          <th>専有面積</th><td colspan="3">{{$item->total_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>バルコニー</th><td colspan="3">{{$item->balcony_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>テラス面積</th><td colspan="3">{{$item->terrace_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>専用庭面積</th><td colspan="3">{{$item->garden_area_val}}&nbsp;m&sup2;</td>
        </tr>
        <tr>
          <th>管理費</th><td colspan="3">{{$item->management_cost}}円</td>
        </tr>
        <tr>
          <th>修繕積立金</th><td colspan="3">{{$item->repair_cost}}円</td>
        </tr>
        <tr>
          <th>その他費用</th>
          <td colspan="3">
            <dl class="overview__list">
                <div>
                  有線放送に係る費用:
                  @if($item->broadcasting == 1)
                      @if($item->broadcasting_presence == 1)
                          初期費用：{{$item->broadcasting_cost}}円
                      @elseif($item->broadcasting_presence == 2)
                          共有
                      @endif
                      @if($item->broadcasting_fixed_presence == 1)
                          定額費用：{{$item->broadcasting_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                      @elseif($item->broadcasting_fixed_presence == 2)
                          共有
                      @endif
                  @else
                      無し
                  @endif
                </div>
                <div>
                  インターネットに係る費用:
                  @if($item->internet == 1)
                      @if($item->internet_presence == 1)
                          初期費用：{{$item->internet_cost}}円
                      @elseif($item->internet_presence == 2)
                          共有
                      @endif
                      @if($item->internet_fixed_presence == 1)
                          定額費用：{{$item->internet_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                      @elseif($item->internet_fixed_presence == 2)
                          共有
                      @endif
                  @else
                      無し
                  @endif
                </div>
                <div>
                  CATVに係る費用:
                    @if($item->catv == 1)
                        @if($item->catv_presence == 1)
                            初期費用：{{$item->catv_cost}}円
                        @elseif($item->catv_presence == 2)
                            共有
                        @endif
                        @if($item->catv_fixed_presence == 1)
                            定額費用：{{$item->catv_fixed_cost}}円/@if($item->running_cost_unit == 1)月@else年@endif
                        @elseif($item->catv_fixed_presence == 2)
                            共有
                        @endif
                    @else
                        無し
                    @endif
                  </div>
          </td>
        </tr>
        <tr>
          <th>用途地域</th>
          <td colspan="3">
            {{$item->use_area_name??'-'}}@if($item->use_area_name != "" || $item->use_area_name != null) <br> @endif
            @if($item->use_area_name_sub != "")
                一部 {{$item->use_area_name_sub}}を含む<br>
            @endif
            @if($item->use_area_name_sub2 != "")
                一部 {{$item->use_area_name_sub2}}を含む<br>
            @endif
          </td>
        </tr>
        <tr>
          <th>坂道レベル</th><td colspan="3">{{$item->original3}}</td>
        </tr>
        <tr>
          <th>総戸数</th><td colspan="3">{{$item->total_unit}}戸</td>
        </tr>
        <tr>
          <th>駐車場</th>
          <td colspan="3">
            @if($item->parking == 1)
                無
            @elseif($item->parking == 2)
                空無
            @elseif($item->parking == 3)
                空有
            @elseif($item->parking == 4)
                分譲（必購入）
            @elseif($item->parking == 5)
                分譲（任意購入）
            @elseif($item->parking == 6)
                専用使用権付
            @elseif($item->parking == 7)
                敷地外有
            @elseif($item->parking == 11)
                カースペース
            @elseif($item->parking == 12)
                カーポート
            @elseif($item->parking == 13)
                ２台以上
            @else
            -
            @endif
            @if($item->parking != 1 && $item->parking != null)
            @if($item->parking_yes == 1)
                {{$item->parking_yes_cost_from}}〜{{$item->parking_yes_cost_to}}円/@if($item->parking_yes_cost_unit == 1) 月 @else 年 @endif
            @endif
            @endif
          </td>
        </tr>
        <tr>
          <th>現況</th>
          <td colspan="3">
            @if($item->land_status_name != "")
            {{$item->land_status_name}}
            @else
            不明
            @endif
          </td>
        </tr>

        <tr>
          <th>引渡し</th>
          <td colspan="3">
            @if($item->land_delivery == 1)
                即日
            @elseif($item->land_delivery == 3)
                {{$item->delivery_year}}年{{$item->delivery_month}}月
                @if($item->land_delivery_time == 1)初旬@elseif($item->land_delivery_time == 2)上旬@elseif($item->land_delivery_time == 3)中旬@elseif($item->land_delivery_time == 4)下旬@elseif($item->land_delivery_time == 5)末@endif
            @endif
          </td>
        </tr>

        <tr>
          <th>設備</th>
          <td colspan="3">
            水道：{{$item->sewerage_name}}
            ガス：{{$item->gas_name}}
          </td>
        </tr>
        <tr>
          <th>管理形態</th><td colspan="3">{{$item->management_name}}</td>
        </tr>
        <tr>
          <th>管理会社</th><td colspan="3">{{$item->management_company}}</td>
        </tr>
        <tr>
          <th>取引態様</th><td colspan="3">{{$item->manner_name?? "-"}}</td>
        </tr>
        <tr>
          <th>学校区</th>
          <td colspan="3">{{$item['primary_school_name']?? "-"}}<br>{{$item['secondary_school_name']?? "-"}}</td>
        </tr>
@endif
            </table>
            </div>
        </div>
        <div class="p-print-single__shop">
            <ul class="d-flex justify-content-between list-unstyled p-pdf__clear">
            <li class="p-pdf__fl">
                <p class="p-print-single__shop-name">株式会社三春情報センター　{{$shop->name??''}}</p>
                <p class="p-print-single__shop-address">〒{{$shop->zip??''}} {{$shop->pref_name??''}}{{$shop->city_name??''}}{{$shop->town_name??''}}{{$shop->address??''}}</p>
            </li>
            <li class="p-pdf__fl">
                <p class="p-print-single__shop-tel">Tel.{{$shop->freedial??''}}</p>
                <p class="p-print-single__shop-subtel">Tel.{{$shop->tel??'-'}} Fax.{{$shop->fax??''}}</p>
            </li>
            <li class="p-pdf__fl">
                <p class="p-print-single__shop-etc">宅地建物取引業神奈川県知事免許(9)第13749号</p>
                <p class="p-print-single__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
                <p class="p-print-single__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
                <p class="p-print-single__shop-etc">（公社）神奈川県宅地建物取引業協会会員</p>
            </li>
            <li class="p-print-single__shop-number-type pr-4 p-pdf__fl">
                <p class="mb-1">物件番号：{{$item->building_id}}</p>
                <p class="">取引業態：{{$item->manner_name}}</p>
            </li>
            </ul>
        </div>
        </div>
    </div>
</section>
<section class="p-print">
    <div class="sheet p-pdf">
    @if(!empty($item->disp_sheet_file))
    <img src="{{$url}}{{$item->disp_sheet_file}}" style="max-height: 794px; height: 100%;"/>
    @else
    <img src="{{$url}}/img/noimage2.jpg" style="max-height: 794px; height: 100%;"/>
    @endif
    </div>
</section>
@endforeach