@extends('business.layouts.base')

@php 
$type = $type ?? 'print';
$title = '';
if ($type == 'print') {
    $title = '印刷';
} else {
    $title = 'PDF';
}
@endphp

@section('contents')
<section class="p-modal-print">
    <p class="p-modal-print__title">{{ $title }}するセットをお選びください。</p>
    
    <ul class="p-modal-print__list d-flex justify-content-center p-0">
        <li class="p-modal-print__list-li">
            <div class="p-modal-print__list-subtitle">
                <div class="p-modal-print__list-circle p-modal-print__list-circle--yellow">
                    <p>自社帯<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_gray.png">
                </div>
            </div>
            <div class="p-modal-print__list-btn">
                <ul class="p-modal-print__list-btn-list">
                    <li class="mb-2">@include('business.objects.components.link-btn', ['title' => '全物件', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                    <li>@include('business.objects.components.link-btn', ['title' => '当物件のみ', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                </ul>
            </div>
        </li>
        <li class="p-modal-print__list-li">
            <div class="p-modal-print__list-subtitle">
                <div class="p-modal-print__list-circle p-modal-print__list-circle--green">
                    <p>業者<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_white.png">
                </div>
            </div>
            <div class="p-modal-print__list-btn">
                <ul class="p-modal-print__list-btn-list">
                    <li class="mb-2">@include('business.objects.components.link-btn', ['title' => '全物件', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                    <li>@include('business.objects.components.link-btn', ['title' => '当物件のみ', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                </ul>
            </div>
        </li>
        <li class="p-modal-print__list-li">
            <div class="p-modal-print__list-subtitle d-flex justify-content-between">
                <div class="p-modal-print__list-circle p-modal-print__list-circle--yellow">
                    <p>自社帯<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_gray.png">
                </div>
                <div class="p-modal-print__list-plus"><span></span></div>
                <div class="p-modal-print__list-circle p-modal-print__list-circle--green">
                    <p>業者<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_white.png">
                </div>
            </div>
            <div class="p-modal-print__list-btn">
                <ul class="p-modal-print__list-btn-list">
                    <li class="mb-2">@include('business.objects.components.link-btn', ['title' => '全物件', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                    <li>@include('business.objects.components.link-btn', ['title' => '当物件のみ', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                </ul>
            </div>
        </li>
        <li class="p-modal-print__list-li">
            <div class="p-modal-print__list-subtitle d-flex justify-content-between">
                <div class="p-modal-print__list-circle p-modal-print__list-circle--yellow">
                    <p>自社帯<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_gray.png">
                </div>
                <div class="p-modal-print__list-plus"><span></span></div>
                <div class="p-modal-print__list-circle p-modal-print__list-circle--blue">
                    <p>マンション<br>リスト</p>
                    <img src="../../business/img/icon_list_gray.png">
                </div>
            </div>
            <div class="p-modal-print__list-btn">
                <ul class="p-modal-print__list-btn-list">
                    <li class="mb-2">@include('business.objects.components.link-btn', ['title' => '全物件', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                    <li>@include('business.objects.components.link-btn', ['title' => '当物件のみ', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                </ul>
            </div>
        </li>
        <li class="p-modal-print__list-li">
            <div class="p-modal-print__list-subtitle d-flex justify-content-between">
                <div class="p-modal-print__list-circle p-modal-print__list-circle--yellow">
                    <p>自社帯<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_gray.png">
                </div>
                <div class="p-modal-print__list-plus"><span></span></div>
                <div class="p-modal-print__list-circle p-modal-print__list-circle--green">
                    <p>業者<br>物件シート</p>
                    <img src="../../business/img/icon_sheet_white.png">
                </div>
                <div class="p-modal-print__list-plus"><span></span></div>
                <div class="p-modal-print__list-circle p-modal-print__list-circle--blue">
                    <p>マンション<br>リスト</p>
                    <img src="../../business/img/icon_list_gray.png">
                </div>
            </div>
            <div class="p-modal-print__list-btn">
                <ul class="p-modal-print__list-btn-list">
                    <li class="mb-2">@include('business.objects.components.link-btn', ['title' => '全物件', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                    <li>@include('business.objects.components.link-btn', ['title' => '当物件のみ', 'url' => '#', 'class' => 'p-modal-print__list-link-btn'])</li>
                </ul>
            </div>
        </li>
    </ul>

</section>

@endsection