{{-- 写真あり
    $type : 'for-sale', 'close', 'houses', 'mansion'のいずれかを設定。詳細リンクURLに利用。
--}}
@php
$routeName = '';
$type = $type ?? 'for-sale';
if ($type == 'for-sale') {
    $routeName = 'business-for-sale-detail';
} else if($type == 'close') {
    $routeName = 'business-close-detail';
} else if($type == 'lot') {
    $routeName = 'business-houses-detail';
} else {
    $routeName = 'business-mansion-detail';
}
@endphp
<ul class="p-results-image list-unstyled">
@foreach($article_list as $item)
    <li class="p-results-image__li">
        <div class="p-results-image__li-head d-flex justify-content-between">
            <div>
                <div class="d-flex">
                    <p class="p-results-image__li-name">{{$item->name}}（{{$item->main_traffic_station}}）</p>
                    <a href="javascript:void(0);" class="p-results-image__li-link-mansion" id="btnParentDetail{{$item->building_id}}"><img src="../../business/img/icon_detail.png"></a>
                </div>
                <ul class="d-flex list-unstyled">
                    @foreach($item->property_list as $property)
                    <li class="p-results-image__mark--used">{{$property}}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        <div class="p-results-image__image-area d-flex">
            <div class="p-results-image__image__lot">
                @if(!empty($item->disp_file))
                <img src="{{$item->disp_file}}" width="200" />
                @else
                <img src="{{root('img/noimage2.jpg')}}" width="200" />
                @endif
            </div>
        
                <table class="p-results-image__main-info">
                    <tr class="p-results-image__main-info-price">
                        <th>売出物件</th><td><a href="javascript:void(0);" class="disp_room">{{$item->lot_count}}<span>件</span></a></td>
                    </tr>
                    <tr class="p-results-image__main-info-address">
                        <th>所在地</th><td>{{$item->address}}</td>
                    </tr>
                    <tr class="p-results-image__main-info-access">
                        <th>交通</th><td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                    </tr>
                </table>

                <table class="p-results-image__main-info">
                    <tr class="p-results-image__main-info-other">
                        <th>分譲地番号</th><td>{{$item->building_id}}</td>
                    </tr>
                    <tr class="p-results-image__main-info-other">
                        <th>総区画数</th><td>{{$item->section}}</td>
                    </tr>
                    <tr class="p-results-image__main-info-other">
                        <th>学校区</th><td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
                    </tr>
                </table>

        </div>
        @foreach($item->lot_list as $lot)
        <div class="p-mansion-room">
            <table class="p-mansion-room__tbl">
                <tr>
                    <td class="p-mansion-room__tbl-number" rowspan="2">物件番号<br>{{$lot->building_id}}</td>
                    <th>物件名</th>
                    <td class="p-mansion-room__tbl__w200">{{$lot->name}}</td>
                    <th>価格</th>
                    <td>{{$lot->price?? '-'}}<span>万円</span></td>
                    <th>土地</th>
                    <td>{{$lot->total_area_val?? '-'}}m&sup2;</td>
                    <th>間取り</th>
                    <td>{{$lot->floor_plan_text?? '-'}}</td>
                    <td colspan="2"></td>
                    <td colspan="3" rowspan="2">
                        <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnCheck', 'class' => 'c-circle-btn__check-mansion', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_check.png', 'title' => '確認'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDetail'.$lot->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => 'javascript:void(0);',
                                    'img' => '../../business/img/icon_detail.png', 'title' => '詳細'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDisplay', 'class' => 'c-circle-btn__disp-mansion', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_display.png', 'title' => '表示'])
                            </li>
                        </ul>
                    </td>
                </tr>
                <tr>
                    <th>種別</th>
                    <td>{{$lot->property_name}}</td>
                    <th>築年月</th>
                    <td>{{$lot->age_year?? '-'}}年{{$lot->age_month?? '-'}}月</td>
                    <th>延床</th>
                    <td>{{$lot->total_area_val?? '-'}}m&sup2;</td>
                    <th>階数</th>
                    <td>{{$lot->whereabouts?? '-'}}</td>
                    <td colspan="2"><p class="p-results-image__info-photo align-self-end">
                <img src="../../business/img/icon_camera.png" alt="写真">{{$lot->file_count}}</p></td>
                </tr>
            </table>

            {{-- 確認ボタンクリック時に表示する --}}
            @include('business.objects.projects.form-check-lot', ['data_num' => $loop->iteration, 'history_count' => count($lot->history)])
            @include('business.objects.projects.modal-history', ['history' => $lot->history, 'data_num' => $loop->iteration])
        </div>
        @endforeach
    </li>
@endforeach
</ul>
