{{-- 写真あり
    $type : 'for-sale', 'close', 'houses', 'mansion'のいずれかを設定。詳細リンクURLに利用。
--}}
@php
$routeName = '';
$type = $type ?? 'for-sale';
if ($type == 'for-sale') {
    $routeName = 'business-for-sale-detail';
} else if($type == 'close') {
    $routeName = 'business-close-detail';
} else if($type == 'lot') {
    $routeName = 'business-houses-detail';
} else {
    $routeName = 'business-mansion-detail';
}
@endphp
<ul class="p-results-image list-unstyled">
@foreach($article_list as $item)
    <li class="p-results-image__li">
        <div class="p-results-image__li-head d-flex justify-content-between">
            <div>
                <div class="d-flex">
                    <p class="p-results-image__li-name">{{$item->name}}（{{$item->main_traffic_station}}）</p>
                    @if($item->property == null)<a href="javascript:void(0);" class="p-results-image__li-link-mansion" id="btnParentDetail{{$item->mansion_id}}"><img src="../../business/img/icon_detail.png"></a>@endif
                </div>
                <ul class="d-flex list-unstyled">
                    <li class="p-results-image__mark--used">{{$item->property_name}}</li>
                    @if($item->new)<li class="p-results-image__mark--new">NEW</li>@endif
                    @if($item->exterior == 2 || $item->interior == 2)<li class="p-results-image__mark--reform">リフォーム済</li>@endif
                </ul>
            </div>
            <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
@if($flag == 1 || $flag == 2)
                <li>
                    @include('business.objects.components.circle-btn',
                        ['id' => 'btnCheck', 'class' => 'c-circle-btn__check', 'linkUrl' => '#',
                        'img' => '../../business/img/icon_check.png', 'title' => '確認'])
                </li>
@endif
                <li>
                    @include('business.objects.components.circle-btn',
                        ['id' => 'btnDetail'.$item->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => 'javascript:void(0);',
                        'img' => '../../business/img/icon_detail.png', 'title' => '詳細'])
                </li>
                <li>
                    @include('business.objects.components.circle-btn',
                        ['id' => 'btnDisplay', 'class' => 'c-circle-btn__display', 'linkUrl' => '#',
                        'img' => '../../business/img/icon_display.png', 'title' => '表示'])
                </li>
            </ul>
        </div>
        <div class="p-results-image__image-area d-flex">
            <div class="p-results-image__image">
                @if(!empty($item->top_file_path))
                <img src="{{$item->top_file_path}}" width="160" />
                @else
                <img src="{{root('img/noimage2.jpg')}}" width="160" />
                @endif
                
                @if(!empty($item->floor_file_path))
                <img src="{{$item->floor_file_path}}" width="160" />
                @else
                <img src="{{root('img/noimage2.jpg')}}" width="160" />
                @endif

            </div>
            <table class="p-results-image__main-info">
                <tr class="p-results-image__main-info-price">
                    <th>物件価格</th><td>{{$item->price}}<span>万円</span></td>
                </tr>
                <tr class="p-results-image__main-info-address">
                    <th>所在地</th><td>{{$item->address}}</td>
                </tr>
                <tr class="p-results-image__main-info-access">
                    <th>交通</th><td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                </tr>
            </table>
        </div>

        <div class="p-results-image__info d-flex justify-content-between">
            <table class="p-results-image__info-table">
                <tr>
                    <th>物件番号</th>
                    <td colspan="3">{{$item->building_id}}</td>
                    <th>築年月</th>
                    <td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
                    <th>築年数</th>
                    <td>{{$item->age?? "-"}}年</td>
                </tr>
                <tr>
                    <th>間取り・階数</th>
                    <td colspan="3">{{$item->floor_plan_text?? "-"}}・{{$item->whereabouts?? "-"}}階</td>
                    <th>現況</th>
                    <td>{{$item->current_status?? "-"}}</td>
                    <th>向き</th>
                    <td>-</td>
                </tr>
                <tr>
                    <th>延床面積</th>
                    <td>{{$item->total_area_val?? "-"}}m&sup2;</td>
                    <th>土地面積</th>
                    <td>{{$item->land_area_val?? "-"}}m&sup2;</td>
                    <th>学校区</th>
                    <td colspan="3">{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
                </tr>
            </table>
            <p class="p-results-image__info-photo align-self-end">
                <img src="../../business/img/icon_camera.png" alt="写真">{{$item->file_count}}</p>
        </div>
        {{-- 確認ボタンクリック時に表示する --}}
        @include('business.objects.projects.form-check', ['data_num' => $loop->iteration, 'history_count' => count($item->history)])
        @include('business.objects.projects.modal-history', ['history' => $item->history, 'data_num' => $loop->iteration])
    </li>
@endforeach
</ul>
