{{-- 並び替え --}}
<div class="p-results-noimage">
@foreach($article_list as $item)
    <div class="mb-3 mansion-list">
        <table class="p-results-noimage__tbl">
            <tr>
                <td rowspan="2" class="p-results-noimage__tbl-num-date">
                    <p><span class="p-results-noimage__tbl-number">分譲地ID</span><br><a href="/business/editMansion/{{$item->building_id}}" class="target_link_id">{{$item->building_id}}</a></p>
                    <p class="mt-1"><a href="javascript:void(0);" class="p-results-current-condition__panel--btn-delete disp_room_noimage" name="show_room_btn">売出({{$item->lot_count}})</a></p>
                </td>
                <th class="w70">物件名</th>
                <td class="w250">
                    <div class="d-flex justify-content-between">
                        <p>{{$item->name}}</p>
                        <a href="javascript:void(0);" class="p-results-image__li-link-mansion" id="btnParentDetail{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion">
                        <!-- <a href="/business/editMansion/{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion"> -->
                            <img src="../../business/img/toroku.png">
                        </a>
                    </div>
                </td>
                <th class="w70">住所</th><td>{{$item->address}}</td>
                <th class="w70">校区</th><td class="w250">{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
            </tr>
            <tr>
                <th class="w100">総区画数</th>
                <td>{{$item->section}}区画</td>
                <th>交通</th><td>{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <th></th><td></td>
            </tr>
        </table>
        @foreach($item->lot_list as $lot)
        <div class="p-mansion-room">
            <table class="p-mansion-room__tbl">
                <tr>
                    <td class="p-mansion-room__tbl-number">物件番号<br>{{$lot->building_id}}</td>
                    <th>部屋</th>
                    <td class="p-mansion-room__tbl__w200">{{$lot->room_num}}号室</td>
                    <th>価格</th>
                    <td>{{$lot->price?? '-'}}<span>万円</span></td>
                    <th>専有</th>
                    <td>{{$lot->total_area_val?? '-'}}m&sup2;</td>
                    <th>間取り</th>
                    <td>{{$lot->floor_plan_text?? '-'}}</td>
                    <th>階数</th>
                    <td>@if($lot->maisonette == 1) {{$lot->maisonette_from?? '-'}}階〜{{$lot->maisonette_to?? '-'}}階部分 @else {{$lot->whereabouts?? '-'}}階 @endif</td>
                    <td colspan="3">
                        <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnCheck', 'class' => 'c-circle-btn__check-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_check.png', 'title' => '確認'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDetail'.$lot->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => 'javascript:void(0);',
                                    'img' => '../../business/img/icon_detail.png', 'title' => '詳細'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDisplay', 'class' => 'c-circle-btn__disp-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_display.png', 'title' => '表示'])
                            </li>
                        </ul>
                    </td>
                </tr>
            </table>

            {{-- 確認ボタンクリック時に表示する --}}
            @include('business.objects.projects.form-check', ['data_num' => $loop->iteration+$lot_count, 'history_count' => count($lot->history)])
            @include('business.objects.projects.modal-history', ['history' => $lot->history, 'data_num' => $loop->iteration+$lot_count])
        </div>
        @endforeach
    </div>
@endforeach
</div>
