{{-- 並び替え --}}
<div class="p-results-noimage">
@foreach($article_list as $item)
    <div class="mb-3 mansion-list">
        <table class="p-results-noimage__tbl">
            <tr>
                <td rowspan="2" class="p-results-noimage__tbl-num-date">
                    <p><span class="p-results-noimage__tbl-number">マンションID</span><br><a href="/business/editMansion/{{$item->building_id}}" class="target_link_id">{{$item->building_id}}</a></p>
                    <p class="mt-1"><a href="javascript:void(0);" class="p-results-current-condition__panel--btn-delete disp_room_noimage" name="show_room_btn">売出({{$item["room_count"]}})</a></p>
                </td>
                <th>物件名</th>
                <td colspan="2">
                    <div class="d-flex justify-content-between">
                        <p>{{$item->name}}</p>
                        <a href="javascript:void(0);" class="p-results-image__li-link-mansion" id="btnParentDetail{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion">
                        <!-- <a href="/business/editMansion/{{$item->building_id}}" class="p-results-noimage__tbl-link-mansion"> -->
                            <img src="../../business/img/toroku.png">
                        </a>
                    </div>
                </td>
                <th>所在地</th><td colspan="2">{{$item->address}}</td>
                <th>築年月</th><td>{{$item->age_year?? "-"}}年{{$item->age_month?? "-"}}月</td>
                <th>校区</th><td>{{$item->primary_school_name?? "-"}}/{{$item->secondary_school_name?? "-"}}</td>
            </tr>
            <tr>
                <th>種別</th>
                <td colspan="2">
                        @if($item->property == 6)
                            @if($item->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            マンション
                        @elseif($item->property == 7)
                            @if($item->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            タウンハウス
                        @endif		
                </td>
                <th>交通</th><td colspan="2">{{$item->main_traffic_line}}「{{$item->main_traffic_station}}」徒歩{{$item->main_traffic_time??'-'}}分</td>
                <th>総戸数</th><td>{{$item->total_unit?? "-"}}戸</td>
                <th>階数</th><td>{{$item->floor}}階建</td>
            </tr>
        </table>
        @foreach($item->room_list as $room)
        <div class="p-mansion-room">
            <table class="p-mansion-room__tbl">
                <tr>
                    <td class="p-mansion-room__tbl-number">物件番号<br>{{$room->building_id}}</td>
                    <th>部屋</th>
                    <td>{{$room->room_num}}号室</td>
                    <th>価格</th>
                    <td>{{$room->price?? '-'}}<span>万円</span></td>
                    <th>専有</th>
                    <td>{{$room->total_area_val?? '-'}}m&sup2;</td>
                    <th>間取り</th>
                    <td>{{$room->floor_plan_text?? '-'}}</td>
                    <th>階数</th>
                    <td class="p-mansion-room__tbl__w200
                    ">@if($room->maisonette == 1) {{$room->maisonette_from?? '-'}}階〜{{$room->maisonette_to?? '-'}}階部分 @else {{$room->whereabouts?? '-'}}階 @endif</td>
                    <td colspan="3">
                        <ul class="p-results-image__li-btns d-flex justify-content-end list-unstyled">
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnCheck', 'class' => 'c-circle-btn__check-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_check.png', 'title' => '確認'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDetail'.$room->building_id, 'class' => 'c-circle-btn__detail', 'linkUrl' => 'javascript:void(0);',
                                    'img' => '../../business/img/toroku.png', 'title' => '詳細'])
                            </li>
                            <li>
                                @include('business.objects.components.circle-btn-mansion',
                                    ['id' => 'btnDisplay', 'class' => 'c-circle-btn__disp-mansion_noimage', 'linkUrl' => '#',
                                    'img' => '../../business/img/icon_display.png', 'title' => '表示'])
                            </li>
                        </ul>
                    </td>
                </tr>
            </table>

            {{-- 確認ボタンクリック時に表示する --}}
            @include('business.objects.projects.form-check-mansion', ['data_num' => $loop->iteration+$room_count, 'history_count' => count($room->history)])
            @include('business.objects.projects.modal-history', ['history' => $room->history, 'data_num' => $loop->iteration+$room_count])
        </div>
        @endforeach
    </div>
@endforeach
</div>
