<div class="p-search-mansion">
    <table class="p-search-mansion__tbl">
        <tr>
            <td rowspan="7" class="p-search-mansion__tbl-number">01</td>
            <th>マンション名</th>
            <td class="p-search-mansion__name">
                @include('business.objects.components.input', ['name' => 'name', 'class' => 'p-search-mansion__name-txt'])
            </td>
            <th>マンションID</th>
            <td class="p-search-mansion__id">
                @include('business.objects.components.input', ['name' => 'id', 'class' => 'p-search-mansion__id-txt'])
            </td>
            <th>築年数</th>
            <td class="p-search-mansion__years">
                @include('business.objects.components.input', ['name' => 'years_from', 'placeholder' => '下限なし', 'class' => 'p-search-mansion__years-from'])〜
                @include('business.objects.components.input', ['name' => 'years_to', 'placeholder' => '上限なし', 'class' => 'p-search-mansion__years-to'])年
            </td>
            <th>築年月</th>
            <td class="p-search-mansion__year-month">
                @include('business.objects.components.input', ['name' => 'year_month_from', 'placeholder' => '0000/00', 'class' => 'p-search-mansion__year-month-from'])〜
                @include('business.objects.components.input', ['name' => 'year_month_to', 'placeholder' => '0000/00', 'class' => 'p-search-mansion__year-month-to'])
            </td>
        </tr>
        <tr>
            <th>所在地</th>
            <td colspan="3" class="p-search-mansion__address">
                @include('business.objects.components.selectbox', ['name' => 'address1', 'options' => [['code' => '14', 'name' => '神奈川県']], 'title' => '都道府県', 'class' => 'p-search-mansion__address-pref'])
                @include('business.objects.components.selectbox', ['name' => 'address2', 'options' => [['code' => '1', 'name' => '横浜市保土ヶ谷区']], 'title' => '市区郡', 'class' => 'p-search-mansion__address-city'])
                @include('business.objects.components.selectbox', ['name' => 'address3', 'options' => [['code' => '1', 'name' => '鶴見中央五丁目']], 'title' => '町村', 'class' => 'p-search-mansion__address-town'])
                @include('business.objects.components.input', ['name' => 'address4', 'class' => 'p-search-mansion__address-address4'])
            </td>
            <th>階建</th>
            <td class="p-search-mansion__floor">
                @include('business.objects.components.input', ['name' => 'floor_from', 'placeholder' => '下限なし', 'class' => 'p-search-mansion__floor-from'])〜
                @include('business.objects.components.input', ['name' => 'floor_to', 'placeholder' => '上限なし', 'class' => 'p-search-mansion__floor-to'])階建
            </td>
            <th>総戸数</th>
            <td class="p-search-mansion__total-floor">
                @include('business.objects.components.input', ['name' => 'total_floor_from', 'placeholder' => '下限なし', 'class' => 'p-search-mansion__total-floor-from'])〜
                @include('business.objects.components.input', ['name' => 'total_floor_to', 'placeholder' => '上限なし', 'class' => 'p-search-mansion__total-floor-to'])戸
            </td>
        </tr>
        <tr>
            <th>交通</th>
            <td colspan="5" class="p-search-mansion__access">
                @include('business.objects.components.selectbox', ['name' => 'access1', 'options' => [['code' => '1', 'name' => '横浜高速鉄道みなとみらい線']], 'title' => '沿線', 'class' => 'p-search-mansion__access-along'])
                @include('business.objects.components.selectbox', ['name' => 'access2', 'options' => [], 'title' => '駅', 'class' => 'p-search-mansion__access-station'])
                @include('business.objects.components.selectbox', ['name' => 'access3', 'options' => [['code' => '0', 'name' => '徒歩'], ['code' => '1', 'name' => 'バス']], 'title' => '徒歩/バス'])
                <span class="ml-2 mr-1">バス</span>@include('business.objects.components.input', ['name' => 'bus', 'class' => 'p-search-mansion__access-bus'])<span>分以内 / 徒歩</span>
                @include('business.objects.components.input', ['name' => 'walk', 'class' => 'p-search-mansion__access-walk'])<span>分以内</span>
            </td>
            <th>ペット</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'is_pet', 'options' => [['code' => '1', 'name' => '可'],['code' => '0', 'name' => '不可']], 'title' => '可or不可'])
                @include('business.objects.components.selectbox', ['name' => 'pet_num', 'options' => [], 'title' => '匹数'])
            </td>
        </tr>
        <tr>
            <th>学校区</th>
            <td colspan="3" class="p-search-mansion__school">
                <div class="mb-2">
                @include('business.objects.components.selectbox', ['name' => 'primary_school', 'options' => [], 'title' => '小学校区', 'class' => 'p-search-mansion__school-primary'])
                徒歩@include('business.objects.components.input', ['name' => 'primary_school_walk', 'class' => 'p-search-mansion__school-primary-walk'])<span>分以内</span>
                </div>
                <div>
                @include('business.objects.components.selectbox', ['name' => 'secondary_school', 'options' => [], 'title' => '中学校区', 'class' => 'p-search-mansion__school-secondary'])
                徒歩@include('business.objects.components.input', ['name' => 'secondary_school_walk', 'class' => 'p-search-mansion__school-secondary-walk'])<span>分以内</span>
                </div>
            </td>
            <th>用途地域</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'use_area', 'options' => [], 'title' => ''])
            </td>
            <th>駐車場</th>
            <td>
                @include('business.objects.components.selectbox', ['name' => 'parking', 'options' => [], 'title' => '駐車場'])
            </td>
        </tr>
        <tr>
            <th rowspan="2">共用部</th>
            <td rowspan="2" colspan="5" class="p-search-mansion__shared">
                @include('admin.objects.components.checkbox', ['name' => 'shared',
                    'checkbox' => [
                        ['code'=>'1', 'name'=>'ゲストルーム'], ['code'=>'2', 'name'=>'24時間ゴミ出し可']
                       ,['code'=>'3', 'name'=>'プール'], ['code'=>'4', 'name'=>'エレベーター']]
                ])<br>
                @include('admin.objects.components.checkbox', ['name' => 'shared',
                    'checkbox' => [
                        ['code'=>'5', 'name'=>'宅配ボックス'], ['code'=>'6', 'name'=>'キッズルーム・託児所']
                       ,['code'=>'7', 'name'=>'共用露天風呂']]
                ])
            </td>
            <th>事業主</th>
            <td>
                @include('business.objects.components.input', ['name' => 'owner', 'placeholder' => '', 'class' => 'p-search-mansion__owner'])
            </td>
        </tr>
        <tr>
            <th>施工</th>
            <td>
                @include('business.objects.components.input', ['name' => 'construction', 'placeholder' => '', 'class' => 'p-search-mansion__construction'])
            </td>
        </tr>
        <tr>
            <td colspan="8">
                <ul class="p-search-mansion__search-clear">
                    <li><a href="#">この条件をクリア</a></li>
                    <li><a href="#">この条件を削除</a></li>
                </ul>
            </td>
        </tr>
    </table>
</div>
