@extends('business.layouts.base')

{{-- header --}}
@section('contents-header')
    @include('business.objects.projects.detail-header', ['type' => 'close' ,'number' => '1', 'totalCount' => '10'])
@endsection

@php
  // tab
  $tabs = [];

  $tab = new stdClass();
  $tab->title = '自社物件シート';
  $tab->id = 'nav-property-tab';
  $tab->href = 'nav-property';
  $tab->active = 'active';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '写真';
  $tab->id = 'nav-photo-tab';
  $tab->href = 'nav-photo';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '地図・周辺施設';
  $tab->id = 'nav-map-tab';
  $tab->href = 'nav-map';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '業者物件シート';
  $tab->id = 'nav-vendor-tab';
  $tab->href = 'nav-vendor';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '物件概要';
  $tab->id = 'nav-summary-tab';
  $tab->href = 'nav-summary';
  $tab->active = '';
  array_push($tabs, $tab);

@endphp

@section('contents')
<div class="mt-4">
  @include('business.objects.projects.results-noimage', ['data' => [$data]])

  {{-- tab contents --}}
  @include('business.objects.projects.detail-tab', ['tabs' => $tabs])
  <div class="tab-content">
    <div class="tab-pane bg-white active" id="nav-property" role="tabpanel" aria-labelledby="nav-property-tab">
      @include('business.objects.projects.detail-main-sheet', ['type' => 'close', 'data' => $data])
    </div>
    <div class="tab-pane bg-white" id="nav-photo" role="tabpanel" aria-labelledby="nav-photo-tab">
      @include('business.objects.projects.detail-photo', ['data' => $data])
    </div>
    <div class="tab-pane bg-white" id="nav-map" role="tabpanel" aria-labelledby="nav-map-tab">
      @include('business.objects.projects.detail-map-around', ['data' => $data])
    </div>
    <div class="tab-pane bg-white" id="nav-vendor" role="tabpanel" aria-labelledby="nav-vendor-tab">
      {{--@include('business.objects.projects.detail-map-around', ['data' => $data])--}}
    </div>
    <div class="tab-pane bg-white" id="nav-summary" role="tabpanel" aria-labelledby="nav-summary-tab">
      @include('business.objects.projects.detail-summary', ['data' => $data])
    </div>
  </div>

</div>
@endsection
