@extends('business.layouts.base')

{{-- header --}}
@section('contents-header')
    @include('business.objects.projects.detail-header', ['number' => '1', 'totalCount' => '10'])
@endsection

@php 
  // tab
  $tabs = [];
  
  if($disp_flag == 1) {
    $tab = new stdClass();
    $tab->title = '自社物件シート';
    $tab->id = 'nav-property-tab';
    $tab->href = 'nav-property';
    $tab->active = '';
    array_push($tabs, $tab);
  } else {
    $tab = new stdClass();
    $tab->title = '自社物件シート';
    $tab->id = 'nav-property-tab';
    $tab->href = 'nav-property';
    $tab->active = 'active';
    array_push($tabs, $tab);
  }



  $tab = new stdClass();
  $tab->title = '写真';
  $tab->id = 'nav-photo-tab';
  $tab->href = 'nav-photo';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '地図・周辺施設';
  $tab->id = 'nav-map-tab';
  $tab->href = 'nav-map';
  $tab->active = '';
  array_push($tabs, $tab);

  if($disp_flag == 1) {
    $tab = new stdClass();
    $tab->title = '業者物件シート';
    $tab->id = 'nav-sheet-tab';
    $tab->href = 'nav-sheet';
    $tab->active = 'active';
    array_push($tabs, $tab);
  }
  $tab = new stdClass();
  $tab->title = '物件概要';
  $tab->id = 'nav-summary-tab';
  $tab->href = 'nav-summary';
  $tab->active = '';
  array_push($tabs, $tab);

@endphp

@section('contents')
<div class="mt-4">
  @include('business.objects.projects.results-noimage', ['data' => [$item], 'disp_flag' => $disp_flag])


  {{-- tab contents --}}
  @include('business.objects.projects.detail-tab', ['tabs' => $tabs])
  <div class="tab-content">
    <div class="tab-pane bg-white @if($disp_flag != 1) active @endif" id="nav-property" role="tabpanel" aria-labelledby="nav-property-tab">
      @include('business.objects.projects.detail-main-sheet', ['data' => $article_list])
    </div>
    <div class="tab-pane bg-white" id="nav-photo" role="tabpanel" aria-labelledby="nav-photo-tab">
      @include('business.objects.projects.detail-photo', ['data' => $article_list])
    </div>
    <div class="tab-pane bg-white" id="nav-map" role="tabpanel" aria-labelledby="nav-map-tab">
      @include('business.objects.projects.detail-map-around', ['data' => $article_list])
    </div>
@if($disp_flag == 1)
    <div class="tab-pane bg-white active" id="nav-sheet" role="tabpanel" aria-labelledby="nav-sheet-tab">
      @include('business.objects.projects.detail-vendor-sheet', ['data' => $article_list])
    </div>
@endif
    <div class="tab-pane bg-white" id="nav-summary" role="tabpanel" aria-labelledby="nav-summary-tab">
      @include('business.objects.projects.detail-summary', ['data' => $article_list])
    </div>
  </div>

</div>
@endsection
