@extends('business.layouts.base')


{{-- header --}}
@section('contents-header')
    @include('business.objects.projects.search-results-header', ['title' => '売出物件'])
@endsection

@php
$buttons = [
    ['id'=>'notHold', 'title' => '「済・保」除外', 'class' => 'notCondition'],
    ['id'=>'notClosed', 'title' => '「済」除外', 'class' => 'notCondition'],
    ['id'=>'notEtc', 'title' => '「済等」除外', 'class' => 'notCondition'],
    ['id'=>'btnAllDisp', 'title' => '全物件表示', 'class' => 'notCondition']];

// 並び替えデータ
$sorts = $sorts ?? [];

$sort = new stdClass();
$sort->name = '新着順';
$sort->class = 'new';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '新価格';
$sort->class = 'newprice';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '価格が安い順';
$sort->class = 'inexpensive';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '駅近い順';
$sort->class = 'station';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '築年浅い順';
$sort->class = 'age';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '土地面積広い順';
$sort->class = 'land';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '延べ床面積広い順';
$sort->class = 'floor';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '物件種別順';
$sort->class = 'property';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '所在地順';
$sort->class = 'address';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '沿線・駅順';
$sort->class = 'line';
array_push($sorts, $sort);

$sort = new stdClass();
$sort->name = '業者順';
$sort->class = 'vendor';
array_push($sorts, $sort);
@endphp


@section('contents')
{{-- 画像有/リスト切り替え、除外ボタンリスト --}}
@include('business.objects.projects.results-switching', ['buttons' => $buttons])

{{-- 現在の検索条件 --}}
@include('business.objects.projects.results-current-condition', [])
{{-- 並び替え --}}
@include('business.objects.projects.results-sort', ['sorts' => $sorts])

@include('business.objects.projects.form-to-other', ['action' => route('business-for-sale-detail', ['id' => '']), 'id' => 'link_detail', 'params' => $params])

{{-- 検索結果一覧 ※tab-img-or-list.bladeと連動 --}}
<div class="tab-content mt-3">
  <div class="tab-pane u-bg-default active" id="nav-image" role="tabpanel" aria-labell edby="nav-image-tab">
    @include('business.objects.projects.results-image', ['type' => 'for-sale', 'flag' => 1])
  </div>
  <div class="tab-pane u-bg-default" id="nav-list" role="tabpanel" aria-labelledby="nav-list-tab">
    @include('business.objects.projects.results-noimage', ['data' => $article_list, 'flag' => 1])
  </div>
</div>

@endsection
