@extends('business.layouts.base')

{{-- header --}}
@section('contents-header')
    @include('business.objects.projects.detail-header', ['number' => '1', 'totalCount' => '10'])
@endsection

@php 
  // tab
  $tabs = [];
  
  $tab = new stdClass();
  $tab->title = '自社物件シート';
  $tab->id = 'nav-property-tab';
  $tab->href = 'nav-property';
  $tab->active = 'active';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '売出・成約';
  $tab->id = 'nav-summary-tab';
  $tab->href = 'nav-summary';
  $tab->active = '';
  array_push($tabs, $tab);

@endphp

@section('contents')
<div class="mt-4">

  {{-- tab contents --}}
  @include('business.objects.projects.detail-tab', ['tabs' => $tabs])
  <div class="tab-content">
    <div class="tab-pane bg-white active" id="nav-property" role="tabpanel" aria-labelledby="nav-property-tab">
      @include('business.objects.projects.detail-main-lot-sheet')
    </div>
    <div class="tab-pane bg-white" id="nav-summary" role="tabpanel" aria-labelledby="nav-summary-tab">
      @include('business.objects.projects.detail-soldout-lot')
    </div>
  </div>

</div>
@endsection
