@extends('business.layouts.base')

{{-- header --}}
@section('contents-header')
    @include('business.objects.projects.detail-header', ['number' => '1', 'totalCount' => '10'])
@endsection

@php 
  // tab
  $tabs = [];
  
  $tab = new stdClass();
  $tab->title = '自社物件シート';
  $tab->id = 'nav-property-tab';
  $tab->href = 'nav-property';
  $tab->active = 'active';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '写真';
  $tab->id = 'nav-photo-tab';
  $tab->href = 'nav-photo';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '地図・周辺施設';
  $tab->id = 'nav-map-tab';
  $tab->href = 'nav-map';
  $tab->active = '';
  array_push($tabs, $tab);

  $tab = new stdClass();
  $tab->title = '売出・成約';
  $tab->id = 'nav-summary-tab';
  $tab->href = 'nav-summary';
  $tab->active = '';
  array_push($tabs, $tab);

@endphp

@section('contents')
<div class="mt-4">

  {{-- tab contents --}}
  @include('business.objects.projects.detail-tab', ['tabs' => $tabs])
  <div class="tab-content">
    <div class="tab-pane bg-white active" id="nav-property" role="tabpanel" aria-labelledby="nav-property-tab">
      @include('business.objects.projects.detail-main-mansion-sheet')
    </div>
    <div class="tab-pane bg-white" id="nav-photo" role="tabpanel" aria-labelledby="nav-photo-tab">
      @include('business.objects.projects.detail-photo', ['data' => $article_list])
    </div>
    <div class="tab-pane bg-white" id="nav-map" role="tabpanel" aria-labelledby="nav-map-tab">
      @include('business.objects.projects.detail-map-around', ['data' => $article_list])
    </div>
    <div class="tab-pane bg-white" id="nav-summary" role="tabpanel" aria-labelledby="nav-summary-tab">
      @include('business.objects.projects.detail-soldout', ['data' => $article_list])
    </div>
  </div>

</div>
@endsection
