@extends('home.template')
@section('head')
@endsection

@section('content')
<div class="wrapper">
    <div class="two-column--area">
        <div class="two-column__side">
            @include('home.area.side')
        </div>
        <div class="two-column__main">
            <section class="area-main">
                <h2 class="area-main__title">
                {{$station->name}}駅周辺の不動産の購入
                </h2>
                <div class="area-main__wrapper">
                    <div class="area-main__school-first">
                        <div class="area-main__images--school">
                            <img src="{{root('img/area/school.jpg')}}" alt="">
                        </div>
                        <div class="area-main__links--school">
                          <a href="" class="area-main__link">
                              <i class="fab fa-sistrix"></i>{{$station->name}}駅のすべての物件（000）<i class="fas fa-chevron-right"></i>
                          </a>
                            <a href="" class="area-main__link">
                                <i class="far fa-building"></i>{{$station->name}}駅の中古マンション（000）<i class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__link">
                                <i class="fas fa-home"></i>{{$station->name}}駅の新築一戸建て（000）<i class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__link">
                                <i class="fas fa-home"></i>{{$station->name}}駅の中古一戸建て（000）<i class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__link">
                                <i class="fas fa-street-view"></i>{{$station->name}}駅の土地（000）<i class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                    </div>

                </div>
                <div class="area-main__info">
                    <div class="area-main__info-title">
                    {{$station->line}}「{{$station->name}}」駅の特徴
                    </div>
                    <div class="area-main__info-text-long">
                    {{$station->memo}}
                    </div>
                    <div class="area-main__info-images">
                        <img src="{{root('img/area/fam.png')}}" alt="">
                    </div>
                </div>
                <div class="area-main__wrapper">
                    <div class="area-main__details-title">
                        <i class="fas fa-subway"></i>{{$station->line}}「{{$station->name}}」駅の基本情報
                    </div>
                    <div class="area-main__lists">
                        <dl class="area-main__list">
                            <dt>停車する電車</dt>
                            <dd>{{$station->stop_train}}</dd>
                        </dl>
                        <dl class="area-main__list">
                            <dt>主要駅までの所要時間</dt>
                            <dd>{{$station->time}}</dd>
                        </dl>
                        <dl class="area-main__list">
                            <dt>主要駅からの最終電車</dt>
                            <dd>{{$station->last}}</dd>
                        </dl>
                        <dl class="area-main__list">
                            <dt>施設</dt>
                            <dd>{{$station->facility}}</dd>
                        </dl>
                    </div>
                    <div class="area-main__details-title">
                        <i class="fas fa-map-marker-alt"></i>{{$station->line}}{{$station->name}}駅の周辺マップ
                    </div>
                    <iframe class="area-main__iframe"
                        src="https://maps.google.co.jp/maps?output=embed&q={{$station->address}}"
                        width="600" height="300" frameborder="0" style="border:0" allowfullscreen=""></iframe>

                    @if(count($other) > 0)
                    <div class="area-main__details">
                        <div class="area-main__details-title">
                            <i class="fas fa-subway"></i>{{$area['name']}}の駅周辺の不動産情報
                        </div>
                        <p class="area-main__details-paragraph">
                        {{$area['name']}}の駅周辺の不動産情報や駅の情報について詳しくご覧いただけます。
                        </p>
                        @foreach($other as $key => $row)
                            <div class="area-main__details-tag">
                                {{$key}}
                            </div>
                            <hr class="area-main__details-line">
                            @foreach($row as $station_row)
                                @if($loop->iteration % 4 == 1)
                                <div class="area-main__details-links">
                                @endif
                                    <div class="area-main__details-link">
                                        <a href="/area/{{$station_row->area_name}}/st{{$station_row->id}}">
                                            <i class="fas fa-chevron-right"></i>{{$station_row->name}}駅（{{$station_row->count}}）
                                        </a>
                                    </div>
                                @if($loop->iteration % 4 == 0 || $loop->last)
                                </div>
                                @endif
                            @endforeach
                        @endforeach
                    </div>
                    @endif
                    <div class="area-main__details">
                        <div class="area-main__details-title">
                            <i class="fas fa-school"></i>{{$area['name']}}の学校周辺の不動産情報
                        </div>
                        <p class="area-main__details-paragraph">
                        {{$area['name']}}の学校の特徴や通学区域、周辺の不動産の情報などを詳しくご覧いただけます。
                        </p>
                        <div class="area-main__details-tag">
                            小学校
                    </div>
                    <hr class="area-main__details-line">
                    @for ($i = 0; $i < 2; $i++) <div class="area-main__details-links">
                        @for ($j = 0; $j < 4; $j++) <div class="area-main__details-link">
                            <a href="">
                                <i class="fas fa-chevron-right"></i>●●小学校（000）
                            </a>
                </div>
                @endfor
        </div>
        @endfor
                        <div class="area-main__details-tag">
                            中学校
                    </div>
                    <hr class="area-main__details-line">
                    @for ($i = 0; $i < 2; $i++) <div class="area-main__details-links">
                        @for ($j = 0; $j < 4; $j++) <div class="area-main__details-link">
                            <a href="">
                                <i class="fas fa-chevron-right"></i>●●中学校（000）
                            </a>
                </div>
                @endfor
        </div>
        @endfor
    </div>

</div>
</section>
include('home.area.new')
@include('home.area.info')
</div>
</div>
</div>
@include('home.area.footer')
@endsection
