@extends('home.template')

@section('content')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
 <script type="text/javascipt">
 $(function() {
	$(function() {
	 $('.fa-heart').each(function(i, obj) {
		$(this).addClass("pink");
	 });
	var favourites = [];
	@if(session("favourites")){
		@foreach( session("favourites") as $item){			
			favourites.push('{{$item}}');
		@endforeach	
	@else
		
	@endif
	$('.list-links__box').each(function(i, obj) {
		let item = $(this).attr('name');
		
		if (favourites.indexOf( item ) >= 0) {
			console.log(item);
			let heart_icon = $(this).find(".fa-heart");
			heart_icon.attr('class', "fas fa-heart pink selected");
		}
		else {
			heart_icon.attr('class', "fas fa-heart pink");
		}
	});
});
 </script>
<div class="grey-back" id='buy'>
    <div class="wrapper">
        <h2 class="page-title">横浜市港南区の新築戸建を探す</h2>
        <div class="two-column">
            <section class="two-column__side">
            <div class="side-sp" onclick="toogleMenu();">検索条件の変更<i class="fas fa-chevron-down"></i></div>
            @include('home.buy.side-search')
            </section>
            <section class="two-column__main">
             @include('home.buy.list_grid')

             <div class="notfaund">
               <strong>お探しの条件では物件が見つかりませんでした。</strong>
               <p>条件を変更して再検索していただくか、以下よりお問い合わせください。</p>
               <div class="notfaund-link">
                 <a class="notfaund-link__search" href="/buy"><i class="fas fa-search"></i>条件を変更して再検索</a>
                 <a class="notfaund-link__contact" href="#contact-box"><img class="mail" src="{{root('img/buy/icon_mail.png')}}">問い合わせをする</a>
              </div>
             </div>

             <div class="notfaund">
               <strong>お探しの物件はご成約済となっております。</strong>
               <p>条件を変更して再検索していただくか、以下よりお問い合わせください。</p>
               <div class="notfaund-link">
                 <a class="notfaund-link__search" href="/buy"><i class="fas fa-search"></i>条件を変更して再検索</a>
                 <a class="notfaund-link__contact" href="#contact-box"><img class="mail" src="{{root('img/buy/icon_mail.png')}}">問い合わせをする</a>
              </div>
             </div>

             <div class="no">
               <strong>ご希望の物件がなくても、あきらめないでください！</strong>
               <em>ホームページに掲載されていない物件情報があります！</em>
               <div class="no-in">
               <img class="no-illust" src="{{root('img/buy/no-illust.png')}}">
               <p>当社には、売主様の要望でホームページに掲載できない物件が多数ございます。
                 希望条件を教えていただければ、担当者よりご希望にあった物件を
                 紹介させていただきます。お気軽にお問い合わせくださいませ。</p>
            </div>
          </div>

          <div class="contact" id="contact-box">
            <strong class="contact-title">お問い合わせ</strong>
            <p>必須マークの項目は必ずご入力をお願いします。 </p>
          </div><!--contact-->

            </section>


        </div>
    </div>
<style>
	.header__input {
		font-weight: normal;
	}
	.wrapper {
		width: 1080px;
		margin: 10px auto;
	}
	.two-column__side {
		width: 30%;
	}
	.two-column__main {
		width: 69%;
	}

	.list-links {
		margin: 10px 10px 0 5px;
	}
	 @media screen and (max-width: 768px) and (max-device-width: 1024px) {
		.wrapper {
			width: auto;
			margin: 10px auto;
		}
		.header__form {
			border: 1px solid #616161;
			border-radius: 5px;
			padding: 10px 15px;
			display: inherit;
		}
		.header__input {
			width: 300px;
			border: none;
			line-height: 24px;
			padding-left: 5px;
		}

		.two-column__side {
			width: 100%;
			padding: 10px;
		}
		.two-column__main {
			width: 100%;
			padding: 10px;
		}

	}
	@media screen and (max-width: 480px){
		.wrapper {
			width: auto;
			margin: 10px auto;
		}
		 two-column__side {
			width: 100%;
			padding: 5px;
		}
		 .two-column__main {
			width: 100%;
		}
		.icons {
			margin-top: 10px;
		}
		.notfaund-link a {
			margin: 5px;
		}
		.notfaund-link__contact img{
			margin: 0px 10px 0 0;
		}
		.side-search{
			display:none;
		}
	}
</style>

<script type="text/javascript">
$(".fa-heart").on('click', function(event){	
	event.preventDefault();
	if ($(this).parent().attr('id') != "favorite_top" ) {
		var myClass = $(this).attr("class");
		var item = $(this).closest('div[class^="list-links__box"]').attr('name');
		if (item != null && item != ""){
			if (myClass.indexOf("far fa-heart") >=0){
				$(this).removeClass('far fa-heart pink').addClass('fas fa-heart pink');
				$.ajax({
					url: '/favorite/update/' + item  + '/1',
					type: 'GET'
				}).done(function(result) {
					
					$('#num_favourite').html(result);
					var height = $(".notify-bottom").outerHeight();
					$(".notify-bottom-favorite").fadeIn(1000)
						.animate({bottom:0}, height, function() {
						//callback
					});
					  setTimeout(function(){
						$(".notify-bottom").fadeOut(); 
					  }, 5000);
					 
				});
			}
			if (myClass.indexOf("fas fa-heart") >=0){
				$(this).removeClass('fas fa-heart pink').addClass('far fa-heart');
				$.ajax({
					url: '/favorite/update/' + item + '/0',
					type: 'GET'
				}).done(function(result) {
					$('#num_favourite').html(result);
					var height = $(".notify-bottom").outerHeight();
					$(".notify-bottom-unfavorite").fadeIn(1000)
						.animate({bottom:0}, height, function() {
						//callback
					});
					setTimeout(function(){
						$(".notify-bottom-unfavorite").fadeOut(); 
					}, 5000);
				});
			}
			
			setTimeout(function(){
				$(".notify-bottom").fadeOut(); 
			}, 5000);
			
			$(this).next().css("text-decoration", "none" );
		}	
	}
});


</script>
{{--
    @include('home.parts.list-voice')
    @include('home.buy.footer')
--}}
</div>
@endsection
