@extends('home.template')
@section('head')
@endsection
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.js"></script>
@section('content')
<div class="grey-back" id='buy'>

<div class="wrapper">

<h2 class="page-title"><span>住まいを探す</span><strong><img src="{{root('img/buy/icon_search.png')}}" alt="">沿線・駅から探す</strong></h2>
<p>沿線・駅にチェックを入れてください。（複数選択できます） ※駅名クリックで、各駅の物件一覧ページをご覧いただけます。</p>
<div class="line-wrap">
<form method="GET" action="/buy/bukkenlist" id="search_line">
@foreach($items as $item)
@php
	$count = $loop->iteration;
@endphp
	<h3><input type="checkbox" class="ca{{$loop->iteration}}" onclick="action_search();" />{{$item['line']['name']}}</h3>
	<div class="line-box">
		<ul class="line-box-name">
		@foreach($item['stations'] as $station)
		<li @if(floor((($loop->iteration - 1) / 4)) % 2 == 1) class="line"@endif><span><input type="checkbox" name="stc[]" class="cb{{$count}}" data-num="{{$station['count']}}" value="{{$station['id']}}" id="{{$station['id']}}" onclick="action_search();" /></span><a href="/buy/bukkenlist?stc={{$station['id']}}">{{$station['name']}}（{{$station['count']}}）<i class="fas fa-chevron-right"></i></a></li>
		@endforeach
		</ul>
	</div>
@endforeach
<hr />
</div>

<div class="search__result">
       <div class="search__number">該当物件数：<span id="num_total">000</span>件</div>
       <button class="search__button"><i class="fas fa-search"></i>この条件で検索</button>
</div>
<div id="bottom_bar" class="change__bar" style="display:none">
	<div class="wrapper">
		<span class="change__bar-count">該当物件数<strong><span id="total">000<span></strong>件</span>
		<input class="change__bar-clear" type="reset" id="clear" value="条件をクリア" />
		<input class="change__bar-button fas search__button" id="search_line" type="button" value="&#xf002 この条件で検索" />
		
	</div><!--wrapper-->
	
</div><!--change__bar-->
<script type="application/javascript">

	function action_search(){
		var total = 0;
		@foreach($items as $item)
		$('.cb{{$loop->iteration}}:checked').each(function(i, obj) {
			
				total += parseInt($(this).attr('data-num'));
			
		});
		@endforeach
		//total = $('.cb1:checked').length + $('.cb2:checked').length + $('.cb3:checked').length + $('.cb4:checked').length + $('.cb5:checked').length;
		$("#num_total").html(total);
		$("#total").html(total);
		if (total == 0) {
			$('#bottom_bar').hide();
		}
		else {
			$('#bottom_bar').show();
		}
	}	
	$('#clear').on('click', function(){
		$('#num_total').html(0);
		$('#total').html(0);
	});

	$('.ca1').click(function(){
		$('.cb1').prop('checked', this.checked);
		action_search();
	})

	//".checkbox" change 
	$('.cb1').change(function(){ 
		if(false == $(this).prop("checked")){ 
			$(".ca1").prop('checked', false); 
		}
		if ($('.cb1:checked').length == $('.cb1').length ){
			$(".ca1").prop('checked', true);
		}
		
		
	});
	//
	$('.ca2').click(function(){
		$('.cb2').prop('checked', this.checked);
		action_search();
	})

	//".checkbox" change 
	$('.cb2').change(function(){ 
		if(false == $(this).prop("checked")){ 
			$(".ca2").prop('checked', false); 
		}
		if ($('.cb2:checked').length == $('.cb2').length ){
			$(".ca2").prop('checked', true);
		}
		
		
	});
	//
	$('.ca3').click(function(){
		$('.cb3').prop('checked', this.checked);
		action_search();
	})

	//".checkbox" change 
	$('.cb3').change(function(){ 
		if(false == $(this).prop("checked")){ 
			$(".ca3").prop('checked', false); 
		}
		if ($('.cb3:checked').length == $('.cb3').length ){
			$(".ca3").prop('checked', true);
		}
		
		
	});
	//
	$('.ca4').click(function(){
		$('.cb4').prop('checked', this.checked);
		action_search();		
	})

	//".checkbox" change 
	$('.cb4').change(function(){ 
		if(false == $(this).prop("checked")){ 
			$(".ca4").prop('checked', false); 
		}
		if ($('.cb4:checked').length == $('.cb4').length ){
			$(".ca4").prop('checked', true);
		}
		
		
	});
	
	//
	$('.ca5').click(function(){
		$('.cb5').prop('checked', this.checked);
		action_search();
	})

	//".checkbox" change 
	$('.cb5').change(function(){ 
		if(false == $(this).prop("checked")){ 
			$(".ca5").prop('checked', false); 
		}
		if ($('.cb5:checked').length == $('.cb5').length ){
			$(".ca5").prop('checked', true);
		}
	});
		
</script>
</form>

</div>

</div><!--#wrapper-->

</div><!--#buy-->


<script type="text/javascript">
	$(function(){
		$('.search__button').on('click', function(){
			$('#search_line').submit();
		});

	})
	
</script>
<style>
change__box{
	position:fixed;
	top:20%;
	left:50%;
	margin:0 -540px;
	width:1080px;
	padding:50px;
	box-sizing:border-box;
	background:#fff;
	border:1px solid #EDB35D;
}
.change__box input	{
	width:20px;
	height:20px;
	margin-right:10px;
}
.change__box-all	{
	width:100%;
	background:#F0F0F0;
	padding:10px 30px;
	box-sizing:border-box;
}
.change__box-list	{
	width:100%;
	padding:10px 30px;
	box-sizing:border-box;
	display: -webkit-box;
	display: -webkit-flex;
	display: -ms-flexbox;
	display: flex;
	justify-content: space-between;
	align-items: flex-end;
}
.change__box-list li	{
  	margin: 0;
	display:block;
}
.change__bar	{
	position:fixed;
	bottom:0;
	left:0;
	width:100%;
	padding:20px 0;
	background:#333;
	color:#fff;
}
.change__bar-count	{
	margin:0 0 0 100px;
	color:#fff;
}
.change__bar-count strong	{
	margin:0 5px 0 15px;
	font-weight:bold;
	font-size:28px;
	color:#f54;
}
.change__bar-button	{
	margin-right:50px;
	padding:10px 30px;
	background:#f54;
	border:none;
	border-radius:5px;
	color:#fff;
	float:right;
	cursor:pointer;
}
.change__bar-button	:hover{
	opacity:0.7;
}
.change__bar-clear	{
	margin:10px 100px 0 0;
	padding:0;
	background:none;
	border:none;
	color:#fff;
	float:right;
	cursor:pointer;
}
.change__bar-clear	:hover{
	text-decoration:underline;
}
@media (max-width: 740px) {
	.change	{
		position:relative;
		background:none;
	}
	.change__box{
		position:relative;
		top:0;
		left:0;
		margin:0;
		width:100%;
		padding:20px;
		border:none;
	}
	.change__box-list	{
		width:100%;
		margin:10px 0 0 0;
		padding:0;
		box-sizing:border-box;
		display:block;
	}
	.change__box-list li	{
  		width:100%;
  		margin: 0;
		display:block;
	}
	.change__box-list li	 label{
  		width:100%;
  		margin: 0;
		display:block;
		line-height:30px;
	}
	.change__bar-count	{
		margin:0;
		color:#fff;
	}
	.change__bar-button	{
		width:100%;
		margin:10px 0 0 0;
		padding:15px 30px;
	}
	.change__bar-clear	{
		margin:5px 0 0 0;
	}
</style>
@endsection
