<section class="simple-navi">
    <nav class="simple-navi__upper">
		<a href="/buy/konan" class="simple-navi__area">横浜市港南区</a>
        <a href="/buy/sakae" class="simple-navi__area">横浜市栄区</a>
        <a href="/buy/isogo" class="simple-navi__area">横浜市磯子区</a>
        <a href="/buy/kanazawa" class="simple-navi__area">横浜市金沢区</a>
		<a href="/buy/minami" class="simple-navi__area">横浜市南区</a>
		<a href="/buy/bukkenlist?fg=1" class="simple-navi__area">横浜市他エリア</a>
    </nav>
    <nav class="simple-navi__lower">
        <a href="/buy/konan" class="simple-navi__type">全物件</a>
        <a href="/buy/konan/mansion" class="simple-navi__type">中古マンション</a>
        <a href="/buy/konan/nhouse" class="simple-navi__type">新築一戸建て</a>
        <a href="/buy/konan/uhouse" class="simple-navi__type">中古一戸建て</a>
        <a href="/buy/konan/land" class="simple-navi__type">土地</a>
    </nav>
</section>
<section class="list-option">
	<div class="list-option__style" id="grid">
		@php
		$grid_url = url("buy/bukkenlist?grid=1");
		@endphp
		<div class="list-option__radio selected" id="btnSwitchListItem1" onclick="changeListGrid(1)"><i
				class="fas fa-camera"></i>写真<span>表示</span></div>
		<div class="list-option__radio" id="btnSwitchListItem2" onclick="changeListGrid(2)"><i
				class="fas fa-list"></i>リスト<span>表示</span></div>
		<script>
			var type = 1;
			var typeGrid = 2;
			if (type == 2) {
				changeListGrid(2);
			}

			function changeListGrid(type) {
				typeGrid = type;
				if (type == 1) {
					$("#listItem").hide();
					$("#listItemGrid").show();
					$("#btnSwitchListItem1").addClass("selected");
					$("#btnSwitchListItem2").removeClass("selected");
				} else {

					$("#listItem").show();
					$("#listItemGrid").hide();
					$("#btnSwitchListItem2").addClass("selected");
					$("#btnSwitchListItem1").removeClass("selected");
				}
			}
		</script>
	</div>
	<dl class="list-option__sort">
		<dt>並べ替え</dt>
		<dd>
			<select name="sort" id="buy_list_sort" class="list-option__select">
				<option value="osusume" @if(isset($sort) && $sort == "osusume") selected @endif>おすすめ順</option>
				<option value="new" @if(isset($sort) && $sort == "new") selected @endif>新着順</option>
				<option value="station" @if(isset($sort) && $sort == "station") selected @endif>駅近い順</option>
				<option value="slope_low" @if(isset($sort) && $sort == "slope_low") selected @endif>坂道レベル 平坦順</option>
				<option value="slope_hight" @if(isset($sort) && $sort == "slope_hight") selected @endif>坂道レベル 急坂順</option>
				<option value="price_low" @if(isset($sort) && $sort == "price_low") selected @endif>価格 安い順</option>
				<option value="price_hight" @if(isset($sort) && $sort == "price_hight") selected @endif>価格 高い順</option>
				<option value="age_hight" @if(isset($sort) && $sort == "age_hight") selected @endif>築年数 古い順</option>
				<option value="age_low" @if(isset($sort) && $sort == "age_low") selected @endif>築年数 新しい順</option>
				<option value="land_low" @if(isset($sort) && $sort == "land_low") selected @endif>土地面積 狭い順</option>
				<option value="land_hight" @if(isset($sort) && $sort == "land_hight") selected @endif>土地面積 広い順</option>
				<option value="floor_low" @if(isset($sort) && $sort == "floor_low") selected @endif>延床面積 狭い順</option>
				<option value="floor_hight" @if(isset($sort) && $sort == "floor_hight") selected @endif>延床面積 広い順</option>
				<option value="reform" @if(isset($sort) && $sort == "reform") selected @endif>リフォーム済</option>
			</select>
		</dd>
	</dl>
</section>
<script type="text/javascript">
	$(function(){
		$('#buy_list_sort').on('change', function(){
			var selected = $(this).val();
			var uri = location.href.replace(location.host, '').replace(/https:\/\//g,'').replace(/http:\/\//g,'').replace(/[\?||&]sort=.*/g,'');
			window.location.href = uri+'&sort='+selected;
		});
	});
</script>

<section class="pagenation">
	<div class="pagenation__count">
	該当物件数：<span>{{$count}}</span>件
	</div>
	<dl class="pagenation__pages">
		<dt>{{$first}}-{{$last}}/{{$count}}件</dt>
        <dd>
		{{ $items->appends($params)->links() }}
        </dd>
	</dl>
</section>


<section id="listItem" class="list-links" style="display: none;">
	@foreach($items as $row)
	<div class="list-links__box" name="{{$row->name}}" data-id="{{$loop->iteration}}">
		<div class="list-links__upper">
			<div class="list-links__infos">
				<div class="list-links__title">{{$row->name}}</div>
				<section class="tags">
					@if(strtotime($row->created_at) >= strtotime($new_target))
					<div class="tags__tag-new">NEW</div>
					@endif
					@if($row->property == null)
					<div class="tags__tag-mansion">中古マンション</div>
					@elseif($row->property < 4)
					<div class="tags__tag-land">土地</div>
					@elseif($row->property < 6)
						@if($row->property_sub == 1)
						<div class="tags__tag-nhouse">新築一戸建て
						@else
						<div class="tags__tag-uhouse">中古一戸建て</div>
						@endif
					@else
						<div class="tags__tag-mansion">中古マンション</div>
					@endif		
				</section>
			</div>
			<section class="icons">
				<a href="" class="icons__icon" onclick="d_app.handleBtnFavorite(event)"><i class="far fa-heart"></i>
					<div>お気に入り</div>
				</a>
				<a href="/buy/reserve/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="icons__icon"><i class="far fa-calendar-alt"></i>
					<div>見学予約</div>
				</a>
				<a href="/buy/contact/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="icons__icon"><i class="far fa-envelope"></i>
					<div>お問い合わせ</div>
				</a>
			</section>
		</div>
		<div class="list-links__model">{{$row->open_text}}</div>
		<div class="list-links__copy" data-title="{{$row->catch_copy}}">{{$row->catch_copy}}</div>
		<div class="list-links__details">
			<div class="list-links__photo">
				@if(!empty($row->disp_file_path))
				<img data-thumbnail="{{$row->disp_file_path}}" src="{{$row->disp_file_path}}" alt="{{$row->name}}" class="list-links__img">
				@else
				<img src="{{root('img/noimage2.jpg')}}" class="list-links__img" />
				@endif
				<div class="list-option__style">
					<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
					<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
				</div>
			</div>
			<a href="/buy/detail/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="list-links__detail">
				<dl class="list-links__data">
					<dt><i class="fas fa-yen-sign"></i>物件価格</dt>
					<dd class="list-links__price"><span data-price="@if(is_null($row->room_id)){{$row->price}}@else{{$row->room_price}}@endif">@if(is_null($row->room_id)){{$row->price}}@else{{$row->room_price}}@endif</span>万円</dd>
				</dl>
				<dl class="list-links__data">
					<dt><i class="fas fa-map-marker-alt"></i>所在地</dt>
					<dd data-location="{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}">{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}</dd>
				</dl>
				<dl class="list-links__data">
					<dt><i class="fas fa-subway"></i>交通</dt>
					<dd data-intro="{{$row->main_traffic_line}}「{{$row->main_traffic_station}}」徒歩{{$row->main_traffic_time??'-'}}分">{{$row->main_traffic_line}}「{{$row->main_traffic_station}}」徒歩{{$row->main_traffic_time??'-'}}分</dd>
				</dl>
				<div class="list-links__pieces">
					@if(isset($row->land_area_val))
					<dl class="list-links__piece">
						<dt>土地面積</dt>
						<dd data-landarea="{{$row->land_area_val?? "-"}}">{{$row->land_area_val?? "-"}}㎡</dd>
					</dl>
					@endif
					@if(isset($row->total_area))
					<dl class="list-links__piece">
						<dt>建物面積</dt>
						<dd data-buildingarea="{{$row->total_area_val?? "-"}}">{{$row->total_area_val?? "-"}}㎡</dd>
					</dl>
					@endif
					@if(isset($row->floor_plan) || isset($row->floor_plan_name))
					<dl class="list-links__piece">
						<dt>間取り</dt>
						<dd data-floorplan="{{$row->floor_plan}}{{$row->floor_plan_name}}">{{$row->floor_plan}}{{$row->floor_plan_name}}</dd>
					</dl>
					@endif
					@if(isset($row->age_year) || isset($row->age_month))
					<dl class="list-links__piece">
						<dt>築年月</dt>
						<dd data-timetostation="{{$row->age_year?? "-"}}年{{$row->age_month?? "-"}}月築">{{$row->age_year?? "-"}}年{{$row->age_month?? "-"}}月築</dd>
					</dl>
					@endif
				</div>
				<div class="list-links__flow">
					<div class="list-links__pictures"><i class="fas fa-camera"></i>{{$row->file_count}}枚
					</div>
					<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
				</div>
			</a>
		</div>
		</div>
		@endforeach
</section>

<section class="list-links" id="listItemGrid">
	<section class="list-links" id="listItem123">
		@foreach($items as $row)
		<div class="list-links__box" name="{{$row->name}}" data-id="{{$loop->iteration}}">
			<div class="row" style="padding:10px">
				<div class="col-lg-8 col-md-8 col-xs-8">
					<h3>{{$row->name}}</h3>
					<div class="row" style="padding:0 10px">
						<section class="tags">
							@if(strtotime($row->created_at) >= strtotime($new_target))
							<div class="tags__tag-new">NEW</div>
							@endif
							@if($row->property == null)
							<div class="tags__tag-mansion">中古マンション</div>
							@elseif($row->property < 4)
							<div class="tags__tag-land">土地</div>
							@elseif($row->property < 6)
								@if($row->property_sub == 1)
								<div class="tags__tag-nhouse">新築一戸建て
								@else
								<div class="tags__tag-uhouse">中古一戸建て</div>
								@endif
							@else
								<div class="tags__tag-mansion">中古マンション</div>
							@endif		
						</section>
					</div>
				</div>
				<div class="col-lg-4 col-md-4">
					<section class="icons">
						<a href="#" onclick="d_app.handleBtnFavorite(event)" class="icons__icon"><i class="far fa-heart"></i>
							<div>お気に入り</div>
						</a>
						<a href="/buy/reserve/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="icons__icon"><i class="far fa-calendar-alt"></i>
							<div>見学予約</div>
						</a>
						<a href="/buy/contact/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="icons__icon"><i class="far fa-envelope"></i>
							<div>お問い合わせ</div>
						</a>
					</section>
				</div>
				<p style="color:#FF310F;margin-bottom: 0px;">{{$row->open_text}}</p>
			</div>
			@if($row->catchcopy != "")
			<hr>
			<div class="row">
				<div class="list-links__copy" data-title="{{$row->catchcopy}}">{{$row->catchcopy}}</div>
			</div>
			@endif
			<hr>
			<div class="row">
				<div class="col-lg-6 col-md-6 list-links__photo">

						@if(!empty($row->photo_info[0]->file_path))
						<img src="{{$row->photo_info[0]->file_path}}" alt="{{$row->name}}" class="list-links__img" style="width:100%; height:100%;">
						@else
						<img src="{{root('img/noimage2.jpg')}}" class="list-links__img" style="width:100%; height:100%"/>
						@endif

						@if(!empty($row->floor_file_path))
						<img src="{{$row->floor_file_path}}" alt="{{$row->name}}" class="list-links__img" style="width:100%; height:100%; display:none;">
						@else
						<img src="{{root('img/noimage2.jpg')}}" class="list-links__img" style="width:100%; height:100%; display:none;"/>
						@endif

					<div class="list-option__style list-option__style__grid" onclick="d_app.handleClicklistOptionRadio(event)" >
						<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
						<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
					</div>

				</div>

				<div class="col-lg-6 col-md-6">
					<a href="/buy/detail/@if(is_null($row->room_id)){{$row->building_id}}@else{{$row->room_id}}@endif" class="list-links__detail_new fontsize14">
						<dl class="list-links__data">
							<dt><i class="fas fa-yen-sign"></i>物件価格
							</dt>
							<dd class="new"><span data-price="@if(is_null($row->room_id)){{$row->price}}@else{{$row->room_price}}@endif">@if(is_null($row->room_id)){{$row->price}}@else{{$row->room_price}}@endif</span>万円
							</dd>
						</dl>
						<dl class="list-links__data">
							<dt><i class="fas fa-map-marker-alt"></i>所在地
							</dt>
							<dd class="new" data-location="{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}">{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}</dd>
						</dl>
						<dl class="list-links__data">
							<dt><i class="fas fa-subway"></i>交通
							</dt>
							<dd class="new" data-intro="{{$row->main_traffic_line}}「{{$row->main_traffic_station}}」徒歩{{$row->main_traffic_time??'-'}}分">{{$row->main_traffic_line}}「{{$row->main_traffic_station}}」徒歩{{$row->main_traffic_time??'-'}}分</dd>
						</dl>
						@if(isset($row->land_area_val))
						<dl class="list-links__data">
							<dt>土地面積</dt>
							<dd class="new" data-landarea="{{$row->land_area_val?? "-"}}">{{$row->land_area_val?? "-"}}㎡</dd>
						</dl>
						@endif
						@if(isset($row->total_area))
						<dl class="list-links__data">
							<dt>建物面積</dt>
							<dd class="new" data-buildingarea="{{$row->total_area_val?? "-"}}">{{$row->total_area_val?? "-"}}㎡</dd>
						</dl>
						@endif
						@if(isset($row->floor_plan) || isset($row->floor_plan_name))
						<dl class="list-links__data">
							<dt>間取り</dt>
							<dd class="new" data-floorplan="{{$row->floor_plan}}{{$row->floor_plan_name}}">{{$row->floor_plan}}{{$row->floor_plan_name}}</dd>
						</dl>
						@endif
						@if(isset($row->age_year) || isset($row->age_month))
						<dl class="list-links__data">
							<dt>築年月</dt>
							<dd class="new" data-timetostation="{{$row->age_year?? "-"}}年{{$row->age_month?? "-"}}月築">{{$row->age_year?? "-"}}年{{$row->age_month?? "-"}}月築</dd>
						</dl>
						@endif
						<!---->
						<!---->
					</a>
					<div class="row">
						<div class="col-lg-6 col-md-6 col-xs-6">
							<div class="list-links__pictures" style="font-size:15px;padding-left:10px">
								<i class="fas fa-camera"></i>{{$row->file_count}}枚
							</div>
						</div>
						<div class="col-lg-6 col-md-6 col-xs-6">
							<div class="float-right" style="float:right; padding-right:10px">
								詳細を見る
								<i class="fas fa-chevron-right"></i>
							</div>
						</div>
					</div>
				</div>
			</div>
			</div>
			@endforeach
			<style type="text/css">
				.list-links__box {
					border-bottom: 1px solid rgb(0, 0, 0);
					margin: 20px 5px;
				}
			</style>
	</section>