<section class="overview">
    <h2 class="overview__title">
        物件概要
    </h2>
    <dl class="overview__list">
        <dt>物件種別</dt>
        <dd>{{$article->property_name}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>物件名</dt>
        <dd>{{$article->article_name}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>価格</dt>
        <dd>
            <div><strong>{{$article->price}}</strong>万円@if($article->tax == 1)（税抜）@else（税込）@endif</div>
            <a href="/buy/loan/{{$article->building_id}}"><i class="fas fa-calculator"></i> ローンシミュレーション</a>
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>所在地</dt>
        <dd>{{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}<br><a href="/buy/bukkenlist?area={{$article->address1}}{{$article->address2}}">{{$article->city_name}}の物件一覧<i class="fas fa-chevron-right"></i></a> </dd>
    </dl>
    <dl class="overview__list">
        <dt>交通</dt>
        <dd>
            {{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅　徒歩{{$article->main_traffic_time}}分<br>
            @if(isset($article->main_traffic_station_id) && !is_null($article->main_traffic_station_id))<a href="/buy/bukkenlist?stc={{$article->main_traffic_station_id}}">{{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅の物件一覧<i class="fas fa-chevron-right"></i></a>@endif
            @if(isset($article->sub_traffic1_line))<br>{{$article->sub_traffic1_line}}「{{$article->sub_traffic1_station}}」駅　徒歩{{$article->sub_traffic1_time}}分@endif
            @if(isset($article->sub_traffic2_line))<br>{{$article->sub_traffic2_line}}「{{$article->sub_traffic2_station}}」駅　徒歩{{$article->sub_traffic2_time}}分@endif
        </dd>
    </dl>
    @if($article->type != 4)
    <dl class="overview__list">
        <dt>間取り</dt>
        <dd>
                {{$article->floor_plan}}{{$article->floor_plan_name}}
        </dd>
    </dl>
    @endif
    @if($article->type == 1)
    <dl class="overview__list">
        <dt>所在階／階数</dt>
        <dd>{{$article->whereabouts}}階／{{$article->floor}}階建</dd>
    </dl>
    @endif
    @if($article->type == 2 || $article->type == 3)
    <dl class="overview__list">
        <dt>階数</dt>
        <dd>{{$article->floor}}階建</dd>
    </dl>
    @endif
    @if($article->type != 4)
    <dl class="overview__list">
        <dt>構造</dt>
        <dd>
            {{$article->construction_name??'-'}}@if($article->construction_name != "" || $article->construction_name != null) <br> @endif
            @if($article->construction_sub_name != "")・一部{{$article->construction_sub_name}}@endif
        </dd>
    </dl>
    @endif
    @if($article->type == 1)
    <dl class="overview__list">
        <dt>築年月</dt>
        <dd>{{$article->age_year}}年{{$article->age_month}}月築</dd>
    </dl>
    @endif
    @if($article->type == 2 || $article->type == 3)
    <dl class="overview__list">
        <dt>完成時期</dt>
        <dd>
            {{$article->completed_year}}年{{$article->completed_month}}月{{$article->completed_text??''}}
        </dd>
    </dl>
    @endif
    @if($article->type == 1)
    <dl class="overview__list">
        <dt>専有面積</dt>
        <dd>{{$article->total_area_val}}&nbsp;m&sup2;</dd>
    </dl>
    @endif
    @if($article->type != 1)
    <dl class="overview__list">
        <dt>土地面積</dt>
        <dd>{{$article->land_area_val}}&nbsp;m&sup2;</dd>
    </dl>
    @endif
    @if($article->type == 2 || $article->type == 3)
    <dl class="overview__list">
        <dt>建物面積</dt>
        <dd>{{$article->total_area_val}}&nbsp;m&sup2;</dd>
    </dl>
    @endif
    @if($article->type == 1)
    <dl class="overview__list">
        <dt>バルコニー</dt>
        <dd>@if($article->balcony_area == 1){{$article->balcony_area_val}}&nbsp;m&sup2;@else-@endif</dd>
    </dl>
    <dl class="overview__list">
        <dt>テラス面積</dt>
        <dd>@if($article->terrace_area == 1){{$article->terrace_area_val}}&nbsp;m&sup2;@else-@endif</dd>
    </dl>
    <dl class="overview__list">
        <dt>専用庭面積</dt>
        <dd>@if($article->garden_area == 1){{$article->garden_area_val}}&nbsp;m&sup2;@else-@endif</dd>
    </dl>
    <dl class="overview__list">
        <dt>管理費</dt>
        <dd>@if($article->management == 1){{$article->management_cost}}円@else-@endif</dd>
    </dl>
    <dl class="overview__list">
        <dt>修繕積立金</dt>
        <dd>@if($article->repair == 1){{$article->repair_cost}}円@else-@endif</dd>
    </dl>
    @endif
    @if($article->type != 4)
    <dl class="overview__list">
        <dt>有線放送に係る費用</dt>
        <dd>
            @if($article->broadcasting == 1)
                @if($article->broadcasting_presence == 1)
                    初期費用：{{$article->broadcasting_cost}}円
                @elseif($article->broadcasting_presence == 2)
                    共有
                @endif
                @if($article->broadcasting_fixed_presence == 1)
                    定額費用：{{$article->broadcasting_fixed_cost}}円/@if($article->running_cost_unit == 1)月@else年@endif
                @elseif($article->broadcasting_fixed_presence == 2)
                    共有
                @endif
            @else
                無し
            @endif
        </dd>
    </dl>
    @endif
    @if($article->property != 1 && $article->property != 2 && $article->property != 3)
    <dl class="overview__list">
        <dt>インターネットに係る費用</dt>
        <dd>
            @if($article->internet == 1)
                @if($article->internet_presence == 1)
                    初期費用：{{$article->internet_cost}}円
                @elseif($article->internet_presence == 2)
                    共有
                @endif
                @if($article->internet_fixed_presence == 1)
                    定額費用：{{$article->internet_fixed_cost}}円/@if($article->running_cost_unit == 1)月@else年@endif
                @elseif($article->internet_fixed_presence == 2)
                    共有
                @endif
            @else
                無し
            @endif
        </dd>
    </dl>
    @endif
    @if($article->property != 1 && $article->property != 2 && $article->property != 3)
    <dl class="overview__list">
        <dt>CATVに係る費用</dt>
        <dd>
            @if($article->catv == 1)
                @if($article->catv_presence == 1)
                    初期費用：{{$article->catv_cost}}円
                @elseif($article->catv_presence == 2)
                    共有
                @endif
                @if($article->catv_fixed_presence == 1)
                    定額費用：{{$article->catv_fixed_cost}}円/@if($article->running_cost_unit == 1)月@else年@endif
                @elseif($article->catv_fixed_presence == 2)
                    共有
                @endif
            @else
                無し
            @endif
        </dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>町会費など</dt>
        <dd>
            @if($article->council == 1)
            町会費：
            @elseif($article->council == 2)
            町内会費：
            @elseif($article->council == 3)
            自治会費：
            @endif
            @if($article->council_presence == 0)
                無し
            @elseif($article->council_presence == 1)
                {{$article->council_cost}}円/@if($article->council_cost_unit == 1)月@elseif($article->council_cost_unit == 2)年@elseif($article->council_cost_unit == 3)一括@endif
            @elseif($article->council_presence == 2)
                金額未定
            @endif
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>温泉</dt>
        <dd>
            @if($article->spring == 1)
                温泉使用料：
            @elseif($article->spring == 2)
                温泉権利金：
            @endif
            @if($article->spring_presence == 0)
                無し
            @elseif($article->spring_presence == 1)
                {{$article->spring_cost}}円/@if($article->spring_cost_unit == 1)月@elseif($article->spring_cost_unit == 2)年@elseif($article->spring_cost_unit == 3)一括@endif
            @elseif($article->spring_presence == 2)
                金額未定
            @endif
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>その他費用１</dt>
        <dd>
            @if($article->another_cost_name1)
                {{$article->another_cost_name1}}：{{$article->another_cost1}}万円/@if($article->another_cost_unit1 == 1)月@elseif($article->another_cost_unit1 == 2)年@elseif($article->another_cost_unit1 == 3)一括@endif
            @else
                無し
            @endif
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>その他費用２</dt>
        <dd>
            @if($article->another_cost_name2)
                {{$article->another_cost_name2}}：{{$article->another_cost2}}万円/@if($article->another_cost_unit2 == 1)月@elseif($article->another_cost_unit2 == 2)年@elseif($article->another_cost_unit2 == 3)一括@endif
            @else
                無し
            @endif
        </dd>
    </dl>
    @if($article->type != 1)
    <dl class="overview__list">
        <dt>接道</dt>
        <dd>
            @if($article->land_kind1 == 1)
                公道
                @if($article->land_direction1 == 1)北@elseif($article->land_direction1 == 2)北東@elseif($article->land_direction1 == 3)東@elseif($article->land_direction1 == 4)南東@elseif($article->land_direction1 == 5)南@elseif($article->land_direction1 == 6)南西@elseif($article->land_direction1 == 7)西@elseif($article->land_direction1 == 8)北西@endif
                道路幅約{{$article->road_width1}}m&nbsp;間口約{{$article->frontage1}}m
            @elseif($article->land_kind1 == 2)
                私道
                @if($article->land_direction1 == 1)北@elseif($article->land_direction1 == 2)北東@elseif($article->land_direction1 == 3)東@elseif($article->land_direction1 == 4)南東@elseif($article->land_direction1 == 5)南@elseif($article->land_direction1 == 6)南西@elseif($article->land_direction1 == 7)西@elseif($article->land_direction1 == 8)北西@endif
                道路幅約{{$article->road_width1}}m&nbsp;間口約{{$article->frontage1}}m
            @endif
            
            @if($article->land_kind2 == 1)
                公道
                @if($article->land_direction2 == 1)北@elseif($article->land_direction2 == 2)北東@elseif($article->land_direction2 == 3)東@elseif($article->land_direction2 == 4)南東@elseif($article->land_direction2 == 5)南@elseif($article->land_direction2 == 6)南西@elseif($article->land_direction2 == 7)西@elseif($article->land_direction2 == 8)北西@endif
                道路幅約{{$article->road_width2}}m&nbsp;間口約{{$article->frontage2}}m
            @elseif($article->land_kind2 == 2)
                私道
                @if($article->land_direction2 == 1)北@elseif($article->land_direction2 == 2)北東@elseif($article->land_direction2 == 3)東@elseif($article->land_direction2 == 4)南東@elseif($article->land_direction2 == 5)南@elseif($article->land_direction2 == 6)南西@elseif($article->land_direction2 == 7)西@elseif($article->land_direction2 == 8)北西@endif
                道路幅約{{$article->road_width2}}m&nbsp;間口約{{$article->frontage2}}m
            @endif

            @if($article->land_kind3 == 1)
                公道
                @if($article->land_direction3 == 1)北@elseif($article->land_direction3 == 2)北東@elseif($article->land_direction3 == 3)東@elseif($article->land_direction3 == 4)南東@elseif($article->land_direction3 == 5)南@elseif($article->land_direction3 == 6)南西@elseif($article->land_direction3 == 7)西@elseif($article->land_direction3 == 8)北西@endif
                道路幅約{{$article->road_width3}}m&nbsp;間口約{{$article->frontage3}}m
            @elseif($article->land_kind3 == 2)
                私道
                @if($article->land_direction3 == 1)北@elseif($article->land_direction3 == 2)北東@elseif($article->land_direction3 == 3)東@elseif($article->land_direction3 == 4)南東@elseif($article->land_direction3 == 5)南@elseif($article->land_direction3 == 6)南西@elseif($article->land_direction3 == 7)西@elseif($article->land_direction3 == 8)北西@endif
                道路幅約{{$article->road_width3}}m&nbsp;間口約{{$article->frontage3}}m
            @endif
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>セットバック</dt>
        <dd>{{$article->set_area}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>私道負担</dt>
        <dd>
            @if($article->road_burden == 1)
                私道面積：{{$article->road_burden_area}}m&sup2;
            @elseif($article->road_burden == 2)
                私道面積：{{$article->road_burden_area}}m&sup2;
                私道持分比率 {{$article->road_numerator}}/{{$article->road_denominator}}
            @else
                無し
            @endif
        </dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>用途地域</dt>
        <dd>
            {{$article->use_area_name??'-'}}@if($article->use_area_name != "" || $article->use_area_name != null) <br> @endif
            @if($article->use_area_name_sub != "")
                一部 {{$article->use_area_name_sub}}を含む<br>
            @endif
            @if($article->use_area_name_sub2 != "")
                一部 {{$article->use_area_name_sub2}}を含む<br>
            @endif
        </dd>
    </dl>
    @if($article->type != 1)
    <dl class="overview__list">
        <dt>建ぺい率</dt>
        <dd>{{$article->building_rate??'-'}}%</dd>
    </dl>
    <dl class="overview__list">
        <dt>容積率</dt>
        <dd>{{$article->volume_rate??'-'}}%</dd>
    </dl>
    <dl class="overview__list">
        <dt>地目</dt>
        <dd>{{$ground[$article->ground]?? '-'}}</dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>坂道レベル</dt>
        <dd>{{$article->original3??'-'}}</dd>
    </dl>
    @if($article->type == 4)
    <dl class="overview__list">
        <dt>建築条件</dt>
        <dd>
            @if($article->land_condition == 0)
                条件なし
            @elseif($article->land_condition == 1) 
                建築条件付き
            @endif
        </dd>
    </dl>
    @endif
    @if($article->type == 1 || $article->type == 2)
    <dl class="overview__list">
        <dt>総戸数</dt>
        <dd>{{$article->total_unit??'-'}}戸</dd>
    </dl>
    @endif
    @if($article->type == 4)
    <dl class="overview__list">
        <dt>総区画数</dt>
        <dd>{{$article->section??'-'}}区画</dd>
    </dl>
    @endif
    @if($article->type != 4)
    <dl class="overview__list">
        <dt>駐車場</dt>
        <dd>
            @if($article->parking == 1)
                無
            @elseif($article->parking == 2)
                空無
            @elseif($article->parking == 3)
                空有
            @elseif($article->parking == 4)
                分譲（必購入）
            @elseif($article->parking == 5)
                分譲（任意購入）
            @elseif($article->parking == 6)
                専用使用権付
            @elseif($article->parking == 7)
                敷地外有
            @elseif($article->parking == 11)
                カースペース
            @elseif($article->parking == 12)
                カーポート
            @elseif($article->parking == 13)
                ２台以上
            @else
            -
            @endif

            @if($article->parking_yes == 1)
                {{$article->parking_yes_cost_from}}〜{{$article->parking_yes_cost_to}}円/@if($article->parking_yes_cost_unit == 1) 月 @else 年 @endif
            @endif
        </dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>現況</dt>
        <dd>
            @if($article->land_status_name != "")
            {{$article->land_status_name}}
            @else
            不明
            @endif
        </dd>
    </dl>
    @if($article->type == 4)
    <dl class="overview__list">
        <dt>引渡し</dt>
        <dd>
            @if($article->land_delivery == 1)
                即日
            @elseif($article->land_delivery == 3)
                {{$article->delivery_year}}年{{$article->delivery_month}}
                @if($article->land_delivery_time == 1)初旬@elseif($article->land_delivery_time == 2)上旬@elseif($article->land_delivery_time == 3)中旬@elseif($article->land_delivery_time == 4)下旬@elseif($article->land_delivery_time == 5)末@endif
            @endif
        </dd>
    </dl>
    @elseif($article->type == 1)
    <dl class="overview__list">
        <dt>引き渡し</dt>
        <dd>
            @if($article->move_in == 1)
                即引き渡し可
            @elseif($article->move_in == 2)
                相談
            @elseif($article->move_in == 3)
                {{$article->move_in_year}}年{{$article->move_in_month}}月
            @elseif($article->move_in == 4)
                契約後{{$article->move_in_contract_month}}ヶ月
            @elseif($article->move_in == 5)
                不明
            @endif
        </dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>設備</dt>
        <dd>
            @if($article->water_supply == 1)
                公営水道
            @elseif($article->water_supply == 2)
                私設水道
            @elseif($article->water_supply == 3)
                井戸
            @endif

            @if($article->sewerage == 1)
                本下水
            @elseif($article->sewerage == 2)
                集中浄化槽
            @elseif($article->sewerage == 3)
                個別浄化槽
            @endif

            @if($article->gas == 1)
                都市ガス
            @elseif($article->gas == 2)
                集中ＬＰＧ
            @elseif($article->gas == 3)
                個別ＬＰＧ
            @elseif($article->gas == 4)
                オール電化
            @endif

            @if($article->water_supply == null && $article->sewerage == null && $article->gas && $article->parking == null)
            -
            @elseif($article->parking == 2)
                空無
            @elseif($article->parking == 3)
                空有
            @elseif($article->parking == 4)
                分譲（必購入）
            @elseif($article->parking == 5)
                分譲（任意購入）
            @elseif($article->parking == 6)
                専用使用権付
            @elseif($article->parking == 7)
                敷地外有
            @elseif($article->parking == 8)
                掘込車庫
            @elseif($article->parking == 9)
                車庫
            @elseif($article->parking == 10)
                地下車庫
            @endif
        </dd>
    </dl>
    @if($article->type == 2)
    <dl class="overview__list">
        <dt>建築確認番号</dt>
        <dd>{{$article->architecture_no}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>開発許可番号</dt>
        <dd>{{$article->developer_number}}</dd>
    </dl>
    @endif
    @if($article->type == 1)
    <dl class="overview__list">
        <dt>管理形態</dt>
        <dd>{{$article->management_name}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>管理会社</dt>
        <dd>{{$article->management_company}}</dd>
    </dl>
    @endif
    <dl class="overview__list">
        <dt>取引態様</dt>
        <dd>{{$article->manner_name}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>学校区</dt>
        <dd>
            @if(isset($article->primary_school_name)){{$article->primary_school_name}}／@endif @if(isset($article->secondary_school_name)){{$article->secondary_school_name}}<br>@endif
            @if(isset($article->primary_school2_name)){{$article->primary_school2_name}}／@endif @if(isset($article->secondary_school2_name)){{$article->secondary_school2_name}}<br>@endif
            @if(isset($article->primary_school_name))<a href="/buy/bukkenlist?scc={{$article->primary_school_school}}">{{$article->primary_school_name}}区の物件一覧<i class="fas fa-chevron-right"></i></a><br>@endif
            @if(isset($article->primary_school2_name))<a href="/buy/bukkenlist?scc={{$article->primary_school2_school}}">{{$article->primary_school2_name}}区の物件一覧<i class="fas fa-chevron-right"></i></a><br>@endif
            @if(isset($article->secondary_school_name))<a href="/buy/bukkenlist?scc={{$article->secondary_school_school}}">{{$article->secondary_school_name}}区の物件一覧<i class="fas fa-chevron-right"></i></a><br>@endif
            @if(isset($article->secondary_school2_name))<a href="/buy/bukkenlist?scc={{$article->secondary_school2_school}}">{{$article->secondary_school2_name}}区の物件一覧<i class="fas fa-chevron-right"></i></a>@endif
        </dd>
    </dl>
    <dl class="overview__list">
        <dt>情報更新日</dt>
        <dd>{{$article->update}}</dd>
    </dl>
    <dl class="overview__list">
        <dt>次回更新予定日</dt>
        <dd>{{$article->next_update}}</dd>
    </dl>
    <small class="overview__alart">※図面と現況が異なる場合は、現況優先とします。<br>
    ※掲載物件は成約済・売却中止になる場合があります。<br>
    ※成約の際は仲介手数料とこれにかかる消費税が必要です。（当社が売主の物件除く）<br>
    ※写真に写っている、またはパースやCG、間取り図に描かれている家具や車などは、特に記載がない場合、物件価格に含まれません。
    </small>
</section>
