<!DOCTYPE html>
<html lang="ja">

<head>
    @include('home.head')
</head>

<body>
    <section class="print-page">
        <div class="wrapper">

            <a href="#" onclick="window.print()" class="print-page__button"><i class="fas fa-print"></i>このページを印刷する</a>
            <div class="print-page__wrapper">
                <div class="detail-sheet">
                    <div class="detail-sheet__title">
                        <div class="detail-sheet__tag-land">
                        @if($article->property == 1)
                            土地	
                        @elseif($article->property == 2)
                            土地（借地権）
                        @elseif($article->property == 3)
                            土地（底地権）
                        @elseif($article->property == 4)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            戸建
                        @elseif($article->property == 5)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            テラスハウス
                        @elseif($article->property == 6)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            マンション
                        @elseif($article->property == 7)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            タウンハウス
                        @endif	
                        </div>
                        <h2 class="detail-sheet__name">
                        {{$article->article_name}}（{{$article->main_traffic_station}}駅)
                        @if($article->property == 1)
                            土地	
                        @elseif($article->property == 2)
                            土地（借地権）
                        @elseif($article->property == 3)
                            土地（底地権）
                        @elseif($article->property == 4)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            戸建
                        @elseif($article->property == 5)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            テラスハウス
                        @elseif($article->property == 6)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            マンション
                        @elseif($article->property == 7)
                            @if($article->property_sub == 1) 
                                新築
                            @else 
                                中古
                            @endif
                            タウンハウス
                        @endif
                        </h2>
                    </div>
                    <div class="detail-sheet__info">
                        <div class="detail-sheet__price">
                            物件価格 <span><strong>{{$article->price}}</strong>万円</span>
                        </div>
                    </div>
                    <div class="detail-sheet__copy">
                    {{$article->catchcopy}}
                    </div>

                    <div class="print-page__overviews">
                        <dl class="detail-sheet__overview">
                            <dt>所在地</dt>
                            <dd>
                            {{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}
                            </dd>
                        </dl>
                        <dl class="detail-sheet__overview">
                            <dt>交通</dt>
                            <dd>{{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅　徒歩{{$article->main_traffic_time}}分</dd>
                        </dl>
                        <div class="detail-sheet__outline">
                        <dl><dt>土地面積：</dt><dd>{{$article->land_area_val}}㎡</dd></dl>
                        <dl><dt>建物面積：</dt><dd>{{$article->total_area_val}}㎡</dd></dl>
                        <dl><dt>間取り：</dt><dd>{{$article->floor_plan}}{{$article->floor_plan_name}}</dd></dl>
                        <dl><dt>築年月：</dt><dd>{{$article->age_year}}年{{$article->age_month}}月築</dd></dl>
                        <dl><dt>階数：</dt><dd>{{$article->whereabouts}}階／{{$article->floor}}階建</dd></dl>
                        <dl><dt>建築条件：</dt><dd>@if($article->land_condition == 1) 付 @else - @endif</dd></dl>
                        </div>
                    </div>
                </div>
                <div class="print-page__images">
                    @foreach($photos as $photo)
                    <div class="print-page__image">
                        <img src="{{$photo->disp_file_path}}" alt="">
                    </div>
                    @endforeach
                </div>
                <div class="print-page__copy">
                    {{$article->catchcopy}}
                </div>
                <div class="print-page__infos">
                    <div class="print-page__info">
                        <h2 class="print-page__title">周辺地図</h2>
                        <div class="print-page__content">
                        <iframe class="detail-map__iframe" src="https://maps.google.co.jp/maps?output=embed&q={{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}"
                                width="600" height="200" frameborder="0" style="border:0" allowfullscreen=""></iframe>
                            <div class="print-page__position">物件位置：{{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}</div>
                        </div>
                    </div>
                    <div class="print-page__info">
                        <h2 class="print-page__title">物件概要</h2>
                        <div class="print-page__content">
                        ■物件種別{{$article->property_name}}&nbsp;■物件名{{$article->article_name}}&nbsp;■価格{{$article->price}}万円
@if($article->tax==1)（税抜）
@else（税込）
@endif &nbsp;■所在地{{$article->pref_name}}{{$article->city_name}}{{$article->town_name}}&nbsp;■交通{{$article->main_traffic_line}}「{{$article->main_traffic_station}}」駅　徒歩{{$article->main_traffic_time}}分
@if(isset($article->sub_traffic1_line)){{$article->sub_traffic1_line}}「{{$article->sub_traffic1_station}}」駅　徒歩{{$article->sub_traffic1_time}}分
@endif 
@if(isset($article->sub_traffic2_line)){{$article->sub_traffic2_line}}「{{$article->sub_traffic2_station}}」駅　徒歩{{$article->sub_traffic2_time}}分
@endif 
@if($article->type!=4)&nbsp;■間取り{{$article->floor_plan}}{{$article->floor_plan_name}}
@endif 
@if($article->type==1)&nbsp;■所在階／階数{{$article->whereabouts}}階／{{$article->floor}}階建
@endif 
@if($article->type==2||$article->type==3)&nbsp;■階数{{$article->floor}}階建
@endif 
@if($article->type!=4)&nbsp;■構造{{$article->construction_name}}
@if($article->construction_sub_name!="")・一部{{$article->construction_sub_name}}
@endif 
@endif 
@if($article->type==1)&nbsp;■築年月{{$article->age_year}}年{{$article->age_month}}月築
@endif 
@if($article->type==2||$article->type==3)&nbsp;■完成時期{{$article->completed_year}}年{{$article->completed_month}}月{{$article->completed_text??''}}
@endif 
@if($article->type==1)&nbsp;■専有面積{{$article->total_area_val}}&nbsp;m&sup2;
@endif 
@if($article->type!=1)&nbsp;■土地面積{{$article->land_area}}&nbsp;m&sup2;
@endif 
@if($article->type==2||$article->type==3)&nbsp;■建物面積{{$article->building_plan_area}}&nbsp;m&sup2;
@endif 
@if($article->type==1)&nbsp;■バルコニー
@if($article->balcony_area==1){{$article->balcony_area_val}}&nbsp;m&sup2;
@endif &nbsp;■テラス面積
@if($article->terrace_area==1){{$article->terrace_area_val}}&nbsp;m&sup2;
@endif &nbsp;■専用庭面積
@if($article->garden_area==1){{$article->garden_area_val}}&nbsp;m&sup2;
@endif &nbsp;■管理費
@if($article->management==1){{$article->management_cost}}円
@endif /dd>&nbsp;■修繕積立金
@if($article->repair==1){{$article->repair_cost}}円
@endif 
@endif 
@if($article->type!=4)&nbsp;■有線放送に係る費用
@if($article->broadcasting==1)
@if($article->broadcasting_presence==1)初期費用：{{$article->broadcasting_cost}}円

@elseif($article->broadcasting_presence==2)共有
@endif 
@if($article->broadcasting_fixed_presence==1)定額費用：{{$article->broadcasting_fixed_cost}}円/
@if($article->running_cost_unit==1)月
@else年
@endif 

@elseif($article->broadcasting_fixed_presence==2)共有
@endif 
@else無し
@endif 
@endif 
@if($article->property!=1&&$article->property!=2&&$article->property!=3)&nbsp;■インターネットに係る費用
@if($article->internet==1)
@if($article->internet_presence==1)初期費用：{{$article->internet_cost}}円

@elseif($article->internet_presence==2)共有
@endif 
@if($article->internet_fixed_presence==1)定額費用：{{$article->internet_fixed_cost}}円/
@if($article->running_cost_unit==1)月
@else年
@endif 

@elseif($article->internet_fixed_presence==2)共有
@endif 
@else無し
@endif 
@endif 
@if($article->property!=1&&$article->property!=2&&$article->property!=3)&nbsp;■CATVに係る費用
@if($article->catv==1)
@if($article->catv_presence==1)初期費用：{{$article->catv_cost}}円

@elseif($article->catv_presence==2)共有
@endif 
@if($article->catv_fixed_presence==1)定額費用：{{$article->catv_fixed_cost}}円/
@if($article->running_cost_unit==1)月
@else年
@endif 

@elseif($article->catv_fixed_presence==2)共有
@endif 
@else無し
@endif 
@endif &nbsp;■町会費など
@if($article->council==1)町会費：

@elseif($article->council==2)町内会費：

@elseif($article->council==3)自治会費：
@endif 
@if($article->council_presence==0)無し

@elseif($article->council_presence==1){{$article->council_cost}}円/
@if($article->council_cost_unit==1)月

@elseif($article->council_cost_unit==2)年

@elseif($article->council_cost_unit==3)一括
@endif 

@elseif($article->council_presence==2)金額未定
@endif &nbsp;■温泉
@if($article->spring==1)温泉使用料：

@elseif($article->spring==2)温泉権利金：
@endif 
@if($article->spring_presence==0)無し

@elseif($article->spring_presence==1){{$article->spring_cost}}円/
@if($article->spring_cost_unit==1)月

@elseif($article->spring_cost_unit==2)年

@elseif($article->spring_cost_unit==3)一括
@endif 

@elseif($article->spring_presence==2)金額未定
@endif &nbsp;■その他費用１
@if($article->another_cost_name1){{$article->another_cost_name1}}：{{$article->another_cost1}}万/
@if($article->another_cost_unit1==1)月

@elseif($article->another_cost_unit1==2)年

@elseif($article->another_cost_unit1==3)一括
@endif 
@else無し
@endif &nbsp;■その他費用２
@if($article->another_cost_name2){{$article->another_cost_name2}}：{{$article->another_cost2}}万/
@if($article->another_cost_unit2==1)月

@elseif($article->another_cost_unit2==2)年

@elseif($article->another_cost_unit2==3)一括
@endif 
@else無し
@endif 
@if($article->type!=1)&nbsp;■接道
@if($article->land_kind1==1)公道
@if($article->land_direction1==1)北

@elseif($article->land_direction1==2)北東

@elseif($article->land_direction1==3)東

@elseif($article->land_direction1==4)南東

@elseif($article->land_direction1==5)南

@elseif($article->land_direction1==6)南西

@elseif($article->land_direction1==7)西

@elseif($article->land_direction1==8)北西
@endif 道路幅約{{$article->road_width1}}m&nbsp;間口約{{$article->frontage1}}m

@elseif($article->land_kind1==2)私道
@if($article->land_direction1==1)北

@elseif($article->land_direction1==2)北東

@elseif($article->land_direction1==3)東

@elseif($article->land_direction1==4)南東

@elseif($article->land_direction1==5)南

@elseif($article->land_direction1==6)南西

@elseif($article->land_direction1==7)西

@elseif($article->land_direction1==8)北西
@endif 道路幅約{{$article->road_width1}}m&nbsp;間口約{{$article->frontage1}}m
@endif 
@if($article->land_kind2==1)公道
@if($article->land_direction2==1)北

@elseif($article->land_direction2==2)北東

@elseif($article->land_direction2==3)東

@elseif($article->land_direction2==4)南東

@elseif($article->land_direction2==5)南

@elseif($article->land_direction2==6)南西

@elseif($article->land_direction2==7)西

@elseif($article->land_direction2==8)北西
@endif 道路幅約{{$article->road_width2}}m&nbsp;間口約{{$article->frontage2}}m

@elseif($article->land_kind2==2)私道
@if($article->land_direction2==1)北

@elseif($article->land_direction2==2)北東

@elseif($article->land_direction2==3)東

@elseif($article->land_direction2==4)南東

@elseif($article->land_direction2==5)南

@elseif($article->land_direction2==6)南西

@elseif($article->land_direction2==7)西

@elseif($article->land_direction2==8)北西
@endif 道路幅約{{$article->road_width2}}m&nbsp;間口約{{$article->frontage2}}m
@endif 
@if($article->land_kind3==1)公道
@if($article->land_direction3==1)北

@elseif($article->land_direction3==2)北東

@elseif($article->land_direction3==3)東

@elseif($article->land_direction3==4)南東

@elseif($article->land_direction3==5)南

@elseif($article->land_direction3==6)南西

@elseif($article->land_direction3==7)西

@elseif($article->land_direction3==8)北西
@endif 道路幅約{{$article->road_width3}}m&nbsp;間口約{{$article->frontage3}}m

@elseif($article->land_kind3==2)私道
@if($article->land_direction3==1)北

@elseif($article->land_direction3==2)北東

@elseif($article->land_direction3==3)東

@elseif($article->land_direction3==4)南東

@elseif($article->land_direction3==5)南

@elseif($article->land_direction3==6)南西

@elseif($article->land_direction3==7)西

@elseif($article->land_direction3==8)北西
@endif 道路幅約{{$article->road_width3}}m&nbsp;間口約{{$article->frontage3}}m
@endif &nbsp;■セットバック{{$article->set_area}}&nbsp;■私道負担
@if($article->road_burden==1)私道面積：{{$article->road_burden_area}}m&sup2;

@elseif($article->road_burden==2)私道面積：{{$article->road_burden_area}}m&sup2;私道持分比率{{$article->road_numerator}}/{{$article->road_denominator}}
@else無し
@endif 
@endif &nbsp;■用途地域{{$article->use_area_name}}
@if($article->use_area_name_sub!="")一部{{$article->use_area_name_sub}}を含む
@endif 
@if($article->type!=1)&nbsp;■建ぺい率{{$article->building_rate}}%&nbsp;■容積率{{$article->volume_rate}}%&nbsp;■地目{{$ground[$article->ground]??'-'}}
@endif &nbsp;■坂道レベル{{$article->original3}}
@if($article->type==4)&nbsp;■建築条件
@if($article->land_condition==0)条件なし

@elseif($article->land_condition==1)建築条件付き
@endif 
@endif 
@if($article->type==1||$article->type==2)&nbsp;■総戸数{{$article->total_unit}}戸
@endif 
@if($article->type==4)&nbsp;■総区画数{{$article->section}}区画
@endif 
@if($article->type!=4)&nbsp;■駐車場
@if($article->parking==1)無

@elseif($article->parking==2)空無

@elseif($article->parking==3)空有

@elseif($article->parking==4)分譲（必購入）

@elseif($article->parking==5)分譲（任意購入）

@elseif($article->parking==6)専用使用権付

@elseif($article->parking==7)敷地外有

@elseif($article->parking==11)カースペース

@elseif($article->parking==12)カーポート

@elseif($article->parking==13)２台以上
@endif 
@endif &nbsp;■現況
@if($article->land_status_name!=""){{$article->land_status_name}}
@else不明
@endif 
@if($article->type==1||$article->type==4)&nbsp;■引渡し
@if($article->land_delivery==1)即日

@elseif($article->land_delivery==3){{$article->delivery_year}}年{{$article->delivery_month}}
@if($article->land_delivery_time==1)初旬

@elseif($article->land_delivery_time==2)上旬

@elseif($article->land_delivery_time==3)中旬

@elseif($article->land_delivery_time==4)下旬

@elseif($article->land_delivery_time==5)末
@endif 
@endif 
@endif 
@if($article->type==2||$article->type==3)&nbsp;■引き渡し
@if($article->move_in==1)即引き渡し可

@elseif($article->move_in==2)相談

@elseif($article->move_in==3){{$article->move_in_year}}年{{$article->move_in_month}}月

@elseif($article->move_in==4)契約後{{$article->move_in_contract_month}}ヶ月

@elseif($article->move_in==5)不明
@endif 
@endif &nbsp;■設備
@if($article->water_supply==1)公営水道

@elseif($article->water_supply==2)私設水道

@elseif($article->water_supply==3)井戸
@endif 
@if($article->sewerage==1)本下水

@elseif($article->sewerage==2)集中浄化槽

@elseif($article->sewerage==3)個別浄化槽
@endif 
@if($article->gas==1)都市ガス

@elseif($article->gas==2)集中ＬＰＧ

@elseif($article->gas==3)個別ＬＰＧ

@elseif($article->gas==4)オール電化
@endif 
@if($article->parking==8)掘込車庫

@elseif($article->parking==9)車庫

@elseif($article->parking==10)地下車庫
@endif 
@if($article->type==2)&nbsp;■建築確認番号{{$article->architecture_no}}&nbsp;■開発許可番号{{$article->developer_number}}
@endif 
@if($article->type==1)&nbsp;■管理形態{{$article->management_name}}&nbsp;■管理会社{{$article->management_company}}
@endif &nbsp;■取引態様{{$article->manner_name}}&nbsp;■学校区{{$article->primary_school_name}}／{{$article->secondary_school_name}}&nbsp;■情報更新日{{$article->update}}&nbsp;■次回更新予定日{{$article->next_update}}                            <br>
                            <br> ※ 図面と現況が異なる場合は、現況を優先とします。<br> ※ 掲載物件は成約済み・売却中止となる場合があります。<br> ※ 成約の際は仲介手数料とこれにかかる消費税が必要です。（当社が売主の物件除く）

                        </div>
                    </div>
                </div>
                <div class="print-page__contact">
                    <div class="print-page__footer">
                        <div class="print-page__logo">
                            <img src="{{root('img/logo.png')}}" alt="">
                        </div>
                        <div class="print-page__shop">
                            <div class="print-page__shop-info">
                                <a href="">三春情報センター{{$store->name}}</a><br> 営業時間 {{$store->business_hours}}<br> 定休日 {{$store->holiday}}
                            </div>
                        </div>
                        <div class="print-page__tel">
                            <a href="tel:{{$store->freedial}}" class="print-page__number"><i class="fas fa-phone"></i>{{$store->freedial}}</a>
                            <div class="print-page__address">
                                    {{$store->name}}<br>
                                    FAX：{{$store->fax}}（代表）
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <a href="#" onclick="window.print()" class="print-page__button"><i class="fas fa-print"></i>このページを印刷する</a>

        </div>
    </section>
</body>

</html>