@extends('home.template')
@section('head')
@endsection

@section('content')

<div class="grey-back" id='buy'>

<div class="wrapper">

<h2 class="page-title"><em>住まいを探す</em><strong><img src="{{root('img/buy/icon_search.png')}}" alt="">学校区から探す</strong></h2>
<p>ご希望の区名の小学校・中学校を一つ選んでください。</p>
<div class="school-wrap">
@foreach($items as $key => $item)
  <h3>{{$key}}の学校</h3>
  @if(count($item['secondary']) > 0)
  <div class="school-box">
    <h4>{{$key}}の小学校</h4>
    <ul class="school-box-name">
      @foreach($item['secondary'] as $row)
      <li @if(floor((($loop->iteration - 1) / 3)) % 2 == 1) class="line"@endif><a href="{{route('search-list', ['area' => $row['area'], 'scc' => $row['code']])}}">{{$row['name']}}（{{$row['count']}}）</a><i class="fas fa-chevron-right"></i></li>
      @endforeach
    </ul>
  </div>
<hr />
  @endif
  @if(count($item['primary']) > 0)
  <div class="school-box">
    <h4>{{$key}}の中学校</h4>
    <ul class="school-box-name">
      @foreach($item['primary'] as $row)
      <li @if(floor((($loop->iteration - 1) / 3)) % 2 == 1) class="line"@endif><a href="{{route('search-list', ['area' => $row['area'], 'scc' => $row['code']])}}">{{$row['name']}}（{{$row['count']}}）</a><i class="fas fa-chevron-right"></i></li>
      @endforeach
    </ul>
  </div>
  @endif
@endforeach


</div>


</div><!--#wrapper-->
</div><!--#buy-->
@endsection
