<section class="side-recommend">
    <h2 class="side-recommend__headline">
        この物件を見た人は<br>
        こんな物件も見ています。
    </h2>
    <nav class="side-recommend__links">
    @foreach($recommend as $row)
        <a href="/buy/detail/{{$row->article_id}}" class="side-recommend__link">
            <div class="side-recommend__image">
               <figure>
                @if(isset($row->file_path))
                <img src="{{$row->file_path}}" alt="">
                @else
                <img src="{{root('img/noimage2.jpg')}}" alt="">
                @endif
                 <figcaption><i class="fas fa-chevron-right"></i></figcaption></figure>
                    @if($row->property == 1)
                    <div class="side-recommend__tag-land">土地</div>
                    @elseif($row->property == 2)
                    <div class="side-recommend__tag-land">土地（借地権）</div>
                    @elseif($row->property == 3)
                    <div class="side-recommend__tag-land">土地（底地権）</div>
                    @elseif($row->property == 4)
                    <div class="side-recommend__tag-nhouse">戸建</div>
                    @elseif($row->property == 5)
                    <div class="side-recommend__tag-nhouse">テラスハウス</div>
                    @elseif($row->property == 6)
                    <div class="side-recommend__tag-mansion">マンション</div>
                    @elseif($row->property == 7)
                    <div class="side-recommend__tag-mansion">タウンハウス</div>
					@endif
            </div>
            <div class="side-recommend__infos">
                <div class="side-recommend__name">
                {{$row->article_name}}
                </div>
                <dl class="side-recommend__price">
                    <dt>
                        <i class="fas fa-yen-sign"></i>
                    </dt>
                    <dd>
                        <span>{{number_format($row->price)}}</span>万円@if($article->tax == 1)（税抜）@else（税込）@endif
                    </dd>
                </dl>
                <dl class="side-recommend__info">
                    <dt>
                        <i class="fas fa-map-marker-alt"></i>
                    </dt>
                    <dd>{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}{{$row->adress}}</dd>

                </dl>
                <dl class="side-recommend__info">
                    <dt>
                        <i class="fas fa-subway"></i>
                    </dt>
                    <dd>{{$row->main_traffic_line}}&nbsp;「{{$row->main_traffic_station}}」&nbsp;徒歩{{$row->main_traffic_time}}分</dd>
                </dl>
            </div>
        </a>
    @endforeach
    </nav>
</section>
