@extends('home.template')
@section('head')
@endsection

@section('content')

<section class="favorite-first">
    <div class="wrapper">
        <div class="favorite-first__explain">
            物件情報ページにある「お気に入り」ボタンをクリックすると、「お気に入り」に登録できます。<br> 登録した物件は「お気に入り」ページでいつでもご確認いただけますので、ぜひご利用ください。
            <br> <small>※お気に入りリストの登録にはCookieとJavascriptを使用しています。これらの機能をONにしてください。</small>
        </div>
        <div class="favorite-first__title">
            <i class="fas fa-search"></i>物件種別から探す
        </div>
        <nav class="favorite-first__lists">
            <a href="javascript:filter(0, 'すべての物件')" class="favorite-first__list menu-0 selected">すべての物件（<span id="number-0">8</span>件）</a>
            <a href="javascript:filter(4, '中古マンション')" class="favorite-first__list menu-4">中古マンション（<span id="number-4">2</span>件）</a>
            <a href="javascript:filter(3,'新築一戸建て')" class="favorite-first__list menu-3">新築一戸建て（<span id="number-3">2</span>件）</a>
            <a href="javascript:filter(2, '中古一戸建て')" class="favorite-first__list menu-2">中古一戸建て（<span id="number-2">2</span>件）</a>
            <a href="javascript:filter(1, '土地')" class="favorite-first__list menu-1">土地（<span id="number-1">2</span>件）</a>
        </nav>
    </div>
</section>

<section class="favorite-list">
    <div class="inner">
        <div class="favorite-list__number">
            すべての物件：<span id="total">8</span>件
        </div>
        <div class="favorite-list__buttons">
            <a href="#" class="favorite-list__check-button" id="chkall">
				<i class="far fa-check-square"></i>すべてをチェック
			</a>
            <a href="" class="favorite-list__whole-button">チェックした物件をまとめてお問い合わせ</a>
        </div>
		<script type="text/javascript">
			
			
		</script>

<div class="list-links__box type-1" id="1" name="物件1">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件1</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <div class="tags__tag-land">土地</div> <!----> <!----></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__model">オープンハウス開催 2月16日（土）、17日（日）　13：00～17：00</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件1" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="1" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt><dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt><dd>ブルーライン「上永谷」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl>
<dl class="list-links__piece"><dt>建物面積</dt><dd>60㎡</dd></dl>
<dl class="list-links__piece"><dt>間取り</dt> <dd>4LDK</dd></dl>
<dl class="list-links__piece"><dt>築年月</dt> <dd>1994年5月築</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
 </div>
 </a>
</section>
 </div>
       
<div class="list-links__box type-1" id="2" name="物件2">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件2</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-land">土地</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>
          





<div class="list-links__box type-2" name="物件3" id="3">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件3</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-mansion">中古一戸建て</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>



<div class="list-links__box type-2" name="物件4" id="2">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件4</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-mansion">中古一戸建て</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>

<div class="list-links__box type-3" name="物件5" id="5">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件5</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-nhouse">新築一戸建て</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>
<div class="list-links__box type-3" name="物件6" id="6">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件6</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-nhouse">新築一戸建て</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>
<div class="list-links__box type-4" name="物件7" id="7">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件7</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-price">中古マンション</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>
<div class="list-links__box type-4" name="物件8" id="8">
<label class="favorite-list__check"><input type="checkbox" name="ids[]"></label>
<section class="list-style">
<div class="list-links__upper">
<div class="list-links__infos">
<div class="list-links__title">物件8</div>
<section class="tags"><div class="tags__tag-new">NEW</div> <!----> <!----> <!----> <div class="tags__tag-price">中古マンション</div></section>
</div>
<section class="icons">
<a href="" class="icons__icon"><i class="fas fa-heart pink"></i> <div>お気に入り</div></a>
<a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a>
<a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a>
</section>
</div>
<div class="list-links__copy">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
<div class="list-links__details">
<div class="list-links__photo"><img src="/img/property/photo1.jpg" alt="物件2" class="list-links__img">
<div class="list-option__style">
<div class="list-option__radio selected"><i class="fas fa-camera"></i>写真表示</div>
<div class="list-option__radio"><i class="fas fa-ruler-combined"></i>間取り表示</div>
</div>
</div>
<a href="2" class="list-links__detail">
<dl class="list-links__data"><dt><i class="fas fa-yen-sign"></i>物件価格</dt><dd class="list-links__price"><span>3,280</span>万円</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-map-marker-alt"></i>所在地</dt> <dd>神奈川県横浜市南区</dd></dl>
<dl class="list-links__data"><dt><i class="fas fa-subway"></i>交通</dt> <dd>ブルーライン「上永谷」 徒歩22分、ブルーライン「港南中央」 徒歩22分</dd></dl>
<div class="list-links__pieces">
<dl class="list-links__piece"><dt>土地面積</dt><dd>100㎡</dd></dl><!----> <!----> <!----> <!---->
<dl class="list-links__piece"><dt>建築条件</dt><dd>付</dd></dl>
</div>
<div class="list-links__flow">
<div class="list-links__pictures"><i class="fas fa-camera"></i>29枚</div>
<div class="list-links__watch">詳細を見る<i class="fas fa-chevron-right"></i></div>
</div>
</a>
</section>
</div>
</div>

<!--
        <div class="favorite-list__one">
            <label class="favorite-list__check">
                <input type="checkbox" name="ids[]">
            </label>
            <section class="list-style">
                <div class="list-style__upper">
                    <div class="list-style__image">
                        <img src="{{root('img/property/photo1.jpg')}}" alt="">
                    </div>
                    <div class="list-style__main-info">
                        <div class="list-style__title">
                            <div class="list-style__name">
                                日野４（上永谷駅） 新築戸建
                            </div>
                            @include('home.parts.tags')
                        </div>
                        @include('home.parts.icons')
                    </div>
                    <div class="list-style__points">
                        ■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています
                    </div>
                </div>
                <div class="list-style__details">
                    <dl class="list-style__detail">
                        <dt><i class="fas fa-yen-sign"></i>物件価格</dt>
                        <dd class="list-style__price"><span>3,280</span>万円</dd>
                    </dl>
                    <dl class="list-style__detail">
                        <dt><i class="fas fa-map-marker-alt"></i>所在地</dt>
                        <dd>神奈川県横浜市南区</dd>
                    </dl>
                    <dl class="list-style__detail">
                        <dt><i class="fas fa-subway"></i>交通</dt>
                        <dd>ブルーライン「上永谷」 徒歩22分　ブルーライン「港南中央」 徒歩22分</dd>
                    </dl>
                    <div class="list-style__others">
                        <dl class="list-style__other">
                            <dt>間取り</dt>
                            <dd>●LDK</dd>
                        </dl>
                        <dl class="list-style__other">
                            <dt>建物面積</dt>
                            <dd>●●㎡</dd>
                        </dl>
                        <dl class="list-style__other">
                            <dt>土地面積</dt>
                            <dd>●●㎡</dd>
                        </dl>
                        <dl class="list-style__other">
                            <dt>建築年月</dt>
                            <dd>●●年●月築</dd>
                        </dl>
                    </div>
                    <div class="list-style__last">
                        <div class="list-style__camera">
                            <i class="fas fa-camera"></i>29枚
                        </div>
                        <div class="list-style__flow">
                            詳細を見る<i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </section>
        </div>-->
        
    </div>
</section>
<style type="text/css">
    @media screen and (max-width: 768px) {
        .wrapper {
            width: auto;
        }

        .header__link-wrapper .header__link {
            margin: 0 25px 0 0;
        }

        .inner {
            width: auto;
        }

        .header__form .header__input {
            width: 200px;
        }

        .inner .favorite-list__buttons {
            display: flex;
        }

        .header__button i {
            margin-bottom: 10px;
        }
    }
	
	.favorite-first__list span{
		color: #EDB35D;
		font-size: 13px;
	}
	
	.favorite-first__list.selected span{
		background-color: #EDB35D;
		color: white;
	}
	
	.favorite-first__list:hover span{
		background-color: #EDB35D;
		color: white;
	}
</style>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

<script type="text/javascript">

var checkedall = false;
			
			
  // Handler for .ready() called.
	var i;
	
	



$("#chkall").click(function(event){
	event.preventDefault();
	if (checkedall == false){
		$('input[type=checkbox]').prop('checked', true);
		checkedall = true; 
	} 
	else {
		$('input[type=checkbox]').prop('checked', false);
		checkedall = false; 
	}
});

function filter(type, type_name){
	
	$('.favorite-first__list').removeClass('selected');
	if( type == 1 ){
		$('.list-links__box').hide();
		$(".type-1" ).show();
		$('.favorite-first__list').removeClass('selected');
		$(".menu-1").addClass("selected");
	}
	if( type == 2 ){
		$('.list-links__box').hide();
		$(".type-2" ).show();
		$('.favorite-first__list').removeClass('selected');
		$(".menu-2").addClass("selected");
	}
	if( type == 3 ){
		$('.list-links__box').hide();
		$(".type-3" ).show();
		$('favorite-first__list').removeClass('selected');
		$(".menu-3").addClass("selected");
	}
	if( type == 4 ){
		$('.list-links__box').hide();
		$(".type-4" ).show();
		$('.favorite-first__list').removeClass('selected');
		$(".menu-4").addClass("selected");
	}
	if( type == 0 ){
		$('.list-links__box').show();
		$('.favorite-first__list').removeClass('selected');
		
		$(".menu-0").addClass("selected");
	}
	
	
	
	countType(type);
	
	let total = $('.list-links__box:visible').length;
	if(type > 0)$('.type-'+type).length;
	$(".favorite-list__number").contents().first()[0].textContent=type_name;
	$("#total").html(total);
}

function countType(type){
	let total = 0;
	if(type > 0){
		total = $('.type-'+type).length;
		
		$("#number-"+type).html(total);
	}
	total = $('.list-links__box').length;
	$("#number-0").html(total);
	$("#total").html(total);
	
	
}

$(".fa-heart").on('click', function(event){	

	$(this).closest('div[class^="list-links__box"]').remove();
	countType(1);
	countType(2);
	countType(3);
	countType(4);
	//countType(0);
	
	let total = $('.list-links__box:visible').length;//0$('.').length;:visible
	$("#total").html(total);
	
});


</script>
@endsection


