<div class="recommend__list">
    @foreach($recommend as $row)
    <a class="recommend__component" href="/buy/detail/{{$row->article_id}}">
        <figure>
            @if(isset($row->file_path) && $row->file_path != "")
            <img src="{{$row->file_path}}" alt="">
            @else
            <img src="{{root('img/noimage2.jpg')}}" alt="">
            @endif
            <figcaption><i class="fas fa-chevron-right"></i></figcaption>
        </figure>
        <div class="recommend__info">
            <div class="recommend__top">
                <div class="recommend__date">
                    {{$row->created_at->format('Y/m/d')}}
                </div>
                @if($row->property != null && $row->property != 99)
                <div class="recommend__tag">
                    @if($row->property == 1)
						土地	
                    @elseif($row->property == 2)
                        土地（借地権）
                    @elseif($row->property == 3)
                        土地（底地権）
                    @elseif($row->property == 4)
                        戸建
                    @elseif($row->property == 5)
                        テラスハウス
                    @elseif($row->property == 6)
                        マンション
                    @elseif($row->property == 7)
                        タウンハウス
					@endif	
                </div>
                @endif
            </div>
            <div class="recommend__name">
                {{$row->article_name}}
            </div>
            <dl class="recommend__detail">
                <dt class="recommend__detail-pricedt"><i class="fas fa-yen-sign"></i></dt>
                <dd class="recommend__detail-pricedd"><strong>{{number_format($row->price)}}</strong>万円</dd>
            </dl>
            <dl class="recommend__detail">
                <dt><i class="fas fa-map-marker-alt"></i></dt>
                <dd>{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}{{$row->adress}}</dd>
            </dl>
            <dl class="recommend__detail">
                <dt><i class="fas fa-subway"></i></dt>
                <dd>{{$row->main_traffic_line}}&nbsp;「{{$row->main_traffic_station}}」&nbsp;徒歩{{$row->main_traffic_time}}分</dd>
            </dl>
            <div class="recommend__view">
                詳細をみる<i class="fas fa-chevron-right"></i>
            </div>
        </div>
    </a>

    @endforeach
    <a href="/buy/recommended.html" class="recommend-overviews__link">
    おすすめ物件一覧を見る<i class="fas fa-chevron-right"></i>
    </a>
</div>