@extends('home.template')
@section('head')
@endsection

@section('content')
<section class="reform-detail">
    <div class="wrapper">
        <div class="reform-detail__image">

            <img src="{{root('img/reform/example1.jpg')}}" alt="">
        </div>
        <div class="static-first__info">
            <h2 class="static-first__title">FILE<span>01</span></h2>
            <p class="static-first__JP">{{$reform->title}}</p>
            <div class="static-first__line"></div>
        </div>
    </div>
</section>
<section class="reform-details">
    <div class="reform-details__one">
        <div class="reform-details__title">
            Data
        </div>
        <div class="reform-details__lists">
            <dl class="reform-details__list">
                <dt>物件種別</dt>
                <dd>{{$category[$reform->category]}}</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>築年</dt>
                <dd>{{$reform->age}}年</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>エリア</dt>
                <dd>{{$reform->area}}</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>リフォーム費用</dt>
                <dd>{{$reform->cost}}万円</dd>
            </dl>
            <dl class="reform-details__list__long">
                <dt>施工箇所</dt>
                <dd>{{$reform->target}}</dd>
            </dl>
        </div>
    </div>
    <div class="reform-details__one">
        <div class="reform-details__title">
            Gallery
        </div>
        <!--スライド-->
        <div id="slider" class="swiper-container">
            <div class="swiper-wrapper">
@foreach($photos as $photo)
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{$photo->disp_file_path}}" alt="">
                    </div>
                    <span class="caption">{{$photo->memo}}</span>
                </div>
@endforeach
            </div>
            <div class="swiper-button-prev swiper-button-white"></div>
            <div class="swiper-button-next swiper-button-white"></div>
        </div>

        <div id="thumbs" class="swiper-container mb60">
            <div class="swiper-wrapper">
@foreach($photos as $photo)
                <div class="swiper-slide">
                    <img src="{{$photo->disp_file_path}}" alt="">
                </div>
@endforeach
            </div>
        </div>

    </div>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/css/swiper.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/js/swiper.min.js"></script>
    <script>
        var galleryThumbs = new Swiper('#thumbs', {
            spaceBetween: 10,
			slidesPerView: {{$photos_count}},
			loop: true,
			freeMode: true,
			loopedSlides: {{$photos_count}}, //looped slides should be the same
			watchSlidesVisibility: true,
			watchSlidesProgress: true,
			slideToClickedSlide: true,
			touchRatio: 0.2,
			autoplay: 2000,
			speed: 200
        });
        var galleryTop = new Swiper('#slider', {
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000,
            },
            loopedSlides: {{$photos_count}}, //looped slides should be the same
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            thumbs: {
                swiper: galleryThumbs,
            },
        });
        // var slider = new Swiper('#slider', {
        //     nextButton: '.swiper-button-next',
        //     prevButton: '.swiper-button-prev'
        // })
        // var thumbs = new Swiper('#thumbs', {
        //     centeredSlides: false,
        //     spaceBetween: 10,
        //     slidesPerView: "auto",
        //     touchRatio: 0.2,
        //     slideToClickedSlide: true,
        //     autoplay: 2000,
        //     speed: 200,
        //     on: {
        //         init: function() {
        //             console.log('swiper initialized');
        //         },
        //         slideChange: function() {
        //             var swiper = this;
        //             for (var i = 0; i < swiper.slides.length; i++) {
        //                 var slideProgress = swiper.slides[i].progress;
        //                 var innerOffset = swiper.width * interleaveOffset;
        //                 var innerTranslate = slideProgress * innerOffset;
        //                 swiper.slides[i].querySelector(".slide-inner").style.transform =
        //                     "translate3d(" + 0 + "px, 0, 0)";
        //             }
        //         },
        //     }
        // });

        // slider.params.control = thumbs;
        // thumbs.params.control = slider;
    </script>

    <!--スライド-->

    </div>

    <div class="reform-details__one">

        <div class="reform-details__bfaf">
            <div class="reform-details__bfaf-photos">
                <div class="reform-details__before">
                    <div class="reform-details__mini-title">
                        Before図面
                    </div>
                    <div class="zumen-wrap">
                    @if(!empty($reform->disp_before))
                    <img src="{{$reform->disp_before}}"/>
                    @else
                    <img src="{{root('img/noimage2.jpg')}}"/>
                    @endif
                    </div>
                </div>
                <div class="reform-details__arrow">
                    <span class="arrow"></span>
                </div>
                <div class="reform-details__after">
                    <div class="reform-details__mini-title">
                        After図面
                    </div>
                    <div class="zumen-wrap">
                    @if(!empty($reform->disp_after))
                    <img src="{{$reform->disp_after}}"/>
                    @else
                    <img src="{{root('img/noimage2.jpg')}}"/>
                    @endif
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="reform-details__one">
        <div class="reform-details__title">
            プランの特徴
        </div>
        <p class="reform-details__paragraph">
        {{$reform->plan}}
        </p>
    </div>

    <div class="reform-details__wrapper">
        <div class="reform-details__one">
            <div class="reform-details__title">
                施工のポイント
            </div>
            <p class="reform-details__paragraph">
            {{$reform->point}}
            </p>
        </div>
    </div>


    <div class="wrapper">
        <div class="reform-details__links">
            @if($prev != "")
            <a href="/reform/works/{{$prev}}.html" class="reform-details__link"><i class="fas fa-chevron-left"></i>前の事例を見る</a>
            @else
            <span></span>
            @endif
            <a href="../example" class="reform-details__link">施工事例一覧に戻る</a>
            @if($next != "")
            <a href="/reform/works//{{$next}}.html" class="reform-details__link">次の事例を見る<i class="fas fa-chevron-right"></i></a>
            @else
            <span></span>
            @endif
        </div>
    </div>
</section>

<section class="reform-detail-contact">

    <div class="wrapper">

        <div class="reform-detail-contact__title">
            CONTACT
        </div>
        <div class="reform-detail-contact__jp">
            お気軽にご相談くださいませ。
        </div>
        <p class="reform-detail-contact__paragraph">
            中古物件＋リフォームに関するお問い合わせや<br class="br_sp">ご相談など、お気軽にご連絡ください。
        </p>
        <div class="reform-detail-contact__rooms">
            <div class="reform-detail-contact__room">
                <div class="reform-detail-contact__image">
                    <img class="pc" src="{{root('img/reform/room1.jpg')}}" alt="">
                    <img class="sp" src="{{root('img/reform/main.jpg')}}" alt="">
                </div>
                <div class="reform-detail-contact__info">
                    <div class="reform-detail-contact__name">
                        磯子ショールーム
                    </div>
                    <div class="reform-detail-contact__text">
                        理想の住まい創りのアイディアが詰め込まれた2LDK（約70 ㎡）のタイプのショールームをご覧いただけます。
                    </div>
                    <div class="reform-detail-contact__contact">
                        <span class="reform-detail-contact__tel"><i class="fas fa-phone"></i>0120-33-8730</span>

                        <a class="sp_tel" href="tel:0120-33-8730"><i class="fas fa-phone"></i>0120-33-8730</a>


                        <a href="/reform/reserve" class="reform-detail-contact__mail"><i class="far fa-envelope"></i>来場予約</a>
                    </div>
                </div>
            </div>



            <div class="reform-detail-contact__room">
                <div class="panf">
                    <img src="{{root('img/reform/panf.png')}}" alt=""></div>
            </div>



        </div>
    </div>
</section>
@endsection