@extends('home.template')
@section('head')
@endsection

@section('content')

<p class="lead_sp">ご家族のこだわりにあわせた<br />オーダーメイド設計だから、リフォームして<br />生まれた住まいのカタチも多種多様。<br /> 個性溢れるオーダーメイド空間と<br />住みごこち、くらしの変化などをご覧ください。</p>


<section class="reform-examples">
    <div class="wrapper">
        @foreach($reform as $row)
        <a class="reform-examples__two" href="/reform/works/{{$row->code}}.html">
            <div class="reform-examples__image">
                @if(!empty($row->file_path))
                <img src="{{$row->file_path}}"/>
                @else
                <img src="{{root('img/noimage_reform.png')}}" />
                @endif
            </div>
            <div class="reform-examples__info">
                <div class="reform-examples__order">
                    <div class="reform-examples__file">
                        FILE
                    </div>
                    <div class="reform-examples__number">
                        {{ sprintf('%02d', $loop->iteration) }}
                    </div>
                </div>
                <div class="reform-examples__title">
                    {{$row->title}}
                </div>
                <div class="reform-examples__text">
                    {{$row->point}}
                </div>
                <div class="reform-examples__lists">
                    <dl class="reform-examples__list">
                        <dt>物件種別</dt>
                        <dd>
                            @if($row->category == 1)
                                マンション
                            @elseif($row->category == 2)
                                戸建
                            @else
                                -
                            @endif
                        </dd>
                    </dl>
                    <dl class="reform-examples__list">
                        <dt>築年</dt>
                        <dd>{{$row->age}}年</dd>
                    </dl>
                    <dl class="reform-examples__list">
                        <dt>エリア</dt>
                        <dd>{{$row->area}}</dd>
                    </dl>
                    <dl class="reform-examples__list">
                        <dt>リフォーム費用</dt>
                        <dd>{{$row->cost??'-'}}万円</dd>
                    </dl>
                    <dl class="reform-examples__list__long">
                        <dt>施工箇所</dt>
                        <dd>{{$row->target}}</dd>
                    </dl>
                </div>
            </div>
        </a>
        @endforeach
    </div>
</section>
@endsection