@extends('home.template')
@section('head')
@endsection

@section('content')
<section class="shop-infos">
    <div class="wrapper">
        <div class="shop-infos__two">
            <div class="shop-infos__info">
                <div class="shop-infos__headline">
                    <div class="shop-infos__name">
                        {{$shop->name}}
                    </div>
                    <div class="shop-infos__contact">
                        <a href="" class="shop-infos__tel"><i class="fas fa-phone"></i>{{$shop->freedial}}</a>
                        <a href="/reserve/{{$shop->code}}" class="shop-infos__mail"><i class="far fa-envelope"></i>来場予約</a>
                    </div>
                </div>
                <div class="shop-infos__lists">
                    <dl class="shop-infos__list">
                        <dt>住所</dt>
                        <dd>{{$shop->pref_name}}{{$shop->city_name}}{{$shop->town_name}}{{$shop->address4}}</dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>TEL</dt>
                        <dd>{{$shop->tel}}</dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>FAX</dt>
                        <dd>{{$shop->fax}}</dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>メール</dt>
                        <dd>{{$shop->email}}</dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>営業時間</dt>
                        <dd>{!! nl2br(e($shop->business_hours)) !!}</dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>定休日</dt>
                        <dd>{!! nl2br(e($shop->holiday)) !!}
                        </dd>
                    </dl>
                    <dl class="shop-infos__list">
                        <dt>駐車台数</dt>
                        <dd>{{$shop->parking}}</dd>
                    </dl>
                </div>
            </div>
            <div class="shop-infos__visuals">

                <iframe class="detail-map__iframe" src="https://maps.google.co.jp/maps?output=embed&q={{$shop->pref_name}}{{$shop->city_name}}{{$shop->town_name}}{{$shop->address4}}"
                    width="600" height="300" frameborder="0" style="border:0" allowfullscreen=""></iframe>

                <div class="shop-infos__images">
                    <div class="shop-infos__image">
                        @if(isset($photos[0]))
                        <img src="{{$photos[0]->file_path}}" alt="">
                        <span class="shop-infos__image__text">
                            {{$photos[0]->memo??''}}
                        </span>
                        @endif
                    </div>
                    <div class="shop-infos__image">
                        @if(isset($photos[1]))
                        <img src="{{$photos[1]->file_path}}" alt="">
                        <span class="shop-infos__image__text">
                            {{$photos[1]->memo??''}}
                        </span>
                        @endif
                    </div>
                    
                    
                    <div class="shop-infos__image">
                        @if(isset($photos[2]))
                        <img src="{{$photos[2]->file_path}}" alt="">
                        <span class="shop-infos__image__text">
                            {{$photos[2]->memo??''}}
                        </span>
                        @endif
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</section>

<section class="shop-message">
    <div class="wrapper">
        <div class="shop-message__title">{{$shop->name}}のスタッフからのメッセージ</div>
        <div class="shop-message__two">
            <div class="shop-message__message">
                {!! nl2br(e($shop->comment)) !!}
            </div>
            <div class="shop-message__images">
                @if(isset($photos[3]))
                <div>
                    <img src="{{$photos[3]->file_path}}" alt="">
                    <span>
                    {{$photos[3]->memo??''}}
                    </span>
                </div>
                @endif
                @if(isset($photos[4]))
                <div>
                    <img src="{{$photos[4]->file_path}}" alt="">
                    <span>
                    {{$photos[4]->memo??''}}
                    </span>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<div class="shop-infos__contact-sp">
    <a href="" class="shop-infos__tel"><i class="fas fa-phone"></i>{{$shop->freedial}}</a>
    <a href="/reserve" class="shop-infos__mail"><i class="far fa-envelope"></i>来場予約</a>
</div>

<section class="shop-staffs">
    <div class="wrapper">
        <h3 class="shop-staffs__headline">{{$shop->name}}のスタッフ一覧</h3>
        <p class="shop-staffs__text">クリックで詳細をご覧いただけます。</p>
        <div class="shop-staffs__list">
@foreach($staffs as $staff)
                <a class="shop-staffs__staff" href="/staff/{{$staff->employee_number}}.html">
                <dl>
                    <dt>
                    @if(!empty($staff->file_path))
                    <img src="{{$staff->file_path}}" />
                    @else
                    <img src="{{root('img/noimage2.jpg')}}"  />
                    @endif
                    </dt>
                    <dd><strong>{{$staff->last_name}} {{$staff->first_name}}</strong><small>{{$staff->last_name_kana}} {{$staff->first_name_kana}}</small><small class="busho">部署：{{$staff->department}}</small><small class="busho">役職：{{$staff->position}}</small>
                    </dd>
                </dl>
                </a>
@endforeach
        </div>
        </div>
</section>



@endsection
