@extends('home.template')
@section('head')
@endsection

@section('content')

<section class="shop-map">
    <div class="shop-map__info">
        <div class="shop-map__text">
            横浜市栄区で昭和52年に創業以来、1組1組のお客様の「よりよい暮らし」をお手伝いしています。 地域各所に点在する三春情報センターのお店は、地元に密着した「暮らしの相談所」。 不動産仲介や注文住宅、リフォーム相談、保険の見直し、マンション管理などのサービスを行います。
        </div>
        <div class="shop-map__img">
            <img src="{{root('img/shop/shop-map.png')}}" alt="">
        </div>
    </div>
    <!--<iframe class="shop-map__iframe" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3252.463467416934!2d139.5782312508941!3d35.39376095319437!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x60185b325cca3545%3A0x8f0999e9e5a8ae88!2z44CSMjM0LTAwNTEg56We5aWI5bed55yM5qiq5rWc5biC5riv5Y2X5Yy65pel6YeO77yU5LiB55uu!5e0!3m2!1sja!2sjp!4v1555073235796!5m2!1sja!2sjp"
        width="600" height="300" frameborder="0" style="border:0" allowfullscreen></iframe>-->

</section>

<section class="shop-lists">
    
@foreach($shops as $key => $rows)
    <div class="wrapper shop-list-area" id="{{$key}}">
        <div class="shop-lists__area">
            {{$rows['area_name']}}
        </div>
        <div class="shop-lists__lists">
    @foreach($rows['shop'] as $row)
        @if($row->name_kana != "")
            <div class="shop-lists__list" style="margin-bottom:10px;">
                <a class="shop-lists__upper" href="/shop/{{$row->name_kana}}.html">
                    <div class="shop-lists__img">
                        @if(!empty($row->file_path))
                        <img src="{{$row->file_path}}" />
                        @else
                        <img src="{{root('img/noimage2.jpg')}}"  />
                        @endif
                    </div>
                    <div class="shop-lists__main">
                        <div class="shop-lists__name">{{$row->name}}
                        <span class="shop-lists__link">店舗詳細<i class="fas fa-chevron-right"></i></span>
                        </div>
                    <div class="shop-lists__details">
                        <dl class="shop-lists__detail">
                            <dt>住所</dt>
                            <dd>{{$row->pref_name}}{{$row->city_name}}{{$row->town_name}}{{$row->address4}}</dd>
                        </dl>
                        <dl class="shop-lists__detail">
                            <dt>営業時間</dt>
                            <dd>
                            {{$row->business_hours}}
                            </dd>
                        </dl>
                        <dl class="shop-lists__detail">
                            <dt>定休日</dt>
                            <dd>
                            {{$row->holiday}}
                            </dd>
                        </dl>
                    </div>
                </div>
                </a>
                <div class="shop-lists__contacts">
                    <span class="shop-lists__tel"><i class="fas fa-phone"></i>{{$row->freedial}}</span>
                    <a class="sp_tel" href="tel:{{$row->freedial}}"><i class="fas fa-phone"></i>{{$row->freedial}}</a>

                    <a href="/reserve/{{$row->code}}" class="shop-lists__mail"><i class="far fa-envelope"></i>来店予約</a>
                </div>
            </div>
        @endif
    @endforeach
        </div>
    </div>
@endforeach
</section>
@endsection
