@extends('home.template')
@section('head')
@endsection

@section('content')
<section class="staff-first">
    <div class="inner">
        <div class="staff-first__two">
            <div class="staff-first__image">
                @if(isset($staff->file_path)) <img src="{{$staff->file_path}}" alt=""> @endif
            </div>
            <div class="staff-first__info">
                <div class="staff-first__upper">
                    <div class="staff-first__kanji">
                        {{$staff->last_name}} {{$staff->first_name}}
                    </div>
                    <div class="staff-first__kana">
                        {{$staff->last_name_kana}} {{$staff->first_name_kana}}<br />{{$store->name}}
                    </div>
                </div>
                <div class="staff-first__lower">
                    <!--<dl class="staff-first__detail">
                        <dt>店舗</dt>
                        <dd>●●店</dd>
                    </dl>-->
                    <dl class="staff-first__detail">
                        <dt>誕生日</dt>
                        <dd>{{$staff->birth_month}}月{{$staff->birth_day}}日</dd>
                    </dl>
                    <dl class="staff-first__detail">
                        <dt>部署</dt>
                        <dd>{{$staff->department}}</dd>
                    </dl>
                    <dl class="staff-first__detail">
                        <dt>血液型</dt>
                        <dd>{{ $blood[$staff->blood_type] }}型</dd>
                    </dl>
                    <dl class="staff-first__detail">
                        <dt>役職</dt>
                        <dd>{{$staff->position}}</dd>
                    </dl>
                </div>
            </div>
        </div>

    </div>
</section>

<section class="staff-details">
    <div class="inner">
@foreach($customs as $item)
        <div class="staff-details__detail">
            <div class="staff-details__title">
                {{$item->name}}
            </div>
            <div class="staff-details__text">
            {!! nl2br(e($item->ans)) !!}
            </div>
            <!-- <div class="staff-details__img">
                <img src="{{root('img/staff/detail1.jpg')}}" alt="">
            </div> -->
        </div>
@endforeach

        <a href="/staff/contact/{{$staff->employee_number}}" class="recommend-overviews__link">
        この担当に問い合わせる<i class="fas fa-chevron-right"></i>
        </a>



    </div>
</section>
<!--<section class="staff-voice">
    @include('home.parts.list-voice')
</section>-->
@endsection
