@extends('home.template')
@section('head')
@endsection

@section('content')

<div class="staff-menu__text-sp">三春情報センターのスタッフ紹介です。<br />クリックで詳細をご覧いただけます。
</div>

<section class="staff-menu">
    <div class="wrapper">
        <div class="staff-menu__title">
            <i class="fas fa-search"></i>店舗から探す
        </div>
        <nav class="staff-menu__lists">
@foreach($shop_list as $key => $info)
    @php
        $num = $loop->iteration;
    @endphp
            <dl class="staff-menu__line">
                <dt>
                    {{$info['area_name']}}
                </dt>
                <dd>
                    @foreach($info['shops'] as $shop)
                    <a href="javascript:void(0);" class="staff-menu__list @if($num == 1 && $loop->iteration == 1) selected @endif" data-n="{{$shop->code}}">{{$shop->name}}</a>
                    @endforeach
                </dd>
            </dl>
@endforeach
        </nav>
    </div>
</section>

<section class="shop-staffs--grey">
    @foreach($staff_list as $key => $info)
    <div class="wrapper staff_list" @if($loop->iteration != 1) style="display:none;" @endif id="{{$info['shop']->code}}" >
        <h2 class="shop-staffs__area">
            {{$info['shop']->name}}
        </h2>
        <div class="shop-staffs__list">
        @foreach($info['staffs'] as $staff)
          <a href="staff/{{$staff->employee_number}}.html" class="shop-staffs__staff">
          <dl>
            <dt>
                @if(!empty($staff->file_path))
                    <img src="{{$staff->file_path}}" width="91"/>
                @else
                        <img src="{{root('img/noimage2.jpg')}}" width="91"/>
                @endif
            </dt>
                <dd>
                    <strong>{{$staff->last_name}} {{$staff->first_name}}</strong>
                    <small>{{$staff->last_name}} {{$staff->first_name}}</small>
                    <small class="busho">部署：{{$staff->department}}</small>
                    <small class="busho">役職：{{$staff->position}}</small>
                </dd>
          </dl>
          </a>
        @endforeach
        </div>
    </div>
    @endforeach
</section>

<script>
$(function(){
    $('.staff-menu__list').on('click', function(){
        var id = $(this).attr('data-n');

        var target = $('.staff-menu__list');
        $.each(target, function(key, value){
            $(value).removeClass('selected');
        });
        $(this).addClass('selected');

        var target = $('.staff_list');
        $.each(target, function(key, value){
            $(value).hide();
        });

        $('#'+id).show();



    });
});
</script>
@endsection
