@extends('home.template')
@section('head')
@endsection


@section('content')
<section class="topics-contents">
    <div class="wrapper">
        @foreach($topics as $row)
        <div class="topics-contents__one" id="{{$row->news_id}}">
            <dl class="topics-contents__info">
                <dt>
                  @if($new_target < $row->updated_at) <span class="new">NEW</span> @endif
                  <span class="topics-contents__openhouse">
                      @if($row->news_category == 1)
                      お知らせ 
                      @elseif($row->news_category == 2)
                      イベント 
                      @elseif($row->news_category == 3)
                      セミナー
                      @elseif($row->news_category == 4)
                      {{$row->news_category_text}}
                      @endif
                  </span>
                  <small class="date">{{$row->news_date}}</small>
                </dt>
                <dd>

                  <strong>{{$row->news_title}}</strong>

                </dd>

            </dl>

            <div class="topics-contents__inner">
                <div class="topics-contents__image">
                    @if(isset($row->disp_file_path) && $row->disp_file_path != "")
                    <img src="{{$row->disp_file_path}}" alt="">
                    @endif
                </div>
                <div class="topics-contents__overview">
                    {!! $row->news_link_target_text !!}
                </div>
                <a href="/contact" class="topics-contents__button">
                        お申し込みはこちら
                </a>
            </div>
        </div>
        @endforeach
    </div>
</section>
@endsection
