@extends('template')
@section('head')
@endsection

@section('content')
<div class="wrapper">
    <div class="two-column--area">
        <div class="two-column__side">
            @include('area/side')
        </div>
        <div class="two-column__main">
            <section class="area-main">
                <h2 class="area-main__title">
                    {{$staticFirst['jp']}}
                </h2>
                <div class="area-main__wrapper">
                    <div class="area-main__text">
                        {{$staticFirst['city']}}の不動産（中古マンション・新築一戸建て・中古一戸建て・土地）の購入、売却、地域情報のページです。<br>
                        購入については物件情報の検索、売却については価格査定の依頼が可能です。<br>
                        {{$staticFirst['city']}}の特徴や駅情報、学校区情報もぜひご覧ください。
                    </div>
                    <div class="area-main__images">
                        <img src="{{root('img/area/')}}{{$staticFirst['city_en']}}_c.jpg" alt="">
                    </div>
                    <div class="area-main__search">
                        {{$staticFirst['city']}}の不動産をさがす
                    </div>
                    <div class="area-main__links">
                        <a href="{{root('buy/')}}{{$staticFirst['city_en']}}" class="area-main__link">
                        <i class="far fa-building"></i><span>{{$staticFirst['city']}}のすべての物件(000)</span><i class="fas fa-chevron-right"></i>
                        </a>
                        <a href="{{root('buy/')}}{{$staticFirst['city_en']}}/mansion" class="area-main__link">
                        <i class="far fa-building"></i><span>{{$staticFirst['city']}}の中古マンション(000)</span><i class="fas fa-chevron-right"></i>
                        </a>
                        <a href="{{root('buy/')}}{{$staticFirst['city_en']}}/nhouse" class="area-main__link">
                        <i class="fas fa-home"></i><span>{{$staticFirst['city']}}の新築一戸建て(000)</span><i class="fas fa-chevron-right"></i>
                        </a>
                        <a href="{{root('buy/')}}{{$staticFirst['city_en']}}/uhouse" class="area-main__link">
                        <i class="fas fa-home"></i><span>{{$staticFirst['city']}}の中古一戸建て(000)</span><i class="fas fa-chevron-right"></i>
                        </a>
                        <a href="{{root('buy/')}}{{$staticFirst['city_en']}}/land" class="area-main__link">
                        <i class="fas fa-street-view"></i><span>{{$staticFirst['city']}}の土地(000)</span><i class="fas fa-chevron-right"></i>
                        </a>
                    </div>
                    <div class="area-main__search">
                        {{$staticFirst['city']}}の不動産を売却する
                    </div>
                    <div class="area-main__assessments">
                        <div class="area-main__assessment">
                            <div class="area-main__which">
                                簡易査定で調べる
                            </div>
                            <div class="area-main__paragraph">
                                ご自宅の概略をご入力いただくと<br>
                                おおよその価格がわかります。
                            </div>
                            <a href="{{root('sell/simple_mansion')}}" class="area-main__button">
                                <div class="area-main__left"><i class="far fa-building"></i>マンション</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="{{root('sell/simple_house')}}" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-home"></i>一戸建て</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="{{root('sell/simple_land')}}" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-street-view"></i>土地</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                        <div class="area-main__assessment">
                            <div class="area-main__which">
                                訪問査定で調べる
                            </div>
                            <div class="area-main__paragraph">
                              ご自宅を拝見し、価格査定書を<br />無料にて作成します。
                            </div>
                            <a href="{{root('sell/visit_mansion')}}" class="area-main__button">
                                <div class="area-main__left"><i class="far fa-building"></i>マンション</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="{{root('sell/visit_house')}}" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-home"></i>一戸建て</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="{{root('sell/visit_land')}}" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-street-view"></i>土地</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                    </div>

                </div>
                <div class="area-main__info">
                    <div class="area-main__info-title">
                        {{$staticFirst['city']}}の地域情報
                    </div>
                    <div class="area-main__info-text">
                        {{$staticFirst['comment']}}
                    </div>
                    <div class="area-main__info-images">
                        <img src="{{root('img/area/')}}{{$staticFirst['city_en']}}.png" alt="">
                        <img src="{{root('img/area/fam.png')}}" alt="">
                    </div>
                </div>

                <div class="area-main__wrapper">
                    <div class="area-main__details">
                        <div class="area-main__details-title">
                            <i class="fas fa-subway"></i>{{$staticFirst['city']}}の駅
                        </div>
                        <p class="area-main__details-paragraph">
                            {{$staticFirst['city']}}の駅や周辺の不動産の情報を詳しくご覧いただけます。
                        </p>
                        @for ($k = 0; $k < 2; $k++)
                        <div class="area-main__details-tag">
                            JR〇〇線
                        </div>
                        <hr class="area-main__details-line">
                        @for ($i = 0; $i < 2; $i++)
                        <div class="area-main__details-links">
                            @for ($j = 0; $j < 4; $j++)
                            <div class="area-main__details-link">
                                <a href="">
                                    <i class="fas fa-chevron-right"></i>産業振興センター駅
                                </a>
                            </div>
                            @endfor
                        </div>
                        @endfor
                        @endfor
                    </div>
                    <div class="area-main__details">
                            <div class="area-main__details-title">
                                <i class="fas fa-school"></i>{{$staticFirst['city']}}の小学校・中学校
                            </div>
                            <p class="area-main__details-paragraph">
                                {{$staticFirst['city']}}の小学校・中学校や周辺の不動産の情報を詳しくご覧いただけます。
                            </p>
                            <div class="area-main__details-tag">
                                小学校
                            </div>
                            <hr class="area-main__details-line">
                            @for ($i = 0; $i < 2; $i++)
                            <div class="area-main__details-links">
                                @for ($j = 0; $j < 4; $j++)
                                <div class="area-main__details-link">
                                    <a href="">
                                        <i class="fas fa-chevron-right"></i>●●●●小学校
                                    </a>
                                </div>
                                @endfor
                            </div>
                            @endfor
                             <div class="area-main__details-tag">
                                中学校
                            </div>
                            <hr class="area-main__details-line">
                            @for ($i = 0; $i < 2; $i++)
                            <div class="area-main__details-links">
                                @for ($j = 0; $j < 4; $j++)
                                <div class="area-main__details-link">
                                    <a href="">
                                        <i class="fas fa-chevron-right"></i>●●中学校
                                    </a>
                                </div>
                                @endfor
                            </div>
                            @endfor
                       </div>
                </div>

            </section>
<section class="area-new">
    <div class="area-new__title">
        横浜市〇〇区の新着物件情報
    </div>
    <div class="area-new__links">
        @for ($i = 0; $i < 3; $i++)
        <a href="" class="area-new__link">
            <div class="area-new__image">
                <figure>
                <img src="{{root('img/top/bukken.jpg')}}" alt="">
                <figcaption><i class="fas fa-chevron-right"></i></figcaption></figure>
                <div class="area-new__tag-mansion">
                    マンション
                </div>
            </div>
            <div class="area-new__infos">
            <div class="area-new__name">
                あたり。物件名。あたり。
            </div>
            <div class="area-new__price">
                    <i class="fas fa-yen-sign"></i><span>0,000</span>万円（税込）
            </div>
            <div class="area-new__info">
                    <i class="fas fa-map-marker-alt"></i>神奈川県横浜市南区
            </div>
            <div class="area-new__info">
                    <i class="fas fa-subway"></i>京急本線/弘明寺 徒歩22分
            </div>
        </div>
        </a>
        @endfor
    </div>
     <div class="area-new__links">
        @for ($i = 0; $i < 3; $i++)
        <a href="" class="area-new__link">
            <div class="area-new__image">
                <figure>
                <img src="{{root('img/top/bukken.jpg')}}" alt="">
                <figcaption><i class="fas fa-chevron-right"></i></figcaption></figure>
                <div class="area-new__tag-mansion">
                    マンション
                </div>
            </div>
            <div class="area-new__infos">
            <div class="area-new__name">
                あたり。物件名。あたり。
            </div>
            <div class="area-new__price">
                    <i class="fas fa-yen-sign"></i><span>0,000</span>万円（税込）
            </div>
            <div class="area-new__info">
                    <i class="fas fa-map-marker-alt"></i>神奈川県横浜市南区
            </div>
            <div class="area-new__info">
                    <i class="fas fa-subway"></i>京急本線/弘明寺 徒歩22分
            </div>
        </div>
        </a>
        @endfor
    </div>
    <a href="/buy/bukkenlist" class="reform-overviews__link">
                     横浜市〇〇区の物件一覧<i class="fas fa-chevron-right"></i>
                 </a>
</section>
            @include('area/shop')
            @include('area/info')
        </div>
    </div>
</div>
@include('area/footer')
@endsection
