@extends('template')
@section('head')
@endsection

@section('content')
<div class="wrapper">
    <div class="two-column--area">
        <div class="two-column__side">
            @include('area/side')
        </div>
        <div class="two-column__main">
            <section class="area-main">
                <h2 class="area-main__title">
                    横浜市港南区の不動産の売却と購入
                </h2>
                <div class="area-main__wrapper">
                    <div class="area-main__text">
                        横浜市港南区の不動産（中古マンション・新築一戸建て・中古一戸建て・土地）の購入、売却、地域情報のページです。<br>
                        購入については物件情報の検索、売却については価格査定の依頼が可能です。<br>
                        横浜市港南区の特徴や駅情報、学校区情報もぜひご覧ください。
                    </div>
                    <div class="area-main__images">
                        <img src="{{root('img/area/images.jpg')}}" alt="">
                    </div>
                    <div class="area-main__search">
                        横浜市港南区の不動産をさがす
                    </div>
                    <div class="area-main__links">
                        <a href="" class="area-main__link"><i
                                class="far fa-building"></i>横浜市港南区の中古マンション<span>(000)</span></a>
                        <a href="" class="area-main__link"><i class="fas fa-home"></i>横浜市港南区の新築一戸建て<span>(000)</span></a>
                        <a href="" class="area-main__link"><i class="fas fa-home"></i>横浜市港南区の中古一戸建て<span>(000)</span></a>
                        <a href="" class="area-main__link"><i
                                class="fas fa-street-view"></i>横浜市港南区の土地<span>(000)</span></a>
                    </div>
                    <div class="area-main__search">
                        横浜市港南区の不動産を売却する
                    </div>
                    <div class="area-main__assessments">
                        <div class="area-main__assessment">
                            <div class="area-main__which">
                                簡易査定で調べる
                            </div>
                            <div class="area-main__paragraph">
                                ご自宅の概略をご入力いただくと<br>
                                おおよその価格がわかります。
                            </div>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="far fa-building"></i>マンション</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-home"></i>一戸建て</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-street-view"></i>土地</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                        <div class="area-main__assessment">
                            <div class="area-main__which">
                                訪問査定で調べる
                            </div>
                            <div class="area-main__paragraph">
                              ご自宅を拝見し、価格査定書を<br />無料にて作成します。
                            </div>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="far fa-building"></i>マンション</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-home"></i>一戸建て</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                            <a href="" class="area-main__button">
                                <div class="area-main__left"><i class="fas fa-street-view"></i>土地</div><i
                                    class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                    </div>

                </div>
                <div class="area-main__info">
                    <div class="area-main__info-title">
                        横浜市港南区の地域情報
                    </div>
                    <div class="area-main__info-text">
                        大東市野崎1丁目1-12
                        にあるJR学研都市線『野崎』駅は、明治時代の1899年5月15日に開設された歴史ある駅です。駅周辺は、学校が集中していて、緑風冠高校、大阪産業大学、大阪産業大学短期大学部、大阪桐蔭中学校・高校、大阪府立野崎高校があります。学校周辺は塾も多くあります。駅は学生の利用が多いため、朝は電車の本数が増え、混雑します。駅から東へ向かって徒歩10分には、のざき観音、慈眼寺があります。5月には野崎祭りが開催され、個性的な屋台が並び、多くの観光客でにぎわいます。
                        大東市野崎1丁目1-12
                        にあるJR学研都市線『野崎』駅は、明治時代の1899年5月15日に開設された歴史ある駅です。駅周辺は、学校が集中していて、緑風冠高校、大阪産業大学、大阪産業大学短期大学部、大阪桐蔭中学校・高校、大阪府立野崎高校があります。学校周辺は塾も多くあります。駅は学生の利用が多いため、朝は電車の本数が増え、混雑します。
                    </div>
                    <div class="area-main__info-images">
                        <img src="{{root('img/area/minami.png')}}" alt="">
                        <img src="{{root('img/area/fam.png')}}" alt="">
                    </div>
                </div>
                <div class="area-main__wrapper">
                    <div class="area-main__details">
                        <div class="area-main__details-title">
                            <i class="fas fa-subway"></i>横浜市港南区の駅
                        </div>
                        <p class="area-main__details-paragraph">
                            横浜市港南区の駅や周辺の不動産の情報を詳しくご覧いただけます。
                        </p>
                        @for ($k = 0; $k < 2; $k++)
                        <div class="area-main__details-tag">
                            JR〇〇線
                        </div>
                        <hr class="area-main__details-line">
                        @for ($i = 0; $i < 2; $i++)
                        <div class="area-main__details-links">
                            @for ($j = 0; $j < 4; $j++)
                            <div class="area-main__details-link">
                                <a href="">
                                    <i class="fas fa-chevron-right"></i>産業振興センター駅
                                </a>
                            </div>
                            @endfor
                        </div>
                        @endfor
                        @endfor
                    </div>
                    <div class="area-main__details">
                            <div class="area-main__details-title">
                                <i class="fas fa-school"></i>横浜市港南区の小学校・中学校
                            </div>
                            <p class="area-main__details-paragraph">
                                横浜市港南区の小学校・中学校や周辺の不動産の情報を詳しくご覧いただけます。
                            </p>
                            <div class="area-main__details-tag">
                                小学校
                            </div>
                            <hr class="area-main__details-line">
                            @for ($i = 0; $i < 2; $i++)
                            <div class="area-main__details-links">
                                @for ($j = 0; $j < 4; $j++)
                                <div class="area-main__details-link">
                                    <a href="">
                                        <i class="fas fa-chevron-right"></i>●●●●小学校
                                    </a>
                                </div>
                                @endfor
                            </div>
                            @endfor
                             <div class="area-main__details-tag">
                                中学校
                            </div>
                            <hr class="area-main__details-line">
                            @for ($i = 0; $i < 2; $i++)
                            <div class="area-main__details-links">
                                @for ($j = 0; $j < 4; $j++)
                                <div class="area-main__details-link">
                                    <a href="">
                                        <i class="fas fa-chevron-right"></i>●●中学校
                                    </a>
                                </div>
                                @endfor
                            </div>
                            @endfor
                       </div>
                </div>
            </section>
            @include('area/new')
            @include('area/info')
        </div>
    </div>
</div>
@include('area/footer')
@endsection
