@extends('template')
@section('head')
@endsection

@section('content')
<section class="static-first--area">
    <div class="static-first__visual" style="background-image: url('/img/area/first.jpg')"></div>
    <div class="wrapper">
        <div class="static-first__info">
            <span class="static-first__title">AREA GUIDE</span>
            <h1 class="static-first__JP">横浜市エリアガイド</h1>
            <div class="static-first__line1"></div>
            <div class="static-first__line2"></div>
        </div>
        <div class="static-first__wrapper">
            <p class="static-first__text">横浜エリアの不動産の購入と売却、地域情報のページです。<br class="pc"> おすすめスポットや駅、学校の情報もご覧いただけます。</p>
        </div>
    </div>
</section>

<section class="area-info">
    <div class="wrapper">
        <div class="area-info__title">
            <img src="{{root('img/area/yokohamaareainfo.png')}}" alt="">
        </div>

<div class="area-info__tex-wrap">
        <div class="area-info__text">
          横浜市は、神奈川県の県庁所在地で、18区の行政区域を持つ政令指定都市の一つ。幕末、ペリーの黒船来航を機に開港した港湾都市で、当時大きな外国人居留地が創られ、様々な外国文化が根付いていきました。近世に創られたその港町は、外国から流れ込んだ異国情緒と共に、日本の急発展を象徴するかのようなモダンさ、一方でどこか和を残したような風情も感じられる、そんな街並みで溢れています。外国資本が多く流れ込んだ事もあり、現在では人口400万人、日本第二位の人口を誇る、日本有数の都市。東京へ通勤・通学する方々のベッドタウンであったり、海に臨む赤レンガ倉庫や外国人文化の象徴の一つでもある横浜中華街などを有する観光都市、日本三大工業地帯の一つでもある京浜工業地帯の中核を担う工業都市であるなど、
          近代の歴史の中で形作られた多様性の街となっています。
        </div>
        <img class="illust_pc" src="{{root('img/area/port.png')}}" alt="">
</div>

    </div>
</section>

<section class="area-search">
    <div class="wrapper">
        <div class="area-search__title">
            横浜エリアの不動産をさがす
        </div>
        <nav class="area-search__list">
            <a href="" class="area-search__link"><i class="far fa-building"></i>横浜の中古マンション（000）</a>
            <a href="" class="area-search__link"><i class="fas fa-home"></i>横浜の中古戸建（000）</a>
            <a href="" class="area-search__link"><i class="fas fa-home"></i>横浜の新築戸建（000）</a>
            <a href="" class="area-search__link"><i class="fas fa-street-view"></i>横浜の土地（000）</a>
        </nav>
    </div>
</section>

<section class="area-circles">
    <div class="wrapper">
        <div class="area-circles__title" style="color:#EDB35D;font-weight:bold;">
            横浜エリアの購入と売却と地域情報を見る
        </div>
        <div class="inner">
            <div class="area-circles__circles">

                <div class="area-circles__one">
                    <a href="area/konan">
                    <div class="area-circles__image">
                        <img src="{{root('img/area/konan.png')}}" alt="">
                    </div>
                    <div class="area-circles__wrap">
                    <div class="area-circles__name">
                        横浜市港南区
                    </div>
                    <div class="area-circles__text">
                        港南区は、横浜市の南部に位置している住宅街エリアです。
                    </div>
                  </div>
                    </a>
                </div>

                <div class="area-circles__one">
                  <a href="area/sakae">
                    <div class="area-circles__image">
                        <img src="{{root('img/area/sakae.png')}}" alt="">
                    </div>
                    <div class="area-circles__wrap">
                    <div class="area-circles__name">
                            横浜市栄区
                    </div>
                    <div class="area-circles__text">
                        栄区は美しい自然と古い歴史が融和するエリアです。
                    </div>
                  </div>
                  </a>
                </div>


                <div class="area-circles__one">
                  <a href="area/isogo">
                    <div class="area-circles__image">
                        <img src="{{root('img/area/isogo.png')}}" alt="">
                    </div>

                    <div class="area-circles__wrap">
                    <div class="area-circles__name">
                            横浜市磯子区
                    </div>
                    <div class="area-circles__text">
                        磯子区は、横浜市南東部、根岸湾に面しているエリアです。
                    </div>
                  </div>
                  </a>
                </div>

                <div class="area-circles__one">
                  <a href="area/kanazawa">
                    <div class="area-circles__image">
                        <img src="{{root('img/area/kanazawa.png')}}" alt="">
                    </div>
                    <div class="area-circles__wrap">
                    <div class="area-circles__name">
                            横浜市金沢区
                    </div>
                    <div class="area-circles__text">
                        金沢区は、鎌倉文化と美しい海岸線が特徴のエリアです。
                    </div>
                  </div>
                 </a>
                </div>

                <div class="area-circles__one">
                  <a href="area/minami">
                    <div class="area-circles__image">
                        <img src="{{root('img/area/minami.png')}}" alt="">
                    </div>
                    <div class="area-circles__wrap">
                    <div class="area-circles__name">
                            横浜市南区
                    </div>
                    <div class="area-circles__text">
                        南区は、大岡川の桜が有名な住宅街エリアです。
                    </div>
                  </div>
                 </a>
                </div>

            </div>
        </div>
        <img src="{{root('img/area/family.png')}}" alt="" class="area-circles__family">
        <img src="{{root('img/area/giraff.png')}}" alt="" class="area-circles__giraff">
    </div>
</section>

@include('area/footer')
@endsection
