@extends('template')
@section('content')

<div class="grey-back" id='buy'>
	<div class="wrapper">
		<h2 class="page-title">横浜市港南区の新築戸建を探す</h2>
		<div class="two-column">
			<section class="two-column__side">
				<div class="side-sp" onclick="toogleMenu();">検索条件の変更<i class="fas fa-chevron-down"></i></div>
				@include('buy/side-search')
			</section>
			<section class="two-column__main">
				@include('buy/list')

				<div class="notfaund">
					<strong>お探しの条件では物件が見つかりませんでした。</strong>
					<p>条件を変更して再検索していただくか、以下よりお問い合わせください。</p>
					<div class="notfaund-link">
						<a class="notfaund-link__search" href="/buy"><i class="fas fa-search"></i>条件を変更して再検索</a>
						<a class="notfaund-link__contact" href="#contact-box"><img class="mail"
								src="{{root('img/buy/icon_mail.png')}}">問い合わせをする</a>
					</div>
				</div>

				<div class="notfaund">
					<strong>お探しの物件はご成約済となっております。</strong>
					<p>条件を変更して再検索していただくか、以下よりお問い合わせください。</p>
					<div class="notfaund-link">
						<a class="notfaund-link__search" href="/buy"><i class="fas fa-search"></i>条件を変更して再検索</a>
						<a class="notfaund-link__contact" href="#contact-box"><img class="mail"
								src="{{root('img/buy/icon_mail.png')}}">問い合わせをする</a>
					</div>
				</div>

				<div class="no">
					<strong>ご希望の物件がなくても、あきらめないでください！</strong>
					<em>ホームページに掲載されていない物件情報があります！</em>
					<div class="no-in">
						<img class="no-illust" src="{{root('img/buy/no-illust.png')}}">
						<p>当社には、売主様の要望でホームページに掲載できない物件が多数ございます。
							希望条件を教えていただければ、担当者よりご希望にあった物件を
							紹介させていただきます。お気軽にお問い合わせくださいませ。</p>
					</div>
				</div>
			</section>
			<div class="contact" id="contact-box">
				<div class="static-first__info">
					<strong class="static-first__title">CONTACT</strong>
					<h1 class="static-first__JP">お問い合わせ</h1>
					<div class="static-first__line"></div>
				</div>
				<p class="static-first__text">下記の入力フォームに必要事項をご入力の上、送信ボタンをクリックしてください。
					<span>必須</span>マークの項目は必ずご入力をお願いします。 </p>
				<form id="form" action="/contact/sendmail" method="get" novalidate="novalidate">
					<div class="wrapper">
						<section class="contact-form">
							<div class="inner">
								<div class="error section-error" id="error" style="display:none">
									<dt>
										<strong><img src="../img/contact/warning.png">必須入力項目を確認してください</strong>
									</dt>
									<dd>必須項目に未入力項目があります。必須項目を入力してください。</dd>
									<div id="err_container">
										<ul></ul>
									</div>
								</div>
								<div class="contact-form__lists">
									<dl class="contact-form__list">
										<dt>
											お問い合わせ内容<em class="necessary">必須</em>
										</dt>
										<dd>
											<label class="contact-form__label-check-long">
												<input type="checkbox" name="inquiry[]">
												条件に合う物件を紹介してほしい
											</label>
											<label class="contact-form__label-check">
												<input type="checkbox" name="inquiry[]">
												その他（相談したい内容などを下記にご記入ください）
											</label>
											<textarea name="" id="" cols="30" rows="10"
												placeholder="例）家を買うときにかかる諸費用について知りたい。家を買うときに必要な手続きを教えてほしい。"></textarea>
										</dd>
									</dl>

									<dl class="contact-form__list">
										<dt>
											お名前<em class="necessary">必須</em>
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input class="text-necessary input-contact-textfield error" type="text" name="expected_sale_time"
													id="expected_sale_time" placeholder="お名前をご記入ください">
											</label>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											フリガナ
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input type="text" name="" id="" placeholder="フリガナをご記入ください">
											</label>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											メールアドレス<em class="necessary">必須</em>
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input class="text-necessary input-contact-textfield error" type="text" name="email" id="email"
													placeholder="メールアドレスをご記入ください">
											</label>
											<div class="contact-form__example">
												例）abc@sample.com（半角英数）
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											郵便番号
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input type="text" name="zip01" id="" placeholder="郵便番号をご記入ください" onkeyup="AjaxZip3.zip2addr(this,'','pref01','pref01');">
											</label>
											<div class="contact-form__example">
												例）1112222（ハイフン不要・半角数字）
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											都道府県名／<br>
											市町村郡
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input type="text" name="pref01" id="" placeholder="都道府県名／市町村郡をご記入ください">
											</label>
											<div class="contact-form__example">
												例）横浜市港南区日野
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											番地
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input type="text" name="addr01" id="" placeholder="番地名をご記入ください">
											</label>
											<div class="contact-form__example">
												例）8丁目8-11
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											建物名
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input type="text" name="" id="" placeholder="建物名をご記入ください">
											</label>
											<div class="contact-form__example">
												例）○△マンション202号室
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											お電話番号<em class="necessary">必須</em>
										</dt>
										<dd>
											<label class="contact-form__label-text">
												<input class="text-necessary input-contact-textfield error" type="text" name="phone" id="phone"
													placeholder="お電話番号をご記入ください">
											</label>
											<div class="contact-form__example">
												例）0458401161（ハイフン不要・半角数字）
											</div>
										</dd>
									</dl>
									<dl class="contact-form__list">
										<dt>
											過去に当社とお取引をして<br>いただいたことがありますか？
										</dt>
										<dd>
											<label class="contact-form__label-check">
												<input type="radio" name="torihiki" onchange="d_app.onShowChild(0)">
												なし
											</label>
											<label class="contact-form__label-check">
												<input type="radio" name="torihiki" onchange="d_app.onShowChild(1)">
												あり
											</label>
											<div class="child-radio">
												<label class="contact-form__label-check">
													<input type="checkbox">
													ご本人
												</label>
												<label class="contact-form__label-check">
													<input type="checkbox">
													ご家族・ご親戚
												</label>
												<label class="contact-form__label-check">
													<input type="checkbox">
													ご友人
												</label>
											</div>
										</dd>
									</dl>
								</div>
								<button type="submit" class="contact-form__agree">同意のうえ、送信する</button>
							</div>
						</section>
					</div>
				</form>
			</div>
			<!--contact-->
		</div>
	</div>

	{{--
    @include('parts/list-voice')
    @include('buy/footer')
--}}
</div>
<div class="notify-bottom notify-bottom-favorite alert alert-success">
	<!--<a href="#" class="close" data-dismiss="info" >&times;</a>-->
	<!--お気に入り登録が完了しました。お気に入りした物件は画面上部のお気に入りボタンからいつでも確認できます。-->
	お気に入り登録をしました。
</div>
<div class="notify-bottom notify-bottom-unfavorite alert alert-success">
	<!--<a href="#" class="close" data-dismiss="info" >&times;</a>-->
	お気に入り登録を解除しました。
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
<link rel="stylesheet"
	href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.4.1/css/bootstrap-theme.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.3.1/css/bootstrap-grid.min.css">
<script src="{{asset('js/ajaxzip3.js')}}"></script>
<style type="text/css">
	.list-links {
		margin: 10px 10px 0 5px;
	}

	@media screen and (max-width: 768px) and (max-device-width: 1024px) {
		.wrapper {
			width: auto;
			margin: 10px auto;
		}

		.header__form {
			border: 1px solid #616161;
			border-radius: 5px;
			padding: 10px 15px;
			display: inherit;
		}

		.header__input {
			width: 300px;
			border: none;
			line-height: 24px;
			padding-left: 5px;
		}

		.two-column__side {
			width: 30%;
			padding: 10px;
		}

		.two-column__main {
			width: 69%;
			padding: 10px;
		}

	}

	@media screen and (max-width: 480px) {
		.wrapper {
			width: auto;
			margin: 10px auto;
		}

		.header__form {
			;
			display: none;
		}

		two-column__side {
			width: 100%;
			padding: 5px;
		}

		.two-column__main {
			width: 100%;
		}

		.icons {
			margin-top: 10px;
		}

		.notfaund-link a {
			margin: 5px;
		}

		.notfaund-link__contact img {
			margin: 0px 10px 0 0;
		}

		.two-column__side {
			width: 100%;
		}

		.two-column__main {
			width: 100%;
		}
	}
</style>


@endsection