@extends('template')
@section('head')
<script src="{{root('js/ofi.min.js')}}"></script>
<script src="{{asset('js/buy/_system.js')}}"></script>
<script src="{{asset('js/buy/system.js')}}"></script>
<script src="{{asset('js/buy/map.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.js"></script>
<script>
  objectFitImages();
</script>
@endsection


{{--
    TODO:Modelで引っ張ってきたデータをJSONに変換してVueに渡す。
    シングルページで検索を行えるようにする。
    表示画像の変更は各物件で保持する。
    データベース接続は初回のみ。
    --}}
@section('content')

<section class="map">
  <div class="wrapper">
    <h1 class="page-title"><em>住まいを探す</em>
      <strong><img src="{{root('img/buy/icon_search.png')}}" alt="">市・区から探す</strong>
      <span>ご希望の区名・物件種別を一つお選びください。</span>
    </h1>



    <div id="MAP" class="MAP">
      <div class="MAP_BOX">
        <map name="IMGMAP" id="IMGMAP">
          <area href="" alt="南区" onmouseover="MAP.over(14105);" onmouseout="map_hover_item(0);" shape="poly" coords="163,101 190,121 228,114 251,144 264,98 310,91 299,42 211,47 171,69" />
          <area href="" alt="磯子区" onmouseover="MAP.over(14107);" onmouseout="map_hover_item(0);" shape="poly" coords="211,206 216,277 212,296 322,201 347,125 310,91 246,98 251,144 257,158 219,166 250,200" />
          <area href="" alt="金沢区" onmouseover="MAP.over(14108);" onmouseout="map_hover_item(0);" shape="poly" coords="212,296 260,420 388,323 376,190 322,201" />
          <area href="" alt="港南区" onmouseover="MAP.over(14111);" onmouseout="map_hover_item(0);" shape="poly" coords="118,214 216,277 211,206 250,200 219,166 257,158 251,144 228,144 190,121 163,101 119,116" />
          <area href="" alt="栄区" onmouseover="MAP.over(14115);" onmouseout="map_hover_item(0);" shape="poly" coords="22,271 201,356 212,296 216,277 135,246 118,214 63,209" />
        </map>
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="MOUSE OVER ACTION" usemap="#IMGMAP" />
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
        <img class="MAPLAYER" src="{{root('img/buy/0.png')}}" alt="" />
        <img src="{{root('img/buy/map1.png')}}" alt="地図" />
      </div>
      <!--MAP_BOX-->
      <style>
        a.town-link:hover {
          text-decoration: underline;
        }
      </style>
      <script type="text/javascript">
        function map_hover_group(id) {
          MAP.over(id);
          if (id != 0) {
            $('.town-link' + id).css('text-decoration', 'underline');
          } else {
            $('.town-link').css('text-decoration', 'none');
          }
        }

        function map_hover_item(id) {
          MAP.over(id);
          if (id == 0) {
            $('.town-link').css('text-decoration', 'none');
          } else {
            $('.town-link-' + id).css('text-decoration', 'none');
          }
        }
      </script>
      <style>
        .town .town-name dd p {
          font-size: 12px;
          font-style: normal;
          font-weight: normal;
          width: 100%;
          margin: 0;
        }

        .town .town-name dd p span {
          font-size: 12px;
          font-style: normal;
          font-weight: normal;
          width: 100%;
        }
      </style>
      <div class="map-search__right">
        <div class="town town-14111">
          <strong class="city_sp"><a href="">横浜市港南区の不動産（00）</a></strong>
          <dl class="town-name">
            <dt><img src="{{root('img/buy/mapicon-konan.png')}}" alt=""></dt>
            <dd>
              <a href="minato/" class="town-link town-link-14111" onmouseover="map_hover_group(14111);" onmouseout="map_hover_group(0);">
                <p>横浜市港南区の</p>
                <p>不動産（00）</p>
              </a>
            </dd>
          </dl>
          <div class="town-bukken">
            <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
            <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14111);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
          </div>
        </div>
        <!--town-->

        <div class="town town-14105">
          <strong class="city_sp"><a href="">横浜市南区の不動産（00）</a></strong>
          <dl class="town-name ">
            <dt><img src="{{root('img/buy/mapicon-minami.png')}}" alt=""></dt>
            <dd>
              <a href="minato/" class="town-link town-link-14105" onmouseover="map_hover_group(14105);" onmouseout="map_hover_group(0);">
                <p>横浜市南区の</p>
                <p>不動産（00）</p>
              </a>
            </dd>
          </dl>
          <div class="town-bukken">
            <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
            <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14105);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
          </div>
        </div>
        <!--town-->

        <div class="town  town-14107">
          <strong class="city_sp"><a href="">横浜市磯子区の不動産（00）</a></strong>
          <dl class="town-name">
            <dt><img src="{{root('img/buy/mapicon-isogo.png')}}" alt=""></dt>
            <dd>
              <a href="" class="town-link town-link-14107" onmouseover="map_hover_group(14107);" onmouseout="map_hover_group(0);">
                <p>横浜市磯子区の</p>
                <p>不動産（00）</p>
              </a>
            </dd>
          </dl>
          <div class="town-bukken">
            <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
            <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14107);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
          </div>
        </div>
        <!--town-->

        <div class="town  town-14108">
          <strong class="city_sp"><a href="">横浜市金沢区の不動産（00）</a></strong>
          <dl class="town-name">
            <dt><img src="{{root('img/buy/mapicon-kanazawa.png')}}" alt=""></dt>
            <dd><a href="" class="town-link town-link-14108" onmouseover="map_hover_group(14108);" onmouseout="map_hover_group(0);">
                <p>横浜市金沢区の</p>
                <p>不動産（00）</p>
              </a>
            </dd>
          </dl>
          <div class="town-bukken">
            <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
            <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14108);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
          </div>
        </div>
        <!--town-->

        <div class="town town-14115">
          <strong class="city_sp"><a href="">横浜市栄区の不動産（00）</a></strong>
          <dl class="town-name">
            <dt><img src="{{root('img/buy/mapicon-sakae.png')}}" alt=""></dt>
            <dd><a href="" class="town-link town-link-14115" onmouseover="map_hover_group(14115);" onmouseout="map_hover_group(0);">
                <p>横浜市栄区の</p>
                <p>不動産（00）</p>
              </a>
            </dd>
          </dl>
          <div class="town-bukken">
            <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古マンション（00）</a>
            <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 新築一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 中古一戸建て（00）</a>
            <a href="" onmouseover="map_hover_item(14115);" onmouseout="map_hover_item(0);"><i class="fas fa-chevron-right"></i> 土地（00）</a>
          </div>
        </div>
        <!--town-->

      </div>
      <!--map-search__right-->
    </div>
    <!--MAP-->



    <div class="key">
      <span><img src="{{root('img/buy/icon_search_white.png')}}" alt="">物件名・マンション名・住所のキーワードから探す</span>
      <form action="bukkenlist.php" name="FMfrm" method="get" onsubmit="return cbCheck();">
        <input class="INPUT" type="text" name="key" value="キーワードを入力してください" onfocus="if(this.value == this.defaultValue) { this.value = ''; }" onblur="if(this.value == '') { this.value = this.defaultValue; }" />
        <input class="SUBMIT" type="submit" value="検　索" />
      </form>
    </div>
    <!--KEY-->

</section>
<!--map-->


<div class="list-link">
  <ul class="list-search">
    <li>
      <a href="/buy/line">
        <figure><img src="{{root('img/buy/search-line.jpg')}}" alt="">
          <figcaption><i class="fas fa-chevron-right"></i></figcaption>
        </figure>
        <h2>
          <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">沿線・駅から探す</center>
        </h2>
      </a>
    </li>

    <li>
      <a href="/buy/school">
        <figure><img src="{{root('img/buy/search-school.jpg')}}" alt="">
          <figcaption><i class="fas fa-chevron-right"></i></figcaption>
        </figure>
        <h2>
          <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">学校区から探す</center>
        </h2>
      </a>
    </li>

    <li>
      <a href="#theme">
        <figure><img src="{{root('img/buy/search-favo.jpg')}}" alt="">
          <figcaption><i class="fas fa-chevron-right"></i></figcaption>
        </figure>
        <h2>
          <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">こだわりから探す</center>
        </h2>
      </a>
    </li>
  </ul>
</div>

<h2 class="h2-center" id="theme">
  <center><img src="{{root('img/buy/icon_search.png')}}" alt="">こだわりから探す</center>
</h2>
<p class="text-center">ご希望の条件をクリックしてください。</p>

<h3 class="h3-favo">横浜の不動産をこだわりから探す</h3>
<ul class="favo-list">
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-new.jpg')}}" alt="新着物件">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">新着物件</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-pricedown.jpg')}}" alt="プライスダウン">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">プライスダウン</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-openhouse.jpg')}}" alt="オープンハウス">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">オープンハウス</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-produce.jpg')}}" alt="自社プロデュース">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">自社プロデュース</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-flat.jpg')}}" alt="高低差なし">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">高低差なし</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-bus.jpg')}}" alt="バス停1分以内">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">バス停1分以内</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-walk.jpg')}}" alt="駅徒歩5分以内">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">駅徒歩5分以内</center>
      </h4>
    </a></li>

  <li><a href="">
      <figure><img src="{{root('img/buy/theme-school.jpg')}}" alt="小学校10分以内">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">小学校10分以内</center>
      </h4>
    </a></li>

</ul>

<h3 class="h3-favo">マンション条件検索</h3>
<ul class="favo-list">
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-pet.jpg')}}" alt="ペット飼育可">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">ペット飼育可</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-cost.jpg')}}" alt="管理費・修繕費2万円以下">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">管理費・修繕費2万円以下</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-ldk.jpg')}}" alt="LDK15帖以上">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">LDK15帖以上</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-elevator.jpg')}}" alt="エレベータ有">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">エレベータ有</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-mansionentry.jpg')}}" alt="即引き渡し可">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">即引き渡し可</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-reform.jpg')}}" alt="リフォーム・リノベーション">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">リフォーム・リノベーション</center>
      </h4>
    </a></li>
  <li> </li>
  <li><img class="favo-illust" src="{{root('img/buy/favo-illust.png')}}" alt="マンション条件検索"></li>
</ul>


<h3 class="h3-favo">一戸建て条件検索</h3>
<ul class="favo-list">
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-carspace.jpg')}}" alt="2台以上駐車可">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">2台以上駐車可</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-twostory.jpg')}}" alt="2階建">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">2階建</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-houseentry.jpg')}}" alt="即引き渡し可">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">即引き渡し可</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-reform.jpg')}}" alt="リフォーム・リノベーション">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">リフォーム・リノベーション</center>
      </h4>
    </a></li>
</ul>

<h3 class="h3-favo">土地条件検索</h3>
<ul class="favo-list">
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-joken.jpg')}}" alt="2台以上駐車可">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">建築条件なし</center>
      </h4>
    </a></li>
  <li><a href="">
      <figure><img src="{{root('img/buy/theme-corner.jpg')}}" alt="角地">
        <figcaption><i class="fas fa-chevron-right"></i></figcaption>
      </figure>
      <h4>
        <center><img src="{{root('img/buy/icon-search-gray.png')}}" alt="">角地</center>
      </h4>
    </a></li>
</ul>


<div class="yellow-back">
  <section class="area-circles">
    <div class="wrapper">
      <div class="area-circles__title">
        <h2>
          <center>横浜エリアの購入と売却と地域情報を見る</center>
        </h2>
      </div>
      <div class="inner">

        <div class="area-circles__circles">
          <a href="area/konan">
            <div class="area-circles__one">
              <div class="area-circles__image">
                <img src="{{root('img/area/konan.png')}}" alt="">
              </div>
              <div class="area-circles__name">
                横浜市港南区
              </div>
              <div class="area-circles__text">
                港南区は、横浜市の南部に位置している住宅街エリアです。
              </div>
          </a>
        </div>

        <div class="area-circles__one">
          <a href="area/sakae">
            <div class="area-circles__image">

              <img src="{{root('img/area/sakae.png')}}" alt="">
            </div>
            <div class="area-circles__name">
              横浜市栄区
            </div>
            <div class="area-circles__text">
              栄区は美しい自然と古い歴史が融和するエリアです。
            </div>
          </a>
        </div>
        <div class="area-circles__one">
          <a href="area/isogo">
            <div class="area-circles__image">
              <img src="{{root('img/area/isogo.png')}}" alt="">
            </div>
            <div class="area-circles__name">
              横浜市磯子区
            </div>
            <div class="area-circles__text">
              磯子区は、横浜市南東部、根岸湾に面しているエリアです。
            </div>
          </a>
        </div>
        <div class="area-circles__one">
          <a href="area/kanazawa">
            <div class="area-circles__image">
              <img src="{{root('img/area/kanazawa.png')}}" alt="">
            </div>
            <div class="area-circles__name">
              横浜市金沢区
            </div>
            <div class="area-circles__text">
              金沢区は、鎌倉文化と美しい海岸線が特徴のエリアです。
            </div>
          </a>
        </div>
        <div class="area-circles__one">
          <a href="area/minami">
            <div class="area-circles__image">
              <img src="{{root('img/area/minami.png')}}" alt="">
            </div>
            <div class="area-circles__name">
              横浜市南区
            </div>
            <div class="area-circles__text">
              南区は、大岡川の桜が有名な住宅街エリアです。
            </div>
          </a>
        </div>
        <img class="illust-sp" src="{{root('img/buy/familyillust-sp.png')}}" alt="">
      </div>
    </div>
    <img src="{{root('img/buy/top-family.png')}}" alt="" class="area-circles__family">
    <img src="{{root('img/buy/top-town.png')}}" alt="" class="area-circles__giraff">
</div>
</section>
</div>

<div class="grey-back">
  <strong class="recommend__title">RECOMMEND</strong>
  <h2>
    <center>三春情報センターのおすすめ物件</center>
  </h2>
  <p>
    <center class="recommend__center">三春情報センターのおすすめ物件をご紹介いたします。クリックで詳細をご覧いただけます。<center>
  </p>


  <section class="area-new">
    <div class="area-new__title">
      横浜市港南区の新着物件情報
    </div>

    <div class="recommend__list">
      @for ($i = 0; $i
      < 6; $i++) <a class="recommend__component" href="">

        <figure><img src="{{root('img/top/bukken.jpg')}}" alt="">
          <figcaption><i class="fas fa-chevron-right"></i></figcaption>
        </figure>
        <span class="tag-new">NEW</span>
        <div class="recommend__info">
          <div class="recommend__top">
            <div class="recommend__date">
              2019.0.0
            </div>
            <div class="recommend__tag">
              マンション
            </div>
          </div>
          <div class="recommend__name">
            物件名
          </div>
          <dl class="recommend__detail">
            <dt class="recommend__detail-pricedt"><i class="fas fa-yen-sign"></i></dt>
            <dd class="recommend__detail-pricedd"><strong>0,000</strong>万円</dd>
          </dl>
          <dl class="recommend__detail">
            <dt><i class="fas fa-map-marker-alt"></i></dt>
            <dd>あたりあたり</dd>
          </dl>
          <dl class="recommend__detail">
            <dt><i class="fas fa-subway"></i></dt>
            <dd>あたりあたり</dd>
          </dl>
          <div class="recommend__view">
            詳細をみる<i class="fas fa-chevron-right"></i>
          </div>

        </div>
        </a>
        @endfor
    </div>


    <a href="buy/bukkenlist" class="reform-overviews__link">
      おすすめ物件一覧を見る<i class="fas fa-chevron-right"></i>
    </a>


  </section>
</div>



@endsection