<section class="simple-navi">
    <nav class="simple-navi__upper">
        <a href="" class="simple-navi__area selected">港南区<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__area">栄区<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__area">磯子区<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__area">金沢区<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__area">南区<i class="fas fa-chevron-right"></i></a>
    </nav>
    <nav class="simple-navi__lower">
        <a href="" class="simple-navi__type selected">すべての物件<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__type">中古マンション<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__type">新築一戸建て<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__type">中古一戸建て<i class="fas fa-chevron-right"></i></a>
        <a href="" class="simple-navi__type">土地<i class="fas fa-chevron-right"></i></a>
    </nav>
</section>
 
<section class="simple-detail">
    <div class="simple-detail__text">
        <h4 class="simple-detail__title">横浜市港南区について</h4>
        <p class="simple-detail__paragraph">
            港南区は横浜市に位置する神戸市の9区の内の1区。南側が大阪湾、北側が六甲山系の山に挟まれた位置にあり、六甲山系を源流とする石屋川、都賀川などの清流が流れています。港南区内を3つのエリアに分けてご紹介すると、阪急神戸線以北エリアは南斜面地で坂道が多いですが、山が近く身近で自然が感じられる住環境。街の各所から市街地や大阪湾を見下ろすことが出来ます。JR東海道本線周辺エリアは地勢が比較的平坦。阪急、JR、阪神の3沿線が利用でき、生活施設が近隣に揃う暮らしやすい場所です。阪神本線以南エリアは、工場も増えますが、灘五郷と呼ばれる酒処。古い酒蔵も残っています。中央区と隣接する南西側は、神戸市の東部の新都心として開発された『HAT神戸』地区で、美術館などの公共施設、病院などがあり、海沿いは開放感のある公園が整備されています。
        </p>
    </div>
    <div class="simple-detail__lower">
        <div class="simple-detail__conditions">
            <dl class="simple-detail__condition">
                <dt>エリア</dt>
                <dd>横浜市港南区</dd>
            </dl>
            <dl class="simple-detail__condition">
                <dt>物件種別</dt>
                <dd>新築戸建</dd>
            </dl>
        </div>
		<script type="text/javascript">
			var clicked =false;
			function download(){
				$('#btnDownload').css('color', 'grey');
			}
			$("#btnDownload").click(function(event){
				event.preventDefault();
				$(this).css('color', '#123123')
				
			});
		</script>
		<style>
			.simple-detail__save:hover {
				text-decoration: overline;
			}
			.icons__icon div:hover {
			  text-decoration: none;
			}
		</style>
		
		<a href="javascript:download(this);" class="simple-detail__save" id="btnDownload" >
            <i class="fas fa-download"></i>現在の検索条件を保存する
        </a>
       
		
    </div>
</section>

<section class="list-option">
	@php 
		$grid_url = url("buy/bukkenlist");
	@endphp
    <div class="list-option__style" id="grid">
        <div class="list-option__radio selected"><i class="fas fa-camera"></i>写真<span>表示</span></div>
        <div class="list-option__radio" onclick="location.href='{{$grid_url}}'"><i class="fas fa-list"></i>リスト<span>表示</span></div>
    </div>
    <dl class="list-option__sort">
        <dt>並べ替え</dt>
        <dd>
            <select name="" id="" class="list-option__select">
                <option value="">おすすめ順</option>
                <option value="">新着順</option>
                <option value="">駅近い順</option>
                <option value="">坂道レベル 平坦順</option>
                <option value="">坂道レベル 急坂順</option>
                <option value="">価格 安い順</option>
                <option value="">価格 高い順</option>
                <option value="">築年数 古い順</option>
                <option value="">築年数 新しい順</option>
                <option value="">土地面積 狭い順</option>
                <option value="">土地面積 広い順</option>
                <option value="">延床面積 狭い順</option>
                <option value="">延床面積 広い順</option>
                <option value="">リフォーム済</option>
            </select>
        </dd>
    </dl>
</section>

<section class="pagenation">
    <div class="pagenation__count">
        該当物件数：<span>43</span>件
    </div>
    <dl class="pagenation__pages">
        <dt>1-30/00件</dt>
        <dd>
            <a href="">1</a>
            <a href="">2</a>
            <a href=""><i class="fas fa-chevron-right"></i></a>
        </dd>
    </dl>
</section>

<section class="list-links" id="listItem">
	@for ($i = 0; $i < 4; $i++)
    <div class="list-links__box" name="物件{{$i+1}}" >
		<div class="row" style="padding:10px">
			<div class="col-lg-8 col-md-8 col-xs-8">
				<h3>物件1</h3>
				<div class="row" style="padding:0 10px">
					<section class="tags">
						<div class="tags__tag-new">NEW</div> <!----> 
						<div class="tags__tag-nhouse">新築一戸建て</div> <!----> <!---->
					</section>
				</div>
			</div>
			<div class="col-lg-4 col-md-4">
				<section class="icons"><a href="" class="icons__icon"><i class="far fa-heart pink"></i> <div>お気に入り</div></a> <a href="" class="icons__icon"><i class="far fa-calendar-alt"></i> <div>見学予約</div></a> <a href="" class="icons__icon"><i class="far fa-envelope"></i> <div>お問い合わせ</div></a></section>
			</div>
		</div>
		</hr>
		<div class="row" style="border-top: 1px solid #000;border-bottom: 1px solid #000;margin:10px">
			<div class="list-links__copy" style="text-align:left;margin-left:10px;margin-bottom: 10px;">■各居室収納付きのゆとりある５ＬＤＫの間取り！ ■前道幅員１２ｍあり広々しています</div>
		</div>
		</hr>
		<div class="row">
			<div class="col-lg-6 col-md-6 img-with-button">
				<img src="/img/property/photo1.jpg" alt="物件1" class="list-links__img" style="width:100%; height:100%">
				

				<!-- Rounded switch -->
				<label class="switch">
				  <input type="checkbox" checked>
				  <span class="slider round"></span>
				</label>
			</div>
			
			<div class="col-lg-6 col-md-6">
				<a href="1" class="list-links__detail_new fontsize14">
					<dl class="list-links__data">
						<dt><i class="fas fa-yen-sign"></i>物件価格
						</dt> 
						<dd class="new" ><span>3,280</span>万円
						</dd>
					</dl> 
					<dl class="list-links__data">
						<dt><i class="fas fa-map-marker-alt"></i>所在地
						</dt>
						<dd class="new" >神奈川県横浜市南区</dd>
					</dl> 
					<dl class="list-links__data">
						<dt><i class="fas fa-subway"></i>交通
						</dt> 
						<dd class="new" >
						ブルーライン「上永谷」 徒歩22分
						
						</dd>
					</dl> 
					
					<dl class="list-links__data">
						<dt>土地面積</dt> 
						<dd class="new" >100㎡</dd>
					</dl> 
					<dl class="list-links__data">
						<dt>建物面積</dt> 
						<dd class="new" >60㎡</dd>
					</dl> 
					<dl class="list-links__data">
						<dt>間取り</dt> 
						<dd class="new" >4LDK</dd>
					</dl> 
					<dl class="list-links__data">
						<dt>築年月</dt> 
						<dd class="new" >1994年5月築</dd>
					</dl> <!----> <!---->
				</a>
				<div class="row">
					<div class="col-lg-6 col-md-6 col-xs-6">
						<div class="list-links__pictures" style="font-size:15px;padding-left:10px">
							<i class="fas fa-camera"></i>29枚
						</div> 
					</div>
					<div class="col-lg-6 col-md-6 col-xs-6">
						<div class="float-right" style="float:right; padding-right:10px">
						  詳細を見る
						  <i class="fas fa-chevron-right"></i>
						</div>
					</div>
				</div>
			</div>
		
	</div>
	@endfor
<style>


.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #E89F32;
}

input:focus + .slider {
  box-shadow: 0 0 1px #E89F32;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}


.img-with-button {
  position: relative;
  width: 50%;
}

/* Make the image responsive */
.img-with-button img {
  width: 100%;
  height: auto;
}

.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}

/* Style the button and place it in the middle of the container/image */
.img-with-button.switch {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  background-color: #555;
  color: white;
  font-size: 16px;
  padding: 12px 24px;
  border: none;
  cursor: pointer;
  border-radius: 5px;
}

.img-with-button.switch:hover {
  background-color: black;
}
</style>
</section>


