@extends('template')
@section('head')
@endsection

@section('content')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script src="{{asset('/js/loan.js')}}"></script>

<div id="buy">
<div class="wrapper">

<div class="wrapper__box">
<h1 class="wrapper__box-h1">この物件でローンシミュレーションをする</h1>
<p class="wrapper__box-text">この物件を購入した場合の、月々の支払い価格の一例です。</p>

<div class="contact-form__lists">
<form method="POST" name="CALC">
	<dl class="contact-form__list">
		<dt>返済期間</dt>
		<dd class="INPUT">
			<div  class="price">
			<label>
				<select name="kikan">
				<option value="10">10年</option>
				<option value="15">15年</option>
				<option value="20">20年</option>
				<option value="25">25年</option>
				<option value="30">30年</option>
				<option value="35" selected>35年</option>
				</select>
			</label>
			</div><!--price-->
		</dd>
	</dl>

	<dl class="contact-form__list">
		<dt>金利</dt>
		<dd >
			<span class="tani">0.6%</span>
			<input type="hidden" value="0.6" name="rate">
		</dd>
	</dl>

<dl class="contact-form__list">
	<dt>ボーナス返済の割合</dt>
	<dd>
	<div  class="price">
		<label>
			<select id="bonus" name="bonus" size="1">
				<option value="1">50%</option>
				<option value="2">40%</option>
				<option value="3">30%</option>
				<option value="4">20%</option>
				<option value="5">10%</option>
				<option value="6" selected>0%</option>
			</select>
		</label>
	</div><!--price-->
	</dd>
</dl>
</dl>

<dl class="contact-form__list">
	<dt>物件価格</dt>
	<dd>
		<span class="contact-form__list-price">{{$price}}万円</span>
	</dd>
</dl>

<dl class="contact-form__list">
	<dt>自己資金</dt>
	<dd>
		<input type="number" id="own" name="own" value="0"  /><span class="tani">万円</span>
	</dd>
</dl>

<dl class="contact-form__list">
	<dt>借入金額</dt>
	<dd>
		<input type="text" id="loan" name="loan" value="{{$price}}" disabled /><span class="tani">万円</span>
	</dd>
</dl>

<script type="text/javascript">
$('#own').keyup(function(){
	var own = parseInt($(this).val()!=""?$(this).val():"0");

	var price = parseInt({{$price}});
	if (price > own){
		$('#loan').val(price - own);
	}
	else {
		$('#loan').val(0);
	}
});

</script>

	<input class="calk" name="button" type="button" onClick="calc(this.form)" value="シミュレーションする">

	<span class="arrow"></span>

<div class="hensai">
	<dl class="input_r">
		<dt>毎月の返済額</dt>
		<dd class="input">
			<input class="text1" type="text" name="tuki1" value=""><span>万</span>
			<input class="text2" type="text" name="tuki2" value=""><span>円</span>
		</dd>
	</dl>
	<dl class="input_r">
		<dt>ボーナス月の返済額</dt>
		<dd class="input">
			<input class="text1" type="text" name="bonus1"><span>万</span>
			<input class="text2" type="text" name="bonus2"><span>円</span>
		</dd>
	</dl>

	<input type="hidden" name="nen1" size="6" maxlength="6">
	<input type="hidden" name="nen2" size="6" maxlength="6">
</div>


<ul class="arrart">
	<li>●実際の返済額とは諸条件によって異なります。目安としてご利用ください。</li>
	<li>●金利は返済期間を通して変わらないものとし、元利均等方式（元金と利息を合計した、毎月の返済額が同じになる）で計算しました。</li>
	<li>●ボーナス返済については、借入日とボーナス月の間隔によって、計算の結果が少し異なります。</li>
</ul>
</form>

</div>
</div><!--#wrapper__box-->



</div><!--#wrapper-->
</div><!--#buy-->
@endsection
