@extends('template')
@section('head')
@endsection

@section('content')

<section class="favorite-first">
	<div class="wrapper">
		<div class="favorite-first__explain">
			物件情報ページにある「お気に入り」ボタンをクリックすると、「お気に入り」に登録できます。<br> 登録した物件は「お気に入り」ページでいつでもご確認いただけますので、ぜひご利用ください。
			<br> <small>※お気に入りリストの登録にはCookieとJavascriptを使用しています。これらの機能をONにしてください。</small>
		</div>
		<div class="favorite-first__title">
			<i class="fas fa-search"></i>物件種別から探す
		</div>
		<nav class="favorite-first__lists">
			<a href="javascript:filter(0, 'すべての物件')" class="favorite-first__list menu-0 selected">すべての物件（<span id="number-0">0</span>件）</a>
			<a href="javascript:filter(4, '中古マンション')" class="favorite-first__list menu-4">中古マンション（<span id="number-4">0</span>件）</a>
			<a href="javascript:filter(3,'新築一戸建て')" class="favorite-first__list menu-3">新築一戸建て（<span id="number-3">0</span>件）</a>
			<a href="javascript:filter(2, '中古一戸建て')" class="favorite-first__list menu-2">中古一戸建て（<span id="number-2">0</span>件）</a>
			<a href="javascript:filter(1, '土地')" class="favorite-first__list menu-1">土地（<span id="number-1">0</span>件）</a>
		</nav>
	</div>
</section>

<section class="favorite-list">
	<div class="inner">
		<div class="favorite-list__number">
			すべての物件<span id="total">0</span>件
		</div>
		<div class="favorite-list__buttons">
			<a href="#" class="favorite-list__check-button" id="chkall">
				<i class="far fa-check-square"></i>すべてをチェック
			</a>
			<a href="/buy/contact" class="favorite-list__whole-button">チェックした物件をまとめてお問い合わせ</a>
		</div>
		<div class="favorite-list__items">

		</div>
	</div>

	</div>
</section>
<style type="text/css">
	@media screen and (max-width: 768px) {
		.wrapper {
			width: auto;
		}

		.header__link-wrapper .header__link {
			margin: 0 25px 0 0;
		}

		.inner {
			width: auto;
		}

		.header__form .header__input {
			width: 200px;
		}

		.inner .favorite-list__buttons {
			display: flex;
		}

		.header__button i {
			margin-bottom: 10px;
		}
	}

	.favorite-first__list span {
		color: #EDB35D;
		font-size: 13px;
	}

	.favorite-first__list.selected span {
		background-color: #EDB35D;
		color: white;
	}

	.favorite-first__list:hover span {
		background-color: #EDB35D;
		color: white;
	}
</style>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

<script type="text/javascript">
	var checkedall = false;
	// Handler for .ready() called.
	var i;

	$("#chkall").click(function(event) {
		event.preventDefault();
		if (checkedall == false) {
			$('input[type=checkbox]').prop('checked', true);
			checkedall = true;
		} else {
			$('input[type=checkbox]').prop('checked', false);
			checkedall = false;
		}
	});

	function filter(type, type_name) {

		$('.favorite-first__list').removeClass('selected');
		if (type == 1) {
			$('.list-links__box').hide();
			$(".type-1").show();
			$('.favorite-first__list').removeClass('selected');
			$(".menu-1").addClass("selected");
		}
		if (type == 2) {
			$('.list-links__box').hide();
			$(".type-2").show();
			$('.favorite-first__list').removeClass('selected');
			$(".menu-2").addClass("selected");
		}
		if (type == 3) {
			$('.list-links__box').hide();
			$(".type-3").show();
			$('favorite-first__list').removeClass('selected');
			$(".menu-3").addClass("selected");
		}
		if (type == 4) {
			$('.list-links__box').hide();
			$(".type-4").show();
			$('.favorite-first__list').removeClass('selected');
			$(".menu-4").addClass("selected");
		}
		if (type == 0) {
			$('.list-links__box').show();
			$('.favorite-first__list').removeClass('selected');

			$(".menu-0").addClass("selected");
		}



		countType(type);

		let total = $('.list-links__box:visible').length;
		if (type > 0) $('.type-' + type).length;
		$(".favorite-list__number").contents().first()[0].textContent = type_name;
		$("#total").html(total);
	}

	function countType(type) {
		let total = 0;
		if (type > 0) {
			total = $('.type-' + type).length;

			$("#number-" + type).html(total);
		}
		total = $('.list-links__box').length;
		$("#number-0").html(total);
		$("#total").html(total);


	}

	$(".fa-heart").on('click', function(event) {

		$(this).closest('div[class^="list-links__box"]').remove();
		countType(1);
		countType(2);
		countType(3);
		countType(4);
		//countType(0);

		let total = $('.list-links__box:visible').length; //0$('.').length;:visible
		$("#total").html(total);

	});
</script>
@endsection