@extends('template')
@section('head')
@endsection

@section('content')
<section class="reform-detail">
    <div class="wrapper">
        <div class="reform-detail__image">

            <img src="{{root('img/reform/example1.jpg')}}" alt="">
        </div>
        <div class="static-first__info">
            <h2 class="static-first__title">FILE<span>01</span></h2>
            <p class="static-first__JP">愛猫と暮らす家</p>
            <div class="static-first__line"></div>
        </div>
    </div>
</section>
<section class="reform-details">
    <div class="reform-details__one">
        <div class="reform-details__title">
            Data
        </div>
        <div class="reform-details__lists">
            <dl class="reform-details__list">
                <dt>物件種別</dt>
                <dd>マンション</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>築年</dt>
                <dd>45年</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>エリア</dt>
                <dd>横浜市中区</dd>
            </dl>
            <dl class="reform-details__list">
                <dt>リフォーム費用</dt>
                <dd>0,000万円</dd>
            </dl>
            <dl class="reform-details__list__long">
                <dt>施工箇所</dt>
                <dd>LDK/廊下/玄関/洗面/トイレ</dd>
            </dl>
        </div>
    </div>
    <div class="reform-details__one">
        <div class="reform-details__title">
            Gallery
        </div>

        <!--スライド-->
        <div id="slider" class="swiper-container">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test1.jpg')}}" alt="">
                    </div>
                    <span class="caption">素材感あふれるインダストリアルな空間になりました。</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test2.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション2</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test3.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション3</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test4.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション4</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test5.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション5</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test1.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション6</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test2.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション7</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test3.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション8</span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test4.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション9 </span>
                </div>
                <div class="swiper-slide">
                    <div class="swiper-img-wrap">
                        <img src="{{root('img/reform/example/test5.jpg')}}" alt="">
                    </div>
                    <span class="caption">キャプション10 </span>
                </div>
            </div>
            <div class="swiper-button-prev swiper-button-white"></div>
            <div class="swiper-button-next swiper-button-white"></div>
        </div>

        <div id="thumbs" class="swiper-container mb60">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test1.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test2.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test3.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test4.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test5.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test1.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test2.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test3.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test4.jpg')}}" alt="">
                </div>
                <div class="swiper-slide">
                    <img src="{{root('img/reform/example/test5.jpg')}}" alt="">
                </div>
            </div>
        </div>

    </div>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/css/swiper.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/js/swiper.min.js"></script>
    <script>
        var galleryThumbs = new Swiper('#thumbs', {
            spaceBetween: 10,
			slidesPerView: 8,
			loop: true,
			freeMode: true,
			loopedSlides: 5, //looped slides should be the same
			watchSlidesVisibility: true,
			watchSlidesProgress: true,
			slideToClickedSlide: true,
			touchRatio: 0.2,
			autoplay: 2000,
			speed: 200
        });
        var galleryTop = new Swiper('#slider', {
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 5000,
            },
            loopedSlides: 5, //looped slides should be the same
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            thumbs: {
                swiper: galleryThumbs,
            },
        });
        // var slider = new Swiper('#slider', {
        //     nextButton: '.swiper-button-next',
        //     prevButton: '.swiper-button-prev'
        // })
        // var thumbs = new Swiper('#thumbs', {
        //     centeredSlides: false,
        //     spaceBetween: 10,
        //     slidesPerView: "auto",
        //     touchRatio: 0.2,
        //     slideToClickedSlide: true,
        //     autoplay: 2000,
        //     speed: 200,
        //     on: {
        //         init: function() {
        //             console.log('swiper initialized');
        //         },
        //         slideChange: function() {
        //             var swiper = this;
        //             for (var i = 0; i < swiper.slides.length; i++) {
        //                 var slideProgress = swiper.slides[i].progress;
        //                 var innerOffset = swiper.width * interleaveOffset;
        //                 var innerTranslate = slideProgress * innerOffset;
        //                 swiper.slides[i].querySelector(".slide-inner").style.transform =
        //                     "translate3d(" + 0 + "px, 0, 0)";
        //             }
        //         },
        //     }
        // });

        // slider.params.control = thumbs;
        // thumbs.params.control = slider;
    </script>

    <!--スライド-->

    </div>

    <div class="reform-details__one">

        <div class="reform-details__bfaf">
            <div class="reform-details__bfaf-photos">
                <div class="reform-details__before">
                    <div class="reform-details__mini-title">
                        Before図面
                    </div>
                    <div class="zumen-wrap">

                        <img src="{{root('img/reform/example/zumen1.jpg')}}" alt="">
                    </div>
                </div>
                <div class="reform-details__arrow">
                    <span class="arrow"></span>
                </div>
                <div class="reform-details__after">
                    <div class="reform-details__mini-title">
                        After図面
                    </div>
                    <div class="zumen-wrap">

                        <img src="{{root('img/reform/example/zumen2.jpg')}}" alt="">
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="reform-details__one">
        <div class="reform-details__title">
            プランの特徴
        </div>
        <p class="reform-details__paragraph">
            家のどこにいても猫を感じられるような暮らしを。建具にペット用扉を起用し、キャットウォークを造作しました。 キッチンも対面にし、家
            族でコミュニケーションがより活発に取れるようになります。 浴室も広げ、１６２０という大きなサイズのUBを設置、トイレの位置も変更
            しました。 東京周辺で賃貸マンションをお探しなら、巣鴨は大変お勧めです。巣鴨駅はJR山手線と三田線が利用できるため、東京の主要地域におおよそ30分程度で着くことが出来ます。また、新宿や池袋にいたっては、15分以内に着きます。地方から東京に来る方であれば、まだまだ生活に慣れないことも多いと思うので、なるべくなら、乗り換えが少なくすむ山手線沿線に住むのがおすすめです。
            さらに、巣鴨の賃貸マンションは比較的に安く、且つ治安も良い場所です。家賃が安いと治安も悪いのではというイメージがもたれがちですが、巣鴨ではそのようなことはありませんので、女性には特におすすめです。また、巣鴨周辺は立地条件がよいのも特徴です。JR巣鴨駅の近くは非常に栄えていますので、スーパーやコンビニも多くあり、深夜の買い物にも困りません。また居酒屋や飲食店も多く、暮らしに便利です。駅には駐輪場も設置されており、巣鴨の隣駅の西巣鴨の賃貸マンションに住んでいても、自転車で5分程度で巣鴨駅に着きます。但し、1つだけ注意したい点は巣鴨の賃貸マンションは古い物件が多いので、借りる際には必ず、建てられた年数や、建物の材質などは良くチェックしておいたほうがよいでしょう。(511文字）
        </p>
    </div>

    <div class="reform-details__wrapper">
        <div class="reform-details__one">
            <div class="reform-details__title">
                施工のポイント
            </div>
            <p class="reform-details__paragraph">
                家のどこにいても猫を感じられるような暮らしを。建具にペット用扉を起用し、キャットウォークを造作しました。 キッチンも対面にし、家
                族でコミュニケーションがより活発に取れるようになります。 浴室も広げ、１６２０という大きなサイズのUBを設置、トイレの位置も変更
                しました。 東京周辺で賃貸マンションをお探しなら、巣鴨は大変お勧めです。巣鴨駅はJR山手線と三田線が利用できるため、東京の主要地域におおよそ30分程度で着くことが出来ます。また、新宿や池袋にいたっては、15分以内に着きます。地方から東京に来る方であれば、まだまだ生活に慣れないことも多いと思うので、なるべくなら、乗り換えが少なくすむ山手線沿線に住むのがおすすめです。
                さらに、巣鴨の賃貸マンションは比較的に安く、且つ治安も良い場所です。家賃が安いと治安も悪いのではというイメージがもたれがちですが、巣鴨ではそのようなことはありませんので、女性には特におすすめです。また、巣鴨周辺は立地条件がよいのも特徴です。JR巣鴨駅の近くは非常に栄えていますので、スーパーやコンビニも多くあり、深夜の買い物にも困りません。また居酒屋や飲食店も多く、暮らしに便利です。駅には駐輪場も設置されており、巣鴨の隣駅の西巣鴨の賃貸マンションに住んでいても、自転車で5分程度で巣鴨駅に着きます。但し、1つだけ注意したい点は巣鴨の賃貸マンションは古い物件が多いので、借りる際には必ず、建てられた年数や、建物の材質などは良くチェックしておいたほうがよいでしょう。(511文字）
            </p>
        </div>
    </div>


    <div class="wrapper">
        <div class="reform-details__links">
            <a href="" class="reform-details__link"><i class="fas fa-chevron-left"></i>前の事例を見る</a>
            <a href="../example" class="reform-details__link">施工事例一覧に戻る</a>
            <a href="" class="reform-details__link">次の事例を見る<i class="fas fa-chevron-right"></i></a>
        </div>
    </div>
</section>

<section class="reform-detail-contact">

    <div class="wrapper">

        <div class="reform-detail-contact__title">
            CONTACT
        </div>
        <div class="reform-detail-contact__jp">
            お気軽にご相談くださいませ。
        </div>
        <p class="reform-detail-contact__paragraph">
            中古物件＋リフォームに関するお問い合わせや<br class="br_sp">ご相談など、お気軽にご連絡ください。
        </p>
        <div class="reform-detail-contact__rooms">
            <div class="reform-detail-contact__room">
                <div class="reform-detail-contact__image">
                    <img class="pc" src="{{root('img/reform/room1.jpg')}}" alt="">
                    <img class="sp" src="{{root('img/reform/main.jpg')}}" alt="">
                </div>
                <div class="reform-detail-contact__info">
                    <div class="reform-detail-contact__name">
                        磯子ショールーム
                    </div>
                    <div class="reform-detail-contact__text">
                        理想の住まい創りのアイディアが詰め込まれた2LDK（約70 ㎡）のタイプのショールームをご覧いただけます。
                    </div>
                    <div class="reform-detail-contact__contact">
                        <span class="reform-detail-contact__tel"><i class="fas fa-phone"></i>0120-33-8730</span>

                        <a class="sp_tel" href="tel:0120-33-8730"><i class="fas fa-phone"></i>0120-33-8730</a>


                        <a href="/reform/reserve" class="reform-detail-contact__mail"><i class="far fa-envelope"></i>来場予約</a>
                    </div>
                </div>
            </div>



            <div class="reform-detail-contact__room">
                <div class="panf">
                    <img src="{{root('img/reform/panf.png')}}" alt=""></div>
            </div>



        </div>
    </div>
</section>
@endsection