@extends('template')
@section('head')
@endsection

@section('content')
<div class="wrapper">
    <div class="steps">
            <div class="steps__step">
            <div class="steps__number"><div class="steps__inner">STEP<br><span>01</span></div>
            </div>
            <div class="steps__text">
                <h2 class="steps__title">ご相談</h2>
                <p class="steps__paragraph">
                  お住まいの売却には、相場情報や法律、税金等わかりにくい点が多く、不安がつきものです。
                  経験豊富な担当者がお住まい全般にわたりご相談に応じます。
                  また、不動産売却の際の流れや諸費用等についてもご説明いたします。
                </p>
            </div>
        </div>

        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

            <div class="steps__step">
            <div class="steps__number">
                <div class="steps__inner">
                STEP<br><span>02</span>
                </div>
            </div>
            <div class="steps__text">
                <h2 class="steps__title">現地ご案内・物件見学</h2>
                <p class="steps__paragraph">物件がおおよそ3ヶ月以内に売れるであろう金額を算出します。査定には2種類ございます。</p>
                <span class="steps__big">●机上査定</span>
                <p class="steps__paragraph">立地や間取り、築年数など物件の情報をもとに、周辺の似たような売り出し事例や過去の取引事例、
                  市場の動向などを鑑みて査定を行います。
                  あくまで目安の金額となりますので、正確な査定金額を出すには訪問査定を行う必要があります。</p>
                <span class="steps__big">●訪問査定</span>
                <p class="steps__paragraph">実際に家を見させて頂き、物件の情報に加えて実際の不動産の状況を確認して、正確な価格を算出していきます。周辺環境や陽当り、接道状況や建物の傷み、設備など訪問して確認する事項はもちろん、権利関係や法律上の制限など役所調査が必要な内容に関しても調査させていただきます。</p>
                <img class="steps__illust" src="{{root('img/sell/sell-flowillust1.png')}}" alt="現地ご案内・物件見学">
                <a class="steps__inner-link" href="/shop">→ミック店舗ページを見る</a>
            </div>
        </div>

        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

            <div class="steps__step">
            <div class="steps__number">
                <div class="steps__inner">
                STEP<br><span>03</span>
                </div>
            </div>
            <div class="steps__text">
                <h2 class="steps__title">売却活動</h2>
                <p class="steps__paragraph">
                  物件情報交換のためのネットワーク「REINS（レインズ）」や、SUUMO・HOMESといったポータルサイト、当社サイトに物件情報を掲載します。住宅情報誌やチラシ配布でも広告活動も行います。
                  近所の方に売却を知られたくないなど、事情がある場合は広告を制限することも可能。
                </p>
            </div>
        </div>


        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

            <div class="steps__step">
            <div class="steps__number">
                <div class="steps__inner">
                STEP<br><span>04</span>
                </div>
            </div>
            <div class="steps__text">
                <h2 class="steps__title">物件の案内</h2>
                <p class="steps__paragraph">
                    実際に購入希望者の方に物件を見て頂きます。
特別準備をする必要はありませんが、掃除等はしっかり行っておくと良い印象を持たれやすいですよ。
                </p>
            </div>
        </div>

        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

            <div class="steps__step">
            <div class="steps__number"><div class="steps__inner">STEP<br><span>05</span></div></div>
            <div class="steps__text">
                <img class="steps__illust" src="{{root('img/sell/sell-flowillust2.png')}}" alt="購入希望者申し込み">
                <h2 class="steps__title">購入希望者申し込み</h2>

                <p class="steps__paragraph">購入を希望される方の申し込みを受け付けます。</p>
            </div>
        </div>

        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

              <div class="steps__step">
            <div class="steps__number"><div class="steps__inner">STEP<br><span>06</span></div>
            </div>
            <div class="steps__text">
                <h2 class="steps__title">条件相談</h2>
                <p class="steps__paragraph">
                    価格やお引渡しの時期など、契約の条件を購入されるお客様との間で調整します。
                    調整は当社担当者が行わせていただきます。
                </p>
            </div>
        </div>

        <div class="steps__arrow"><i class="fas fa-caret-down"></i></div>

                <div class="steps__step">
            <div class="steps__number">
                <div class="steps__inner">
                STEP<br><span>07</span>
                </div>
            </div>
            <div class="steps__text">
                <img class="steps__illust" src="{{root('img/sell/sell-flowillust3.png')}}" alt="売買契約締結">
                <h2 class="steps__title">売買契約締結</h2>
                <p class="steps__paragraph">
                    条件が整ったら、売主様と買主様との間で売買契約を締結していただきます。
                </p>
            </div>
        </div>

        <div class="steps__arrow">
            <i class="fas fa-caret-down"></i>
        </div>
                <div class="steps__step">
            <div class="steps__number">
                <div class="steps__inner">
                STEP<br><span>08</span>
                </div>
            </div>
            <div class="steps__text">
                <img class="steps__illust" src="{{root('img/sell/sell-flowillust4.png')}}" alt="お引渡し">
                <h2 class="steps__title">お引渡し</h2>
                <p class="steps__paragraph">
                  売却代金、ローン残債や諸費用を支払い、決済を完了した後、
買主様への物件のお引渡しと不動産登記の変更を行います。
                </p>
            </div>
        </div>

@include('sell/satei')


</div>
</div>

@endsection
